/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.common.core;

import java.math.BigInteger;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.TimeZone;
import net.snowflake.common.core.SFDate;
import net.snowflake.common.core.SFTime;
import net.snowflake.common.core.SFTimestamp;
import net.snowflake.common.core.TmExt;
import net.snowflake.common.util.Power10;

public final class SqlFormat {
    public static final int INVALID = 0;
    public static final int NUMERIC = 1;
    public static final int DATE = 2;
    public static final int TIME = 4;
    public static final int TZONE = 8;
    public static final int TS_NTZ = 6;
    public static final int TS_TZ = 14;
    public static final int NETWORK = 16;
    public static final int ANY = -1;
    public static final int DEFAULT_CENTURY_BOUNDARY = 1970;
    private static final HashMap<String, Keyword> kwMap = new HashMap();
    private static final EnumMap<Keyword, EnumSet<Keyword>> keywordConflicts;
    private String m_errorMsg = "not initialized";
    private EnumSet<Keyword> m_seen;
    private ArrayList<Fragment> m_frags;
    private int m_model = 0;
    private int m_maxOutLen;
    private int m_precision;
    private int m_scale;
    private int m_reqDigits;
    private int m_minScale;
    private boolean m_tExact;
    private static final String[] s_dayNames;
    private static final int s_maxDayNameLen = 9;
    private static final String[] s_monthNames;
    private static final int s_maxMonthNameLen = 9;
    private static final String s_spaces;

    public String getErrorMsg() {
        return this.m_errorMsg;
    }

    public int getModel() {
        return this.m_model;
    }

    public int getMaxOutputSize() {
        return this.m_maxOutLen;
    }

    public String setFormat(int model, String fmtStr) {
        this.m_model = model;
        this.m_seen = EnumSet.noneOf(Keyword.class);
        this.m_frags = new ArrayList();
        this.m_maxOutLen = 0;
        this.m_precision = 0;
        this.m_scale = 0;
        this.m_reqDigits = 0;
        this.m_minScale = 0;
        this.m_tExact = false;
        this.m_errorMsg = null;
        int fmtLen = fmtStr.length();
        if (fmtLen > 4096) {
            this.m_errorMsg = "format string is too long";
            return null;
        }
        int modelSelector = 0;
        StringBuilder literal = new StringBuilder();
        char[] fmt = fmtStr.toCharArray();
        int fmtIdx = 0;
        block19: while (fmtIdx < fmtLen) {
            Keyword kw;
            char c = fmt[fmtIdx++];
            boolean collectKw = false;
            switch (c) {
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        collectKw = true;
                        break;
                    }
                    StringBuilder errMsg = new StringBuilder("invalid character in the format string: '");
                    if (' ' <= c && c <= '~') {
                        errMsg.append(c);
                    } else {
                        errMsg.append("\\u").append(String.valueOf((int)c));
                    }
                    errMsg.append('\'');
                    this.m_errorMsg = errMsg.toString();
                    return null;
                }
                case '|': {
                    fmtLen = fmtIdx;
                    continue block19;
                }
                case '.': {
                    if (fmtIdx < fmtLen && (fmt[fmtIdx] == '0' || fmt[fmtIdx] == '9')) {
                        collectKw = true;
                        break;
                    }
                    if (this.m_seen.contains((Object)Keyword.DIGIT) || this.m_seen.contains((Object)Keyword.ZERO)) {
                        collectKw = true;
                        break;
                    }
                    literal.append(c);
                    break;
                }
                case ',': {
                    if (this.m_seen.contains((Object)Keyword.DIGIT) || this.m_seen.contains((Object)Keyword.ZERO) || this.m_seen.contains((Object)Keyword.X)) {
                        collectKw = true;
                        break;
                    }
                }
                case ' ': 
                case '(': 
                case ')': 
                case '-': 
                case '/': 
                case ':': 
                case ';': 
                case '=': {
                    literal.append(c);
                    break;
                }
                case '$': 
                case '_': {
                    collectKw = true;
                    break;
                }
                case '\"': {
                    boolean fin = false;
                    while (fmtIdx < fmtLen) {
                        if ((c = fmt[fmtIdx++]) == '\"') {
                            if (fmtIdx >= fmtLen || fmt[fmtIdx] != '\"') {
                                fin = true;
                                break;
                            }
                            ++fmtIdx;
                        }
                        literal.append(c);
                    }
                    if (fin) break;
                    StringBuilder errMsg = new StringBuilder("missing closing \" in the literal: '");
                    errMsg.append(fmt, 0, fmtLen).append('\'');
                    this.m_errorMsg = errMsg.toString();
                    return null;
                }
            }
            if (!collectKw) continue;
            if (literal.length() > 0) {
                this.m_maxOutLen += literal.length();
                this.m_frags.add(new Fragment(literal.toString()));
                literal = new StringBuilder();
            }
            if ((kw = SqlFormat.findKeyword(fmt, fmtLen, --fmtIdx, model)) == null) {
                char xc;
                int l;
                int maxLen = fmtLen - fmtIdx;
                if (maxLen > 6) {
                    maxLen = 6;
                }
                for (l = 0; l < maxLen && (Character.isLetterOrDigit(xc = fmt[l + fmtIdx]) || xc == '$' || xc == '_'); ++l) {
                }
                String mt = "";
                switch (model) {
                    default: {
                        break;
                    }
                    case 1: {
                        mt = "numeric ";
                        break;
                    }
                    case 2: {
                        mt = "date ";
                        break;
                    }
                    case 4: {
                        mt = "time ";
                        break;
                    }
                    case 6: {
                        mt = "timestamp_ntz ";
                        break;
                    }
                    case 14: {
                        mt = "timestamp ";
                    }
                }
                StringBuilder errMsg = new StringBuilder("invalid ");
                errMsg.append(mt).append("format keyword: '").append(fmt, fmtIdx, l).append('\'');
                this.m_errorMsg = errMsg.toString();
                return null;
            }
            int kwLen = kw.str.length();
            int param = 0;
            if (kw.maxParam > 0) {
                char xc;
                int oldKwLen = kwLen;
                while (fmtIdx + kwLen < fmtLen && '0' <= (xc = fmt[fmtIdx + kwLen]) && xc <= '9') {
                    ++kwLen;
                    if (param >= 10000) break;
                    param = param * 10 + (xc - 48);
                }
                if (param == 0 && oldKwLen < kwLen) {
                    StringBuilder errMsg = new StringBuilder("zero is not allowed as format parameter value: '");
                    errMsg.append(fmt, fmtIdx, kwLen).append('\'');
                    this.m_errorMsg = errMsg.toString();
                    return null;
                }
                if (param > kw.maxParam) {
                    StringBuilder errMsg = new StringBuilder("format parameter value too large: '");
                    errMsg.append(fmt, fmtIdx, kwLen).append('\'');
                    this.m_errorMsg = errMsg.toString();
                    return null;
                }
            }
            if (kw.repeat) {
                if (this.m_seen.contains((Object)Keyword.DIGIT) || this.m_seen.contains((Object)Keyword.ZERO) || this.m_seen.contains((Object)Keyword.X)) {
                    if (this.m_seen.contains((Object)Keyword.EE) || this.m_seen.contains((Object)Keyword.EEE) || this.m_seen.contains((Object)Keyword.EEEE) || this.m_seen.contains((Object)Keyword.EEEEE)) {
                        StringBuilder errMsg = new StringBuilder("digit position after an exponent format element: '");
                        errMsg.append(fmt, 0, fmtLen).append('\'');
                        this.m_errorMsg = errMsg.toString();
                        return null;
                    }
                    ++this.m_precision;
                    if (this.m_seen.contains((Object)Keyword.D) || this.m_seen.contains((Object)Keyword.DOT)) {
                        ++this.m_scale;
                        if (kw == Keyword.ZERO) {
                            this.m_minScale = this.m_scale;
                        }
                    } else if (kw == Keyword.ZERO || this.m_seen.contains((Object)Keyword.ZERO)) {
                        ++this.m_reqDigits;
                    }
                } else if (kw == Keyword.FX) {
                    this.m_tExact = !this.m_tExact;
                }
            } else {
                if (this.m_seen.contains((Object)kw)) {
                    StringBuilder errMsg = new StringBuilder("format element occurs more than once: '");
                    errMsg.append(fmt, fmtIdx, kwLen).append('\'');
                    this.m_errorMsg = errMsg.toString();
                    return null;
                }
                EnumSet<Keyword> cset = keywordConflicts.get((Object)kw);
                if (cset != null) {
                    EnumSet<Keyword> dups = EnumSet.copyOf(cset);
                    dups.retainAll(this.m_seen);
                    if (!dups.isEmpty()) {
                        StringBuilder errMsg = new StringBuilder("format element conflicts with preceding element(s): '");
                        errMsg.append(fmt, fmtIdx, kwLen).append('\'');
                        this.m_errorMsg = errMsg.toString();
                        return null;
                    }
                }
            }
            this.m_seen.add(kw);
            this.m_maxOutLen += kw == Keyword.FF && param > 0 ? param : kw.maxLen;
            int modelMask = kw.model & this.m_model;
            if ((modelMask - 1 & modelMask) == 0) {
                modelSelector |= modelMask;
            }
            int cc = 0;
            if (kw.caseSens) {
                char xc = fmt[fmtIdx];
                if ('a' <= xc && xc <= 'z') {
                    cc = 1;
                }
                if (kw.str.length() > 1 && 'a' <= (xc = fmt[fmtIdx + 1]) && xc <= 'z') {
                    cc |= 2;
                }
            }
            this.m_frags.add(new Fragment(kw, cc, param));
            fmtIdx += kwLen;
        }
        if (literal.length() > 0) {
            this.m_maxOutLen += literal.length();
            this.m_frags.add(new Fragment(literal.toString()));
        }
        if (this.m_seen.isEmpty()) {
            this.m_model = -1;
            return fmtStr.substring(fmtLen);
        }
        if (modelSelector == 0) {
            if ((this.m_model & 1) != 0 && (this.m_model & 0xE) != 0) {
                StringBuilder errMsg = new StringBuilder("ambiguous format string: '");
                errMsg.append(fmt, 0, fmtLen).append('\'');
                this.m_errorMsg = errMsg.toString();
                return null;
            }
            modelSelector = this.m_model;
        }
        switch (modelSelector) {
            case 1: {
                if (this.m_seen.contains((Object)Keyword.X)) {
                    if (this.m_seen.contains((Object)Keyword.DIGIT) || this.m_seen.contains((Object)Keyword.TM) || this.m_seen.contains((Object)Keyword.TM9) || this.m_seen.contains((Object)Keyword.TME)) {
                        StringBuilder errMsg = new StringBuilder("cannot mix hexadecimal and decimal format elements: '");
                        errMsg.append(fmt, 0, fmtLen).append('\'');
                        this.m_errorMsg = errMsg.toString();
                        return null;
                    }
                    if (this.m_seen.contains((Object)Keyword.D) || this.m_seen.contains((Object)Keyword.DOT)) {
                        StringBuilder errMsg = new StringBuilder("hexadecimal fractions are not supported: '");
                        errMsg.append(fmt, 0, fmtLen).append('\'');
                        this.m_errorMsg = errMsg.toString();
                        return null;
                    }
                    if (this.m_seen.contains((Object)Keyword.G) || this.m_seen.contains((Object)Keyword.GROUP)) {
                        StringBuilder errMsg = new StringBuilder("hexadecimal digit group separators are not supported: '");
                        errMsg.append(fmt, 0, fmtLen).append('\'');
                        this.m_errorMsg = errMsg.toString();
                        return null;
                    }
                    if (this.m_seen.contains((Object)Keyword.EE) || this.m_seen.contains((Object)Keyword.EEE) || this.m_seen.contains((Object)Keyword.EEEE) || this.m_seen.contains((Object)Keyword.EEEEE)) {
                        StringBuilder errMsg = new StringBuilder("hexadecimal exponents are not supported: '");
                        errMsg.append(fmt, 0, fmtLen).append('\'');
                        this.m_errorMsg = errMsg.toString();
                        return null;
                    }
                    ++this.m_maxOutLen;
                } else if (this.m_seen.contains((Object)Keyword.TM) || this.m_seen.contains((Object)Keyword.TM9) || this.m_seen.contains((Object)Keyword.TME)) {
                    if (this.m_seen.contains((Object)Keyword.DIGIT) || this.m_seen.contains((Object)Keyword.ZERO) || this.m_seen.contains((Object)Keyword.DOT) || this.m_seen.contains((Object)Keyword.D) || this.m_seen.contains((Object)Keyword.GROUP) || this.m_seen.contains((Object)Keyword.G) || this.m_seen.contains((Object)Keyword.EE) || this.m_seen.contains((Object)Keyword.EEE) || this.m_seen.contains((Object)Keyword.EEEE) || this.m_seen.contains((Object)Keyword.EEEEE)) {
                        StringBuilder errMsg = new StringBuilder("cannot mix TM and digit-based numeric format elements: '");
                        errMsg.append(fmt, 0, fmtLen).append('\'');
                        this.m_errorMsg = errMsg.toString();
                        return null;
                    }
                } else {
                    if (!this.m_seen.contains((Object)Keyword.DIGIT) && !this.m_seen.contains((Object)Keyword.ZERO)) {
                        StringBuilder errMsg = new StringBuilder("no digit format elements in a numeric format: '");
                        errMsg.append(fmt, 0, fmtLen).append('\'');
                        this.m_errorMsg = errMsg.toString();
                        return null;
                    }
                    ++this.m_maxOutLen;
                }
                if (this.m_precision >= 39) {
                    StringBuilder errMsg = new StringBuilder("too many digits in numeric format: '");
                    errMsg.append(fmt, 0, fmtLen).append('\'');
                    this.m_errorMsg = errMsg.toString();
                    return null;
                }
                if (this.m_reqDigits == 0 && !this.m_seen.contains((Object)Keyword.ZERO)) {
                    this.m_reqDigits = 1;
                }
                if (this.m_seen.contains((Object)Keyword.DIGIT) || this.m_seen.contains((Object)Keyword.ZERO) || this.m_seen.contains((Object)Keyword.X)) {
                    int i;
                    int last = this.m_frags.size();
                    while (last > 0) {
                        Fragment f = this.m_frags.get(--last);
                        if (f.m_elem == Keyword.FM || f.m_elem == Keyword.FX || f.m_elem == Keyword.OPTSP || f.m_elem == Keyword.LITERAL) continue;
                        break;
                    }
                    for (i = 0; i < last; ++i) {
                        Fragment f = this.m_frags.get(i);
                        if (f.m_elem != Keyword.B && f.m_elem != Keyword.FM && f.m_elem != Keyword.FX && f.m_elem != Keyword.OPTSP && f.m_elem != Keyword.LITERAL) break;
                    }
                    while (i < last) {
                        Fragment f = this.m_frags.get(i++);
                        if (f.m_elem != Keyword.LITERAL) continue;
                        if (this.m_seen.contains((Object)Keyword.X)) {
                            if (!f.m_literal.matches(".*[0-9a-fA-F].*")) continue;
                            StringBuilder errMsg = new StringBuilder("literals within hexadecimal numbers cannot  contain hex digits: '");
                            errMsg.append(fmt, 0, fmtLen).append('\'');
                            this.m_errorMsg = errMsg.toString();
                            return null;
                        }
                        if (!f.m_literal.matches(".*[0-9.,eE].*")) continue;
                        StringBuilder errMsg = new StringBuilder("literals within decimal numbers cannot contain digits, e/E, dot, and group separator: '");
                        errMsg.append(fmt, 0, fmtLen).append('\'');
                        this.m_errorMsg = errMsg.toString();
                        return null;
                    }
                }
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 14: {
                this.m_model = modelSelector;
                break;
            }
            default: {
                StringBuilder errMsg = new StringBuilder("format string includes incompatible elements: '");
                errMsg.append(fmt, 0, fmtLen).append('\'');
                this.m_errorMsg = errMsg.toString();
                return null;
            }
        }
        return fmtStr.substring(fmtLen);
    }

    public String reconstructFormat() {
        StringBuilder out = new StringBuilder();
        for (Fragment it : this.m_frags) {
            if (it.m_elem != Keyword.LITERAL) {
                if (it.m_elem.caseSens && it.m_case != 0) {
                    if ((it.m_case & 1) != 0) {
                        out.append(Character.toLowerCase(it.m_elem.str.charAt(0)));
                    } else {
                        out.append(it.m_elem.str.charAt(0));
                    }
                    if (it.m_elem.str.length() > 1) {
                        if ((it.m_case & 2) != 0) {
                            out.append(it.m_elem.str.substring(1).toLowerCase());
                        } else {
                            out.append(it.m_elem.str.substring(1));
                        }
                    }
                } else {
                    out.append(it.m_elem.str);
                }
                if (it.m_param == 0) continue;
                out.append(String.valueOf(it.m_param));
                continue;
            }
            StringCharacterIterator ci = new StringCharacterIterator(it.m_literal);
            boolean needToQuote = false;
            char c = ci.first();
            block4: while (c != '\uffff') {
                switch (c) {
                    case ' ': 
                    case '(': 
                    case ')': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case ';': {
                        break;
                    }
                    default: {
                        needToQuote = true;
                        break block4;
                    }
                }
                c = ci.next();
            }
            if (!needToQuote) {
                out.append(it.m_literal);
                continue;
            }
            out.append('\"');
            out.append(it.m_literal.replace("\"", "\"\""));
            out.append('\"');
        }
        return out.toString();
    }

    public boolean checkPrintModel(int model) {
        return this.m_model == -1 || (this.m_model & model) != 0 && (this.m_model & ~model) == 0;
    }

    public String printTm(TmExt val) {
        assert ((this.m_model & 0xFFFFFFF1) == 0 || this.m_model == -1);
        boolean fill = true;
        StringBuilder out = new StringBuilder();
        block31: for (Fragment it : this.m_frags) {
            switch (it.m_elem) {
                default: {
                    assert (false);
                }
                case LITERAL: {
                    out.append(it.m_literal);
                    break;
                }
                case OPTSP: {
                    break;
                }
                case FM: {
                    fill = !fill;
                    break;
                }
                case FX: {
                    break;
                }
                case D: {
                    int i = val.tm_wday;
                    assert (0 <= i && i < 7);
                    i = 1 + (i + 7 - 1) % 7;
                    out.append(Character.forDigit(i, 10));
                    break;
                }
                case DAY: {
                    int i = val.tm_wday;
                    assert (0 <= i && i < 7);
                    String s = s_dayNames[i];
                    if (it.m_case == 0) {
                        out.append(s);
                    } else {
                        if ((it.m_case & 1) != 0) {
                            out.append(Character.toLowerCase(s.charAt(0)));
                        } else {
                            out.append(s.charAt(0));
                        }
                        if ((it.m_case & 2) != 0) {
                            out.append(s.substring(1).toLowerCase());
                        } else {
                            out.append(s.substring(1));
                        }
                    }
                    if (!fill || (i = 9 - s.length()) <= 0) continue block31;
                    out.append(s_spaces, 0, i);
                    break;
                }
                case DD: {
                    int i = val.tm_mday;
                    assert (0 < i && i <= 31);
                    if (i >= 10 || fill) {
                        out.append(Character.forDigit(i / 10, 10));
                    }
                    out.append(Character.forDigit(i % 10, 10));
                    break;
                }
                case DDD: {
                    int i = val.tm_yday + 1;
                    assert (1 <= i && i <= 366);
                    if (fill) {
                        out.append(Character.forDigit(i / 100, 10));
                        out.append(Character.forDigit(i / 10 % 10, 10));
                    } else {
                        if (i >= 100) {
                            out.append(Character.forDigit(i / 100, 10));
                        }
                        if (i >= 10) {
                            out.append(Character.forDigit(i / 10 % 10, 10));
                        }
                    }
                    out.append(Character.forDigit(i % 10, 10));
                    break;
                }
                case DY: {
                    int i = val.tm_wday;
                    assert (0 <= i && i < 7);
                    String s = s_dayNames[i];
                    if ((it.m_case & 1) != 0) {
                        out.append(Character.toLowerCase(s.charAt(0)));
                    } else {
                        out.append(s.charAt(0));
                    }
                    if ((it.m_case & 2) != 0) {
                        out.append(Character.toLowerCase(s.charAt(1)));
                        out.append(Character.toLowerCase(s.charAt(2)));
                        break;
                    }
                    out.append(s.charAt(1));
                    out.append(s.charAt(2));
                    break;
                }
                case MM: {
                    int i = val.tm_mon + 1;
                    assert (0 < i && i <= 12);
                    if (i >= 10 || fill) {
                        out.append(Character.forDigit(i / 10, 10));
                    }
                    out.append(Character.forDigit(i % 10, 10));
                    break;
                }
                case MON: {
                    int i = val.tm_mon;
                    assert (0 <= i && i < 12);
                    String s = s_monthNames[i];
                    if ((it.m_case & 1) != 0) {
                        out.append(Character.toLowerCase(s.charAt(0)));
                    } else {
                        out.append(s.charAt(0));
                    }
                    if ((it.m_case & 2) != 0) {
                        out.append(Character.toLowerCase(s.charAt(1)));
                        out.append(Character.toLowerCase(s.charAt(2)));
                        break;
                    }
                    out.append(s.charAt(1));
                    out.append(s.charAt(2));
                    break;
                }
                case MONTH: {
                    int i = val.tm_mon;
                    assert (0 <= i && i < 12);
                    String s = s_monthNames[i];
                    if (it.m_case == 0) {
                        out.append(s);
                    } else {
                        if ((it.m_case & 1) != 0) {
                            out.append(Character.toLowerCase(s.charAt(0)));
                        } else {
                            out.append(s.charAt(0));
                        }
                        if ((it.m_case & 2) != 0) {
                            out.append(s.substring(1).toLowerCase());
                        } else {
                            out.append(s.substring(1));
                        }
                    }
                    if (!fill || (i = 9 - s.length()) <= 0) continue block31;
                    out.append(s_spaces, 0, i);
                    break;
                }
                case AD: 
                case BC: {
                    int i = val.tm_year + 1900;
                    if (i <= 0) {
                        out.append((it.m_case & 1) == 0 ? (char)'B' : 'b');
                        out.append((it.m_case & 2) == 0 ? (char)'C' : 'c');
                        break;
                    }
                    out.append((it.m_case & 1) == 0 ? (char)'A' : 'a');
                    out.append((it.m_case & 2) == 0 ? (char)'D' : 'd');
                    break;
                }
                case CE: 
                case BCE: {
                    int i = val.tm_year + 1900;
                    if (i <= 0) {
                        out.append((it.m_case & 1) == 0 ? (char)'B' : 'b');
                        out.append((it.m_case & 2) == 0 ? (char)'C' : 'c');
                        out.append((it.m_case & 2) == 0 ? (char)'E' : 'e');
                        break;
                    }
                    out.append((it.m_case & 1) == 0 ? (char)'C' : 'c');
                    out.append((it.m_case & 2) == 0 ? (char)'E' : 'e');
                    if (!fill) continue block31;
                    out.append(' ');
                    break;
                }
                case YY: {
                    int i = val.tm_year + 1900;
                    if (i <= 0) {
                        i = 1 - i;
                    }
                    out.append(Character.forDigit((i %= 100) / 10, 10));
                    out.append(Character.forDigit(i % 10, 10));
                    break;
                }
                case SYYYY: 
                case YYYY: {
                    int i = val.tm_year + 1900;
                    if (it.m_elem == Keyword.YYYY) {
                        if (i <= 0) {
                            i = !(this.m_seen.contains((Object)Keyword.AD) || this.m_seen.contains((Object)Keyword.BC) || this.m_seen.contains((Object)Keyword.BCE) || this.m_seen.contains((Object)Keyword.CE)) ? 10000 : 1 - i;
                        }
                    } else if (i < 0) {
                        i = -i;
                        out.append('-');
                    } else {
                        out.append('+');
                    }
                    if (i > 9999) {
                        out.append("####");
                        break;
                    }
                    if (fill) {
                        out.append(Character.forDigit(i / 1000, 10));
                        out.append(Character.forDigit(i / 100 % 10, 10));
                        out.append(Character.forDigit(i / 10 % 10, 10));
                    } else {
                        if (i >= 1000) {
                            out.append(Character.forDigit(i / 1000, 10));
                        }
                        if (i >= 100) {
                            out.append(Character.forDigit(i / 100 % 10, 10));
                        }
                        if (i >= 10) {
                            out.append(Character.forDigit(i / 10 % 10, 10));
                        }
                    }
                    out.append(Character.forDigit(i % 10, 10));
                    break;
                }
                case AM: 
                case PM: {
                    int i = val.tm_hour;
                    assert (0 <= i && i < 24);
                    if (i < 12) {
                        out.append((it.m_case & 1) == 0 ? (char)'A' : 'a');
                    } else {
                        out.append((it.m_case & 1) == 0 ? (char)'P' : 'p');
                    }
                    out.append((it.m_case & 2) == 0 ? (char)'M' : 'm');
                    break;
                }
                case HH: 
                case HH24: {
                    int i = val.tm_hour;
                    assert (0 <= i && i < 24);
                    if (i >= 10 || fill) {
                        out.append(Character.forDigit(i / 10, 10));
                    }
                    out.append(Character.forDigit(i % 10, 10));
                    break;
                }
                case HH12: {
                    int i = val.tm_hour;
                    assert (0 <= i && i < 24);
                    if ((i %= 12) == 0) {
                        i = 12;
                    }
                    if (i >= 10 || fill) {
                        out.append(Character.forDigit(i / 10, 10));
                    }
                    out.append(Character.forDigit(i % 10, 10));
                    break;
                }
                case MI: {
                    int i = val.tm_min;
                    assert (0 <= i && i < 60);
                    if (i >= 10 || fill) {
                        out.append(Character.forDigit(i / 10, 10));
                    }
                    out.append(Character.forDigit(i % 10, 10));
                    break;
                }
                case SS: {
                    int i = val.tm_sec;
                    assert (0 <= i && i < 60);
                    if (i >= 10 || fill) {
                        out.append(Character.forDigit(i / 10, 10));
                    }
                    out.append(Character.forDigit(i % 10, 10));
                    break;
                }
                case ES: 
                case ESA: {
                    int escale = it.m_elem == Keyword.ESA ? val.tm_sec_scale : it.m_param;
                    long es = val.tm_epochSec;
                    assert (0 <= escale && escale <= 9);
                    if (escale != 0) {
                        if (escale > 6) {
                            BigInteger li = BigInteger.valueOf(es).multiply(Power10.sb16Table[escale]);
                            li = li.add(BigInteger.valueOf(val.tm_nsec / Power10.intTable[9 - escale]));
                            out.append(li.toString());
                            break;
                        }
                        es *= (long)Power10.intTable[escale];
                        es += (long)(val.tm_nsec / Power10.intTable[9 - escale]);
                    }
                    out.append(String.valueOf(es));
                    break;
                }
                case FF: {
                    int scale;
                    int i = val.tm_nsec;
                    assert (0 <= i && i < 1000000000);
                    assert (0 <= val.tm_sec_scale && val.tm_sec_scale <= 9);
                    int n = scale = it.m_param != 0 ? it.m_param : val.tm_sec_scale;
                    if (scale < 9) {
                        i /= Power10.intTable[9 - scale];
                    }
                    while (scale-- > 0) {
                        out.append(Character.forDigit(i / Power10.intTable[scale] % 10, 10));
                    }
                    continue block31;
                }
                case TZD: {
                    String s = val.tm_zone;
                    if (s == null) {
                        s = "GMT";
                    }
                    int i = s.length();
                    assert (0 < i && i <= 5);
                    out.append(s);
                    if (!fill) continue block31;
                    out.append(s_spaces, 0, 5 - i);
                    break;
                }
                case TZH: {
                    int i = val.tm_gmtoff / 3600;
                    assert (-24 < i && i < 24);
                    if (i < 0) {
                        i = -i;
                        out.append('-');
                    } else {
                        out.append('+');
                    }
                    if (i >= 10 || fill) {
                        out.append(Character.forDigit(i / 10, 10));
                    }
                    out.append(Character.forDigit(i % 10, 10));
                    break;
                }
                case TZHTZM: {
                    int i = val.tm_gmtoff / 60;
                    assert (-1440 < i && i < 1440);
                    if (i < 0) {
                        i = -i;
                        out.append('-');
                    } else {
                        out.append('+');
                    }
                    int c = i / 60;
                    if (c >= 10 || fill) {
                        out.append(Character.forDigit(c / 10, 10));
                    }
                    out.append(Character.forDigit(c % 10, 10));
                    c = i % 60;
                    out.append(Character.forDigit(c / 10, 10));
                    out.append(Character.forDigit(c % 10, 10));
                    break;
                }
                case TZIDX: {
                    int i = val.tm_gmtoff / 60 + 1440;
                    if (i < 0 || i > 2880) {
                        i = 1440;
                    }
                    out.append(String.valueOf(i));
                    break;
                }
                case TZISO: {
                    int i = val.tm_gmtoff;
                    assert (-86400 < i && i < 86400);
                    if (i == 0) {
                        out.append('Z');
                        if (!fill) continue block31;
                        out.append("     ");
                        break;
                    }
                    if (i < 0) {
                        i = -i;
                        out.append('-');
                    } else {
                        out.append('+');
                    }
                    out.append(Character.forDigit((i /= 60) / 600, 10));
                    out.append(Character.forDigit(i / 60 % 10, 10));
                    if ((i %= 60) == 0 && !fill) continue block31;
                    out.append(':');
                    out.append(Character.forDigit(i / 10, 10));
                    out.append(Character.forDigit(i % 10, 10));
                    break;
                }
                case TZM: {
                    int i = val.tm_gmtoff;
                    if (i < 0) {
                        i = -i;
                    }
                    i /= 60;
                    out.append(Character.forDigit((i %= 60) / 10, 10));
                    out.append(Character.forDigit(i % 10, 10));
                }
            }
        }
        return out.toString();
    }

    public String printTimestamp(SFTimestamp ts, int scale, TimeZone tz) {
        assert (this.checkPrintModel(14));
        TmExt tm = new TmExt();
        tm.setTimestamp(ts, scale, tz);
        return this.printTm(tm);
    }

    public String printTimestamp(SFTimestamp ts, int scale) {
        return this.printTimestamp(ts, scale, null);
    }

    public String printTime(SFTime t, int scale) {
        assert (this.checkPrintModel(4));
        TmExt tm = new TmExt();
        tm.setTime(t, scale);
        return this.printTm(tm);
    }

    public String printDate(SFDate d) {
        assert (this.checkPrintModel(2));
        TmExt tm = new TmExt();
        tm.setDate(d);
        return this.printTm(tm);
    }

    private static int parseNum2(CharacterIterator str, boolean fill) {
        int n1 = Character.digit(str.current(), 10);
        if (n1 < 0) {
            return -1;
        }
        int n2 = Character.digit(str.next(), 10);
        if (n2 < 0) {
            return fill ? -1 : n1;
        }
        str.next();
        return n1 * 10 + n2;
    }

    private static int parseNum3(CharacterIterator str, boolean fill) {
        int n1 = Character.digit(str.current(), 10);
        if (n1 < 0) {
            return -1;
        }
        int n2 = Character.digit(str.next(), 10);
        if (n2 < 0) {
            return fill ? -1 : n1;
        }
        n1 = n1 * 10 + n2;
        n2 = Character.digit(str.next(), 10);
        if (n2 < 0) {
            return fill ? -1 : n1;
        }
        str.next();
        return n1 * 10 + n2;
    }

    private static int parseNum4(CharacterIterator str, boolean fill) {
        int n1 = Character.digit(str.current(), 10);
        if (n1 < 0) {
            return -1;
        }
        int n2 = Character.digit(str.next(), 10);
        if (n2 < 0) {
            return fill ? -1 : n1;
        }
        n1 = n1 * 10 + n2;
        n2 = Character.digit(str.next(), 10);
        if (n2 < 0) {
            return fill ? -1 : n1;
        }
        n1 = n1 * 10 + n2;
        n2 = Character.digit(str.next(), 10);
        if (n2 < 0) {
            return fill ? -1 : n1;
        }
        str.next();
        return n1 * 10 + n2;
    }

    private static boolean isPrefix(CharacterIterator str, String pref, int len) {
        StringCharacterIterator pi = new StringCharacterIterator(pref);
        int idx = str.getIndex();
        char c = str.current();
        char pc = pi.current();
        for (int i = 0; i < len; ++i) {
            if (Character.toUpperCase(c) != pc) {
                str.setIndex(idx);
                return false;
            }
            c = str.next();
            pc = pi.next();
        }
        return true;
    }

    private static int parseShortWeekDay(CharacterIterator str) {
        for (int n = 0; n < 7; ++n) {
            if (!SqlFormat.isPrefix(str, s_dayNames[n], 3)) continue;
            return n;
        }
        return -1;
    }

    private static int parseWeekDay(CharacterIterator str, boolean fill) {
        for (int n = 0; n < 7; ++n) {
            int l = s_dayNames[n].length();
            if (!SqlFormat.isPrefix(str, s_dayNames[n], l)) continue;
            if (fill) {
                char c = str.current();
                while (l < 9) {
                    if (c != ' ') {
                        return -1;
                    }
                    c = str.next();
                }
            }
            return n;
        }
        return -1;
    }

    private static int parseShortMonth(CharacterIterator str) {
        for (int n = 0; n < 12; ++n) {
            if (!SqlFormat.isPrefix(str, s_monthNames[n], 3)) continue;
            return n;
        }
        return -1;
    }

    private static int parseMonth(CharacterIterator str, boolean fill) {
        for (int n = 0; n < 12; ++n) {
            int l = s_monthNames[n].length();
            if (!SqlFormat.isPrefix(str, s_monthNames[n], l)) continue;
            if (fill) {
                char c = str.current();
                while (l < 9) {
                    if (c != ' ') {
                        return -1;
                    }
                    c = str.next();
                    ++l;
                }
            }
            return n;
        }
        return -1;
    }

    public TmExt parseTm(String inStr, int cenBound) {
        char c;
        if (this.m_model != 2 && this.m_model != 4 && this.m_model != 6 && this.m_model != 14) {
            return null;
        }
        TmExt val = new TmExt();
        val.tm_isdst = -1;
        StringCharacterIterator str = new StringCharacterIterator(inStr);
        boolean spacesIgnored = false;
        if (this.m_frags.isEmpty() || this.m_frags.get((int)0).m_elem != Keyword.FX) {
            c = str.current();
            while (c != '\uffff' && Character.isWhitespace(c)) {
                c = str.next();
                spacesIgnored = true;
            }
        }
        boolean fill = true;
        boolean exact = false;
        boolean bce = false;
        boolean pm = false;
        block33: for (Fragment it : this.m_frags) {
            boolean ignoreSpaces = false;
            switch (it.m_elem) {
                default: {
                    assert (false);
                }
                case OPTSP: {
                    if (exact) continue block33;
                    ignoreSpaces = true;
                    break;
                }
                case LITERAL: {
                    StringCharacterIterator fs = new StringCharacterIterator(it.m_literal);
                    char fc = fs.current();
                    c = str.current();
                    if (exact) {
                        if (spacesIgnored) {
                            while (fc == ' ') {
                                fc = fs.next();
                            }
                        }
                        while (fc != '\uffff') {
                            if (c == '\uffff' || Character.toUpperCase(c) != Character.toUpperCase(fc)) {
                                return null;
                            }
                            c = str.next();
                            fc = fs.next();
                        }
                    } else {
                        while (fc != '\uffff') {
                            if (fc == ' ') {
                                if (!spacesIgnored) {
                                    spacesIgnored = true;
                                    if (c != ' ') {
                                        return null;
                                    }
                                    while ((c = str.next()) == ' ') {
                                    }
                                }
                                fc = fs.next();
                                continue;
                            }
                            if (c == '\uffff' || Character.toUpperCase(c) != Character.toUpperCase(fc)) {
                                return null;
                            }
                            c = str.next();
                            fc = fs.next();
                            spacesIgnored = false;
                        }
                    }
                    break;
                }
                case FM: {
                    fill = !fill;
                    continue block33;
                }
                case FX: {
                    exact = !exact;
                    continue block33;
                }
                case AD: 
                case BC: {
                    c = str.current();
                    if (c == 'A' || c == 'a') {
                        bce = false;
                    } else if (c == 'B' || c == 'b') {
                        bce = true;
                    } else {
                        return null;
                    }
                    c = str.next();
                    if (c == 'D' || c == 'd') {
                        if (bce) {
                            return null;
                        }
                    } else if (c == 'C' || c == 'c') {
                        if (!bce) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                    str.next();
                    break;
                }
                case CE: 
                case BCE: {
                    c = str.current();
                    bce = false;
                    if (c == 'B' || c == 'b') {
                        bce = true;
                        c = str.next();
                    }
                    if (c != 'C' && c != 'c') {
                        return null;
                    }
                    c = str.next();
                    if (c != 'E' && c != 'e') {
                        return null;
                    }
                    c = str.next();
                    if (!exact) {
                        ignoreSpaces = true;
                        break;
                    }
                    if (!fill || bce) break;
                    if (c != ' ') {
                        return null;
                    }
                    str.next();
                    break;
                }
                case D: {
                    int n = Character.digit(str.current(), 10);
                    if (n < 1 || n > 7) {
                        return null;
                    }
                    str.next();
                    val.tm_wday = n % 7;
                    break;
                }
                case DAY: {
                    val.tm_wday = SqlFormat.parseWeekDay(str, exact && fill);
                    if (val.tm_wday < 0) {
                        return null;
                    }
                    if (exact) break;
                    ignoreSpaces = true;
                    break;
                }
                case DD: {
                    val.tm_mday = SqlFormat.parseNum2(str, exact && fill);
                    if (val.tm_mday >= 1 && val.tm_mday <= 31) break;
                    return null;
                }
                case DDD: {
                    val.tm_yday = SqlFormat.parseNum3(str, exact && fill);
                    if (val.tm_yday >= 1 && val.tm_yday <= 366) break;
                    return null;
                }
                case DY: {
                    val.tm_wday = SqlFormat.parseShortWeekDay(str);
                    if (val.tm_wday >= 0) break;
                    return null;
                }
                case MM: {
                    val.tm_mon = SqlFormat.parseNum2(str, exact && fill);
                    if (val.tm_mon < 1 || val.tm_mon > 12) {
                        return null;
                    }
                    --val.tm_mon;
                    break;
                }
                case MON: {
                    val.tm_mon = SqlFormat.parseShortMonth(str);
                    if (val.tm_mon >= 0) break;
                    return null;
                }
                case MONTH: {
                    val.tm_mon = SqlFormat.parseMonth(str, exact && fill);
                    if (val.tm_mon < 0) {
                        return null;
                    }
                    if (exact) break;
                    ignoreSpaces = true;
                    break;
                }
                case YY: {
                    val.tm_year = SqlFormat.parseNum2(str, true);
                    if (val.tm_year < 0) {
                        return null;
                    }
                    if (val.tm_year < cenBound % 100) {
                        val.tm_year += 100;
                    }
                    val.tm_year += cenBound / 100 * 100;
                    break;
                }
                case SYYYY: {
                    c = str.current();
                    if (c != '+' && c != '-') {
                        return null;
                    }
                    str.next();
                    val.tm_year = SqlFormat.parseNum4(str, exact && fill);
                    if (val.tm_year < 0) {
                        return null;
                    }
                    if (c != '-') break;
                    if (val.tm_year >= 9999) {
                        return null;
                    }
                    val.tm_year *= -1;
                    break;
                }
                case YYYY: {
                    val.tm_year = SqlFormat.parseNum4(str, exact && fill);
                    if (val.tm_year > 0) break;
                    return null;
                }
                case AM: 
                case PM: {
                    c = str.current();
                    if (c == 'A' || c == 'a') {
                        pm = false;
                    } else if (c == 'P' || c == 'p') {
                        pm = true;
                    } else {
                        return null;
                    }
                    c = str.next();
                    if (c != 'M' && c != 'm') {
                        return null;
                    }
                    str.next();
                    break;
                }
                case HH: 
                case HH24: {
                    val.tm_hour = SqlFormat.parseNum2(str, exact && fill);
                    if (val.tm_hour >= 0 && val.tm_hour < 24) break;
                    return null;
                }
                case HH12: {
                    val.tm_hour = SqlFormat.parseNum2(str, exact && fill);
                    if (val.tm_hour >= 1 && val.tm_hour <= 12) break;
                    return null;
                }
                case MI: {
                    val.tm_min = SqlFormat.parseNum2(str, exact && fill);
                    if (val.tm_min >= 0 && val.tm_min < 60) break;
                    return null;
                }
                case SS: {
                    val.tm_sec = SqlFormat.parseNum2(str, exact && fill);
                    if (val.tm_sec >= 0 && val.tm_sec < 60) break;
                    return null;
                }
                case ES: 
                case ESA: {
                    int n;
                    int d = 0;
                    boolean neg = false;
                    c = str.current();
                    if (c == '-' || c == '+') {
                        neg = c == '-';
                        c = str.next();
                    }
                    BigInteger es = BigInteger.ZERO;
                    while ((n = Character.digit(c, 10)) >= 0) {
                        es = es.multiply(BigInteger.TEN).add(BigInteger.valueOf(n));
                        ++d;
                        c = str.next();
                    }
                    if (d > 38) {
                        return null;
                    }
                    int scale = it.m_param;
                    if (it.m_elem == Keyword.ESA) {
                        scale = 0;
                        BigInteger limit = BigInteger.valueOf(31536000000L);
                        while (es.compareTo(limit) > 0) {
                            scale += 3;
                            limit = limit.multiply(BigInteger.valueOf(1000L));
                        }
                    }
                    if (scale > 9) {
                        return null;
                    }
                    if (scale > 0) {
                        BigInteger rem = es;
                        BigInteger q = Power10.sb16Table[scale];
                        if (neg) {
                            rem = es.negate();
                            es = rem.subtract(q).add(BigInteger.ONE);
                        }
                        es = es.divide(q);
                        rem = rem.subtract(es.multiply(q));
                        val.tm_nsec = rem.intValue() * Power10.intTable[9 - scale];
                    } else if (neg) {
                        es = es.negate();
                    }
                    if (es.compareTo(BigInteger.valueOf(-377673494400L)) < 0 || es.compareTo(BigInteger.valueOf(253402214400L)) > 0) {
                        return null;
                    }
                    val.tm_epochSec = es.longValue();
                    val.tm_has_epochSec = true;
                    val.tm_sec_scale = scale;
                    break;
                }
                case FF: {
                    int d;
                    int n;
                    c = str.current();
                    assert (it.m_param <= 9);
                    if (exact && it.m_param != 0) {
                        int fsec = 0;
                        for (d = 0; d < it.m_param; ++d) {
                            n = Character.digit(c, 10);
                            if (n < 0) {
                                return null;
                            }
                            fsec = fsec * 10 + n;
                            c = str.next();
                        }
                        val.tm_sec_scale = it.m_param;
                        val.tm_nsec = fsec * Power10.intTable[9 - it.m_param];
                        break;
                    }
                    int fsec = 0;
                    d = 0;
                    while ((n = Character.digit(c, 10)) >= 0) {
                        fsec = fsec * 10 + n;
                        ++d;
                        c = str.next();
                    }
                    if (d > 9) {
                        return null;
                    }
                    val.tm_sec_scale = d;
                    val.tm_nsec = fsec * Power10.intTable[9 - d];
                    break;
                }
                case TZD: {
                    StringBuilder tzd = new StringBuilder();
                    c = str.current();
                    int n = 0;
                    while ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                        tzd.append(Character.toUpperCase(c));
                        c = str.next();
                        if (++n < 5) continue;
                    }
                    if (n == 0) {
                        return null;
                    }
                    val.tm_zone = tzd.toString();
                    if (!exact) {
                        ignoreSpaces = true;
                        break;
                    }
                    if (!fill) break;
                    for (n = 5 - n; n > 0; --n) {
                        if (c != ' ') {
                            return null;
                        }
                        c = str.next();
                    }
                    break;
                }
                case TZH: {
                    c = str.current();
                    if (c != '+' && c != '-') {
                        return null;
                    }
                    str.next();
                    int n = SqlFormat.parseNum2(str, exact && fill);
                    if (n < 0 || n > 23) {
                        return null;
                    }
                    val.tm_gmtoff += n * 3600;
                    if (c == '-') {
                        val.tm_gmtoff *= -1;
                    }
                    val.tm_has_offset = true;
                    break;
                }
                case TZHTZM: {
                    c = str.current();
                    if (c != '+' && c != '-') {
                        return null;
                    }
                    str.next();
                    int n = SqlFormat.parseNum4(str, exact && fill);
                    if (n < 0 || n / 100 >= 24 || n % 100 >= 60) {
                        return null;
                    }
                    val.tm_gmtoff = n % 100 * 60;
                    val.tm_gmtoff += n / 100 * 3600;
                    if (c == '-') {
                        val.tm_gmtoff *= -1;
                    }
                    val.tm_has_offset = true;
                    break;
                }
                case TZIDX: {
                    int n = SqlFormat.parseNum4(str, false);
                    if (n < 0) {
                        return null;
                    }
                    if (n > 2880) {
                        n = 1440;
                    }
                    val.tm_gmtoff = (n - 1440) * 60;
                    val.tm_has_offset = true;
                    val.tm_has_tzidx = true;
                    break;
                }
                case TZISO: {
                    int n;
                    c = str.current();
                    if (c == 'Z' || c == 'z') {
                        str.next();
                        val.tm_gmtoff = 0;
                        n = 5;
                    } else {
                        if (c != '+' && c != '-') {
                            return null;
                        }
                        str.next();
                        n = SqlFormat.parseNum2(str, true);
                        if (n < 0 || n >= 24) {
                            return null;
                        }
                        val.tm_gmtoff = n * 3600;
                        n = 2;
                        char sc = str.current();
                        if (sc == ':' || Character.isDigit(sc)) {
                            int m;
                            n = 1;
                            if (sc == ':') {
                                n = 0;
                                str.next();
                            }
                            if ((m = SqlFormat.parseNum2(str, true)) < 0 || m >= 60) {
                                return null;
                            }
                            val.tm_gmtoff += m * 60;
                        }
                        if (c == '-') {
                            val.tm_gmtoff *= -1;
                        }
                    }
                    val.tm_has_offset = true;
                    if (!exact) {
                        ignoreSpaces = true;
                        break;
                    }
                    if (!fill) break;
                    c = str.current();
                    while (n-- > 0) {
                        if (c != ' ') {
                            return null;
                        }
                        c = str.next();
                    }
                    break;
                }
                case TZM: {
                    int n = SqlFormat.parseNum2(str, exact && fill);
                    if (n < 0 || n > 59) {
                        return null;
                    }
                    if (val.tm_gmtoff < 0) {
                        n = -n;
                    }
                    val.tm_gmtoff += n * 60;
                }
            }
            if (ignoreSpaces) {
                c = str.current();
                while (c == ' ') {
                    spacesIgnored = true;
                    c = str.next();
                }
                continue;
            }
            spacesIgnored = false;
        }
        if (exact) {
            if (str.current() != '\uffff') {
                return null;
            }
        } else {
            c = str.current();
            while (c != '\uffff') {
                if (!Character.isWhitespace(c)) {
                    return null;
                }
                c = str.next();
            }
        }
        if (this.m_seen.contains((Object)Keyword.HH12)) {
            if (val.tm_hour == 12) {
                val.tm_hour = 0;
            }
            if (pm) {
                val.tm_hour += 12;
            }
        }
        if (bce && val.tm_year > 0) {
            val.tm_year *= -1;
            ++val.tm_year;
        }
        val.tm_year -= 1900;
        return val;
    }

    public TmExt parseTm(String inStr) {
        return this.parseTm(inStr, 1970);
    }

    public SFDate parseDate(String str, int cenBound) {
        TmExt tm = this.parseTm(str, cenBound);
        if (tm == null) {
            return null;
        }
        return tm.getDate();
    }

    public SFDate parseDate(String str) {
        return this.parseDate(str, 1970);
    }

    public SFTime parseTime(String str) {
        TmExt tm = this.parseTm(str, 1970);
        if (tm == null) {
            return null;
        }
        return tm.getTime();
    }

    public SFTimestamp parseTimestamp(String str, TimeZone tz, int cenBound) {
        TmExt tm = this.parseTm(str, cenBound);
        if (tm == null) {
            return null;
        }
        return tm.getTimestamp(tz);
    }

    public SFTimestamp parseTimestamp(String str, TimeZone tz) {
        return this.parseTimestamp(str, tz, 1970);
    }

    private boolean canScanTime() {
        if (!this.m_seen.contains((Object)Keyword.MI)) {
            return false;
        }
        if (this.m_seen.contains((Object)Keyword.HH) || this.m_seen.contains((Object)Keyword.HH24)) {
            return true;
        }
        if (!this.m_seen.contains((Object)Keyword.HH12)) {
            return false;
        }
        return this.m_seen.contains((Object)Keyword.AM) || this.m_seen.contains((Object)Keyword.PM);
    }

    private boolean canScanOptionalTime() {
        if (this.m_seen.contains((Object)Keyword.HH) || this.m_seen.contains((Object)Keyword.HH12) || this.m_seen.contains((Object)Keyword.HH24) || this.m_seen.contains((Object)Keyword.AM) || this.m_seen.contains((Object)Keyword.PM) || this.m_seen.contains((Object)Keyword.MI) || this.m_seen.contains((Object)Keyword.SS)) {
            return this.canScanTime();
        }
        return !this.m_seen.contains((Object)Keyword.FF) || this.m_seen.contains((Object)Keyword.ES);
    }

    private boolean canScanDate() {
        if (this.m_seen.contains((Object)Keyword.ES) || this.m_seen.contains((Object)Keyword.ESA)) {
            return !this.m_seen.contains((Object)Keyword.YY) && !this.m_seen.contains((Object)Keyword.YYYY) && !this.m_seen.contains((Object)Keyword.SYYYY) && !this.m_seen.contains((Object)Keyword.BC) && !this.m_seen.contains((Object)Keyword.AD) && !this.m_seen.contains((Object)Keyword.BCE) && !this.m_seen.contains((Object)Keyword.CE) && !this.m_seen.contains((Object)Keyword.MONTH) && !this.m_seen.contains((Object)Keyword.MON) && !this.m_seen.contains((Object)Keyword.MM) && !this.m_seen.contains((Object)Keyword.DAY) && !this.m_seen.contains((Object)Keyword.DY) && !this.m_seen.contains((Object)Keyword.DD) && !this.m_seen.contains((Object)Keyword.DDD) && !this.m_seen.contains((Object)Keyword.HH) && !this.m_seen.contains((Object)Keyword.HH24) && !this.m_seen.contains((Object)Keyword.HH12) && !this.m_seen.contains((Object)Keyword.AM) && !this.m_seen.contains((Object)Keyword.PM) && !this.m_seen.contains((Object)Keyword.MI) && !this.m_seen.contains((Object)Keyword.SS);
        }
        return !(!this.m_seen.contains((Object)Keyword.YY) && !this.m_seen.contains((Object)Keyword.YYYY) && !this.m_seen.contains((Object)Keyword.SYYYY) || !this.m_seen.contains((Object)Keyword.MONTH) && !this.m_seen.contains((Object)Keyword.MON) && !this.m_seen.contains((Object)Keyword.MM) || !this.m_seen.contains((Object)Keyword.DD));
    }

    public boolean checkScanModel(int model) {
        switch (model) {
            case 1: {
                return this.m_model == 1;
            }
            case 4: {
                return this.m_model == 4 && this.canScanTime();
            }
            case 2: {
                return this.m_model == 2 && this.canScanDate();
            }
            case 6: 
            case 14: {
                return (this.m_model & 2) != 0 && (this.m_model & 0xFFFFFFF1) == 0 && this.canScanDate() && this.canScanOptionalTime();
            }
        }
        return false;
    }

    private static Keyword findKeyword(char[] fmt, int fmtLen, int fmtIdx, int model) {
        int maxLen = fmtLen - fmtIdx;
        if (maxLen > 6) {
            maxLen = 6;
        }
        for (int l = maxLen; l > 0; --l) {
            Keyword kw = kwMap.get(new String(fmt, fmtIdx, l).toUpperCase());
            if (kw == null || (kw.model & model) == 0) continue;
            return kw;
        }
        return null;
    }

    static {
        for (Keyword kw : Keyword.values()) {
            if (kw.str.length() <= 0) continue;
            kwMap.put(kw.str, kw);
        }
        keywordConflicts = new EnumMap(Keyword.class);
        keywordConflicts.put(Keyword.DOT, EnumSet.of(Keyword.D));
        keywordConflicts.put(Keyword.AD, EnumSet.of(Keyword.BC, Keyword.BCE, Keyword.CE, Keyword.SYYYY));
        keywordConflicts.put(Keyword.AM, EnumSet.of(Keyword.PM));
        keywordConflicts.put(Keyword.BC, EnumSet.of(Keyword.AD, Keyword.BCE, Keyword.CE, Keyword.SYYYY));
        keywordConflicts.put(Keyword.BCE, EnumSet.of(Keyword.AD, Keyword.BC, Keyword.CE, Keyword.SYYYY));
        keywordConflicts.put(Keyword.CE, EnumSet.of(Keyword.AD, Keyword.BC, Keyword.BCE, Keyword.SYYYY));
        keywordConflicts.put(Keyword.D, EnumSet.of(Keyword.DOT));
        keywordConflicts.put(Keyword.EE, EnumSet.of(Keyword.EEE, Keyword.EEEE, Keyword.EEEEE));
        keywordConflicts.put(Keyword.EEE, EnumSet.of(Keyword.EE, Keyword.EEEE, Keyword.EEEEE));
        keywordConflicts.put(Keyword.EEEE, EnumSet.of(Keyword.EE, Keyword.EEE, Keyword.EEEEE));
        keywordConflicts.put(Keyword.EEEEE, EnumSet.of(Keyword.EE, Keyword.EEE, Keyword.EEEE));
        keywordConflicts.put(Keyword.ES, EnumSet.of(Keyword.ESA));
        keywordConflicts.put(Keyword.ESA, EnumSet.of(Keyword.ES));
        keywordConflicts.put(Keyword.HH, EnumSet.of(Keyword.HH12, Keyword.HH24));
        keywordConflicts.put(Keyword.HH12, EnumSet.of(Keyword.HH, Keyword.HH24));
        keywordConflicts.put(Keyword.HH24, EnumSet.of(Keyword.HH, Keyword.HH12));
        keywordConflicts.put(Keyword.MI, EnumSet.of(Keyword.S));
        keywordConflicts.put(Keyword.MON, EnumSet.of(Keyword.MONTH));
        keywordConflicts.put(Keyword.MONTH, EnumSet.of(Keyword.MON));
        keywordConflicts.put(Keyword.PM, EnumSet.of(Keyword.AM));
        keywordConflicts.put(Keyword.S, EnumSet.of(Keyword.MI));
        keywordConflicts.put(Keyword.SYYYY, EnumSet.of(Keyword.AD, new Keyword[]{Keyword.BC, Keyword.CE, Keyword.BCE, Keyword.YY, Keyword.YYYY}));
        keywordConflicts.put(Keyword.TM, EnumSet.of(Keyword.TM9, Keyword.TME));
        keywordConflicts.put(Keyword.TM9, EnumSet.of(Keyword.TM, Keyword.TME));
        keywordConflicts.put(Keyword.TME, EnumSet.of(Keyword.TM, Keyword.TM9));
        keywordConflicts.put(Keyword.TZH, EnumSet.of(Keyword.TZHTZM, Keyword.TZIDX, Keyword.TZISO));
        keywordConflicts.put(Keyword.TZHTZM, EnumSet.of(Keyword.TZH, Keyword.TZIDX, Keyword.TZISO, Keyword.TZM));
        keywordConflicts.put(Keyword.TZIDX, EnumSet.of(Keyword.TZH, Keyword.TZHTZM, Keyword.TZISO, Keyword.TZM));
        keywordConflicts.put(Keyword.TZISO, EnumSet.of(Keyword.TZH, Keyword.TZHTZM, Keyword.TZIDX, Keyword.TZM));
        keywordConflicts.put(Keyword.TZM, EnumSet.of(Keyword.TZHTZM, Keyword.TZIDX, Keyword.TZISO));
        keywordConflicts.put(Keyword.YY, EnumSet.of(Keyword.SYYYY, Keyword.YYYY));
        keywordConflicts.put(Keyword.YYYY, EnumSet.of(Keyword.SYYYY, Keyword.YY));
        s_dayNames = new String[]{"SUNDAY", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY"};
        s_monthNames = new String[]{"JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER"};
        s_spaces = "         ";
    }

    private static class Fragment {
        public Keyword m_elem;
        public String m_literal;
        public int m_case;
        public int m_param;

        public Fragment(String str) {
            this.m_elem = Keyword.LITERAL;
            this.m_literal = str;
            this.m_case = 0;
            this.m_param = 0;
        }

        public Fragment(Keyword kw, int ci, int p) {
            this.m_elem = kw;
            this.m_literal = null;
            this.m_case = ci;
            this.m_param = p;
        }
    }

    private static enum Keyword {
        DLR(false, "$", 1, 1, false),
        GROUP(false, ",", 1, 1, true),
        DOT(false, ".", 1, 1, false),
        ZERO(false, "0", 1, 1, true),
        DIGIT(false, "9", 1, 1, true),
        AD(true, "AD", 2, 2, false),
        AM(true, "AM", 2, 4, false),
        B(false, "B", 0, 1, false),
        BC(true, "BC", 2, 2, false),
        BCE(true, "BCE", 3, 2, false),
        CE(true, "CE", 3, 2, false),
        D(false, "D", 1, 3, false),
        DAY(true, "DAY", 9, 2, false),
        DD(false, "DD", 2, 2, false),
        DDD(false, "DDD", 3, 2, false),
        DY(true, "DY", 3, 2, false),
        EE(true, "EE", 5, 1, false),
        EEE(true, "EEE", 3, 1, false),
        EEEE(true, "EEEE", 4, 1, false),
        EEEEE(true, "EEEEE", 5, 1, false),
        ES(false, "ES", 18, 2, false, 9),
        ESA(false, "ESA", 18, 2, false),
        FF(false, "FF", 9, 4, false, 9),
        FM(false, "FM", 0, -1, true),
        FX(false, "FX", 0, -1, true),
        G(false, "G", 1, 1, true),
        HH(false, "HH", 2, 4, false),
        HH12(false, "HH12", 2, 4, false),
        HH24(false, "HH24", 2, 4, false),
        MI(false, "MI", 2, 5, false),
        MM(false, "MM", 2, 2, false),
        MON(true, "MON", 3, 2, false),
        MONTH(true, "MONTH", 9, 2, false),
        PM(true, "PM", 2, 4, false),
        S(false, "S", 0, 1, false),
        SS(false, "SS", 2, 4, false),
        SYYYY(false, "SYYYY", 5, 2, false),
        TM(true, "TM", 64, 1, false),
        TM9(true, "TM9", 64, 1, false),
        TME(true, "TME", 64, 1, false),
        TZD(false, "TZD", 5, 8, false),
        TZH(false, "TZH", 3, 8, false),
        TZHTZM(false, "TZHTZM", 5, 8, false),
        TZIDX(false, "TZIDX", 4, 8, false),
        TZISO(false, "TZISO", 6, 8, false),
        TZM(false, "TZM", 2, 8, false),
        X(true, "X", 1, 1, true),
        YY(false, "YY", 2, 2, false),
        YYYY(false, "YYYY", 4, 2, false),
        OPTSP(false, "_", 0, -1, true),
        LITERAL(false, "", 0, -1, true);

        public static final int MAX_KW_LEN = 6;
        public final boolean caseSens;
        public final String str;
        public final int maxLen;
        public final int model;
        public final boolean repeat;
        public final int maxParam;

        private Keyword(boolean caseSens_, String str_, int maxLen_, int model_, boolean repeat_) {
            this.caseSens = caseSens_;
            this.str = str_;
            this.maxLen = maxLen_;
            this.model = model_;
            this.repeat = repeat_;
            this.maxParam = 0;
        }

        private Keyword(boolean caseSens_, String str_, int maxLen_, int model_, boolean repeat_, int maxParam_) {
            this.caseSens = caseSens_;
            this.str = str_;
            this.maxLen = maxLen_;
            this.model = model_;
            this.repeat = repeat_;
            this.maxParam = maxParam_;
        }
    }
}

