/*
 * Copyright (c) 2015 Snowflake Computing Inc. All right reserved.
 */
package net.snowflake.common.core;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A class to manage encryption material for S3 files for GET and PUT commands.
 *
 * @author elin/ffunke
 */
public class RemoteStoreFileEncryptionMaterialUI extends RemoteStoreFileEncryptionMaterial {
  private String randomSeed;

  public RemoteStoreFileEncryptionMaterialUI(
      String queryStageMasterKey, String queryId, Long smkId, String randomSeed) {
    super(queryStageMasterKey, queryId, smkId);
    this.randomSeed = randomSeed;
  }

  public RemoteStoreFileEncryptionMaterialUI() {}

  @JsonProperty("randomSeed")
  public String getRandomSeed() {
    return randomSeed;
  }

  public void setRandomSeed(String randomSeed) {
    this.randomSeed = randomSeed;
  }
}
