package net.snowflake.common.core;

/**
 * Represents VARIANT value Currently only supports empty non-elementary values Instances of this
 * class are immutable
 *
 * @author avg
 */
public class SFVariant {
  /** Variant value type */
  public enum VType {
    ANY,
    ARRAY,
    OBJECT
  };

  public static final SFVariant SFVARIANT_ANY = new SFVariant(VType.ANY);
  public static final SFVariant SFVARIANT_ARRAY = new SFVariant(VType.ARRAY);
  public static final SFVariant SFVARIANT_OBJECT = new SFVariant(VType.OBJECT);

  /**
   * Construct empty variant value of a given type
   *
   * @param vtype variant type
   */
  public SFVariant(VType vtype) {
    this.vtype_ = vtype;
  }

  /**
   * Get the variant value type
   *
   * @return variant type
   */
  public VType getVType() {
    return this.vtype_;
  }

  /**
   * Compare for equality
   *
   * @param other target SFVariant
   * @return true if equal otherwise false
   */
  @Override
  public boolean equals(Object other) {
    if (!(other instanceof SFVariant)) {
      return false;
    }
    return this.vtype_ == ((SFVariant) other).vtype_;
  }

  private final VType vtype_;

  /** {@inheritDoc} */
  public int hashCode() {
    switch (vtype_) {
      case ANY:
        return 1;
      case ARRAY:
        return 2;
      case OBJECT:
        return 3;
    }

    return 0;
  }
}
