/*
 * Copyright (c) 2016 Snowflake Computing Inc. All right reserved.
 */
package net.snowflake.common.util;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Interface for logger implementations.
 *
 * @author mkember
 */
public interface GenericGSCommonLogger {
  void log(Level level, String message);
}

/**
 * Wrapper around java.util.logging.Logger.
 *
 * @author mkember
 */
class JavaGSCommonLogger implements GenericGSCommonLogger {
  private final Logger logger;

  public JavaGSCommonLogger(String name) {
    logger = Logger.getLogger(name);
  }

  public void log(Level level, String message) {
    logger.log(level, message);
  }
}
