/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.http.impl.conn;

import java.io.IOException;
import net.snowflake.ingest.internal.apache.http.Consts;
import net.snowflake.ingest.internal.apache.http.annotation.Contract;
import net.snowflake.ingest.internal.apache.http.annotation.ThreadingBehavior;
import net.snowflake.ingest.internal.apache.http.impl.conn.Wire;
import net.snowflake.ingest.internal.apache.http.io.HttpTransportMetrics;
import net.snowflake.ingest.internal.apache.http.io.SessionOutputBuffer;
import net.snowflake.ingest.internal.apache.http.util.CharArrayBuffer;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class LoggingSessionOutputBuffer
implements SessionOutputBuffer {
    private final SessionOutputBuffer out;
    private final Wire wire;
    private final String charset;

    public LoggingSessionOutputBuffer(SessionOutputBuffer out, Wire wire, String charset) {
        this.out = out;
        this.wire = wire;
        this.charset = charset != null ? charset : Consts.ASCII.name();
    }

    public LoggingSessionOutputBuffer(SessionOutputBuffer out, Wire wire) {
        this(out, wire, null);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        if (this.wire.enabled()) {
            this.wire.output(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        if (this.wire.enabled()) {
            this.wire.output(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        if (this.wire.enabled()) {
            this.wire.output(b);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void writeLine(CharArrayBuffer buffer) throws IOException {
        this.out.writeLine(buffer);
        if (this.wire.enabled()) {
            String s2 = new String(buffer.buffer(), 0, buffer.length());
            String tmp = s2 + "\r\n";
            this.wire.output(tmp.getBytes(this.charset));
        }
    }

    @Override
    public void writeLine(String s2) throws IOException {
        this.out.writeLine(s2);
        if (this.wire.enabled()) {
            String tmp = s2 + "\r\n";
            this.wire.output(tmp.getBytes(this.charset));
        }
    }

    @Override
    public HttpTransportMetrics getMetrics() {
        return this.out.getMetrics();
    }
}

