/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.utils;

import java.security.Security;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.snowflake.ingest.internal.apache.http.HttpHost;
import net.snowflake.ingest.internal.apache.http.HttpRequest;
import net.snowflake.ingest.internal.apache.http.HttpResponse;
import net.snowflake.ingest.internal.apache.http.NoHttpResponseException;
import net.snowflake.ingest.internal.apache.http.client.HttpClient;
import net.snowflake.ingest.internal.apache.http.client.HttpRequestRetryHandler;
import net.snowflake.ingest.internal.apache.http.client.ServiceUnavailableRetryStrategy;
import net.snowflake.ingest.internal.apache.http.client.protocol.HttpClientContext;
import net.snowflake.ingest.internal.apache.http.conn.ssl.DefaultHostnameVerifier;
import net.snowflake.ingest.internal.apache.http.conn.ssl.SSLConnectionSocketFactory;
import net.snowflake.ingest.internal.apache.http.impl.client.HttpClientBuilder;
import net.snowflake.ingest.internal.apache.http.impl.client.HttpClients;
import net.snowflake.ingest.internal.apache.http.impl.conn.DefaultProxyRoutePlanner;
import net.snowflake.ingest.internal.apache.http.protocol.HttpContext;
import net.snowflake.ingest.internal.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static String USE_PROXY = "http.useProxy";
    private static String PROXY_HOST = "http.proxyHost";
    private static String PROXY_PORT = "http.proxyPort";
    private static String PROXY_SCHEME = "http";
    private static int MAX_RETRIES = 3;
    private static HttpClient httpClient;
    private static final Logger LOGGER;

    public static HttpClient getHttpClient() {
        if (httpClient == null) {
            HttpUtil.initHttpClient();
        }
        return httpClient;
    }

    private static void initHttpClient() {
        Security.setProperty("ocsp.enable", "true");
        SSLContext sslContext = SSLContexts.createDefault();
        SSLConnectionSocketFactory f = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, (HostnameVerifier)new DefaultHostnameVerifier());
        HttpClientBuilder clientBuilder = HttpClients.custom().setSSLSocketFactory(f).setServiceUnavailableRetryStrategy(HttpUtil.getServiceUnavailableRetryStrategy()).setRetryHandler(HttpUtil.getHttpRequestRetryHandler());
        if ("true".equalsIgnoreCase(System.getProperty(USE_PROXY))) {
            if (System.getProperty(PROXY_PORT) == null) {
                throw new IllegalArgumentException("proxy port number is not provided, please assign proxy port to http.proxyPort option");
            }
            if (System.getProperty(PROXY_HOST) == null) {
                throw new IllegalArgumentException("proxy host IP is not provided, please assign proxy host IP to http.proxyHost option");
            }
            String proxyHost = System.getProperty(PROXY_HOST);
            int proxyPort = Integer.parseInt(System.getProperty(PROXY_PORT));
            HttpHost proxy = new HttpHost(proxyHost, proxyPort, PROXY_SCHEME);
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            clientBuilder = clientBuilder.setRoutePlanner(routePlanner);
        }
        httpClient = clientBuilder.build();
    }

    private static ServiceUnavailableRetryStrategy getServiceUnavailableRetryStrategy() {
        return new ServiceUnavailableRetryStrategy(){
            private int executionCount = 0;
            int REQUEST_TIMEOUT = 408;

            @Override
            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                boolean needNextRetry;
                this.executionCount = executionCount;
                int statusCode = response.getStatusLine().getStatusCode();
                LOGGER.info("In retryRequest for service unavailability with statusCode:{} and uri:{}", (Object)statusCode, (Object)HttpUtil.getRequestUriFromContext(context));
                if (executionCount == MAX_RETRIES + 1) {
                    LOGGER.info("Reached the max retry time, not retrying anymore");
                    return false;
                }
                boolean bl = needNextRetry = (statusCode == this.REQUEST_TIMEOUT || statusCode >= 500) && executionCount < MAX_RETRIES + 1;
                if (needNextRetry) {
                    long interval = (1 << executionCount) * 1000;
                    LOGGER.info("Sleep time in millisecond: {}, retryCount: {}", (Object)interval, (Object)executionCount);
                }
                return needNextRetry;
            }

            @Override
            public long getRetryInterval() {
                long interval = (1 << this.executionCount) * 1000;
                return interval;
            }
        };
    }

    private static HttpRequestRetryHandler getHttpRequestRetryHandler() {
        return (exception, executionCount, httpContext) -> {
            String requestURI = HttpUtil.getRequestUriFromContext(httpContext);
            if (executionCount > MAX_RETRIES) {
                LOGGER.info("Max retry exceeded for requestURI:{}", (Object)requestURI);
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                LOGGER.info("Retrying request which caused No HttpResponse Exception with URI:{}, retryCount:{} and maxRetryCount:{}", requestURI, executionCount, MAX_RETRIES);
                return true;
            }
            LOGGER.info("No retry for URI:{} with exception", (Object)requestURI, (Object)exception);
            return false;
        };
    }

    private static String getRequestUriFromContext(HttpContext httpContext) {
        HttpClientContext clientContext = HttpClientContext.adapt(httpContext);
        HttpRequest httpRequest = clientContext.getRequest();
        return httpRequest.getRequestLine().getUri();
    }

    static {
        LOGGER = LoggerFactory.getLogger(HttpUtil.class);
    }
}

