/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.connection;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import net.snowflake.ingest.connection.IngestStatus;

public class HistoryResponse {
    private HistoryStats statistics;
    private Boolean completeResult;
    private String pipe;
    private String nextBeginMark;
    public List<FileEntry> files = new ArrayList<FileEntry>();

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("\nHistory Result:\n");
        result.append("Pipe: ").append(this.pipe).append("\n");
        String sep = "";
        for (FileEntry file : this.files) {
            result.append(sep).append("{\n");
            result.append(file.toString());
            result.append("}");
            sep = ",\n";
        }
        result.append("\n-------------\n");
        return result.toString();
    }

    public HistoryStats getStatistics() {
        return this.statistics;
    }

    public void setStatistics(HistoryStats statistics) {
        this.statistics = statistics;
    }

    public Boolean isCompleteResult() {
        return this.completeResult;
    }

    public void setCompleteResult(Boolean completeResult) {
        this.completeResult = completeResult;
    }

    public String getPipe() {
        return this.pipe;
    }

    public void setPipe(String pipe) {
        this.pipe = pipe;
    }

    public String getNextBeginMark() {
        return this.nextBeginMark;
    }

    public void setNextBeginMark(String nextBeginMark) {
        this.nextBeginMark = nextBeginMark;
    }

    public static class FileEntry {
        private String path;
        private Long fileSize;
        private String timeReceived;
        private String lastInsertTime;
        private Long rowsInserted;
        private Boolean complete;
        private long rowsParsed;
        private Long errorsSeen;
        private Long errorLimit;
        private String firstError;
        private Long firstErrorLineNum;
        private Long firstErrorCharacterPos;
        private String firstErrorColumnName;
        private String systemError;
        private String stageLocation;
        private IngestStatus status;

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Path:").append(this.path).append("\n").append("FileSize: ").append(this.fileSize).append("\n").append("TimeReceived: ").append(this.timeReceived).append("\n").append("LastInsertTime: ").append(this.lastInsertTime).append("\n").append("RowsInserted: ").append(this.rowsInserted).append("\n").append("RowsParsed: ").append(this.rowsParsed).append("\n").append("ErrorsSeen: ").append(this.errorsSeen).append("\n").append("ErrorsLimit: ").append(this.errorLimit).append("\n");
            if (this.errorsSeen != 0L) {
                result.append("FirstError: ").append(this.firstError).append("\n").append("FirstErrorLineNum: ").append(this.firstErrorLineNum).append("\n").append("FirstErrorCharacterPos: ").append(this.firstErrorCharacterPos).append("\n").append("FirstErrorColumnName: ").append(this.firstErrorColumnName).append("\n").append("SystemError: ").append(this.systemError).append("\n");
            }
            result.append("StageLocation: ").append(this.stageLocation).append("\n").append("Status: ").append((Object)this.status).append("\n").append("Complete: ").append(this.complete).append("\n");
            return result.toString();
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Long getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(Long fileSize) {
            this.fileSize = fileSize;
        }

        public LocalDate getTimeReceived() {
            return LocalDate.parse(this.timeReceived, DateTimeFormatter.ISO_DATE_TIME);
        }

        public void setTimeReceived(String timeReceived) {
            this.timeReceived = timeReceived;
        }

        public LocalDate getLastInsertTime() {
            return LocalDate.parse(this.lastInsertTime, DateTimeFormatter.ISO_DATE_TIME);
        }

        public void setLastInsertTime(String lastInsertTime) {
            this.lastInsertTime = lastInsertTime;
        }

        public Long getRowsInserted() {
            return this.rowsInserted;
        }

        public void setRowsInserted(Long rowsInserted) {
            this.rowsInserted = rowsInserted;
        }

        public Boolean isComplete() {
            return this.complete;
        }

        public void setComplete(Boolean complete) {
            this.complete = complete;
        }

        public long getRowsParsed() {
            return this.rowsParsed;
        }

        public void setRowsParsed(long rowsParsed) {
            this.rowsParsed = rowsParsed;
        }

        public Long getErrorsSeen() {
            return this.errorsSeen;
        }

        public void setErrorsSeen(Long errorsSeen) {
            this.errorsSeen = errorsSeen;
        }

        public Long getErrorLimit() {
            return this.errorLimit;
        }

        public void setErrorLimit(Long errorLimit) {
            this.errorLimit = errorLimit;
        }

        public String getFirstError() {
            return this.firstError;
        }

        public void setFirstError(String firstError) {
            this.firstError = firstError;
        }

        public Long getFirstErrorLineNum() {
            return this.firstErrorLineNum;
        }

        public void setFirstErrorLineNum(Long firstErrorLineNum) {
            this.firstErrorLineNum = firstErrorLineNum;
        }

        public Long getFirstErrorCharacterPos() {
            return this.firstErrorCharacterPos;
        }

        public void setFirstErrorCharacterPos(Long firstErrorCharacterPos) {
            this.firstErrorCharacterPos = firstErrorCharacterPos;
        }

        public String getFirstErrorColumnName() {
            return this.firstErrorColumnName;
        }

        public void setFirstErrorColumnName(String firstErrorColumnName) {
            this.firstErrorColumnName = firstErrorColumnName;
        }

        public String getSystemError() {
            return this.systemError;
        }

        public void setSystemError(String systemError) {
            this.systemError = systemError;
        }

        public String getStageLocation() {
            return this.stageLocation;
        }

        public void setStageLocation(String stageLocation) {
            this.stageLocation = stageLocation;
        }

        public IngestStatus getStatus() {
            return this.status;
        }

        public void setStatus(IngestStatus status) {
            this.status = status;
        }
    }

    static class HistoryStats {
        public Long activeFiles;

        HistoryStats() {
        }
    }
}

