/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.connection;

import java.security.KeyPair;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.snowflake.ingest.internal.jose4j.jws.JsonWebSignature;
import net.snowflake.ingest.internal.jose4j.jwt.JwtClaims;
import net.snowflake.ingest.internal.slf4j.Logger;
import net.snowflake.ingest.internal.slf4j.LoggerFactory;
import net.snowflake.ingest.utils.Cryptor;
import net.snowflake.ingest.utils.ThreadFactoryUtil;

final class SecurityManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityManager.class);
    private static final float LIFETIME = 59.0f;
    private static final int RENEWAL_INTERVAL = 54;
    private transient KeyPair keyPair;
    private String account;
    private String publicKeyFingerPrint;
    private String user;
    private AtomicReference<String> token;
    private AtomicBoolean regenFailed;
    final ThreadFactory tf = ThreadFactoryUtil.poolThreadFactory(this.getClass().getSimpleName(), true);
    private final ScheduledExecutorService keyRenewer = Executors.newScheduledThreadPool(1, this.tf);

    SecurityManager(String accountname, String username, KeyPair keyPair, int timeTillRenewal, TimeUnit unit) {
        if (accountname == null || username == null || keyPair == null) {
            throw new IllegalArgumentException();
        }
        this.account = accountname.toUpperCase();
        this.user = username.toUpperCase();
        this.token = new AtomicReference();
        this.regenFailed = new AtomicBoolean();
        this.keyPair = keyPair;
        this.regenerateToken();
        this.keyRenewer.scheduleAtFixedRate(this::regenerateToken, timeTillRenewal, timeTillRenewal, unit);
    }

    SecurityManager(String accountname, String username, KeyPair keyPair) {
        this(accountname, username, keyPair, 54, TimeUnit.MINUTES);
    }

    private void regenerateToken() {
        String newToken;
        JwtClaims claims = new JwtClaims();
        claims.setSubject(this.account + "." + this.user);
        LOGGER.info("Creating Token with subject {}.{}", (Object)this.account, (Object)this.user);
        String publicKeyFPInJwt = this.calculatePublicKeyFp(this.keyPair);
        claims.setIssuer(this.account + "." + this.user + '.' + publicKeyFPInJwt);
        LOGGER.info("Creating Token with issuer {}.{}.{}", this.account, this.user, publicKeyFPInJwt);
        claims.setExpirationTimeMinutesInTheFuture(59.0f);
        claims.setIssuedAtToNow();
        JsonWebSignature websig = new JsonWebSignature();
        websig.setPayload(claims.toJson());
        LOGGER.info("Claims JSON is {}", (Object)claims.toJson());
        websig.setKey(this.keyPair.getPrivate());
        websig.setAlgorithmHeaderValue("RS256");
        try {
            newToken = websig.getCompactSerialization();
        }
        catch (Exception e) {
            this.regenFailed.set(true);
            LOGGER.error("Failed to regenerate token! Exception is as follows : {}", (Object)e.getMessage());
            throw new SecurityException();
        }
        LOGGER.info("Created new JWT  - {}", (Object)newToken);
        this.token.set(newToken);
    }

    String getToken() {
        if (this.regenFailed.get()) {
            LOGGER.error("getToken request failed due to token regeneration failure");
            throw new SecurityException();
        }
        return this.token.get();
    }

    private String calculatePublicKeyFp(KeyPair keyPair) {
        byte[] publicKeyRawBytes = keyPair.getPublic().getEncoded();
        this.publicKeyFingerPrint = String.format("SHA256:%s", Cryptor.sha256HashBase64(publicKeyRawBytes));
        return this.publicKeyFingerPrint;
    }

    String getPublicKeyFingerPrint() {
        return this.publicKeyFingerPrint;
    }
}

