/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.jose4j.jwa;

import java.security.Security;
import java.util.Set;
import net.snowflake.ingest.internal.slf4j.Logger;
import net.snowflake.ingest.internal.slf4j.LoggerFactory;

public class AlgorithmAvailability {
    private static Logger log = LoggerFactory.getLogger(AlgorithmAvailability.class);

    public static boolean isAvailable(String serviceName, String algorithm) {
        Set<String> algorithms = Security.getAlgorithms(serviceName);
        for (String serviceAlg : algorithms) {
            if (!serviceAlg.equalsIgnoreCase(algorithm)) continue;
            return true;
        }
        log.debug("{} is NOT available for {}. Algorithms available from underlying JCE: {}", algorithm, serviceName, algorithms);
        return false;
    }
}

