/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.http.impl;

import java.util.Locale;
import net.snowflake.ingest.internal.apache.http.HttpResponse;
import net.snowflake.ingest.internal.apache.http.HttpResponseFactory;
import net.snowflake.ingest.internal.apache.http.ProtocolVersion;
import net.snowflake.ingest.internal.apache.http.ReasonPhraseCatalog;
import net.snowflake.ingest.internal.apache.http.StatusLine;
import net.snowflake.ingest.internal.apache.http.annotation.Immutable;
import net.snowflake.ingest.internal.apache.http.impl.EnglishReasonPhraseCatalog;
import net.snowflake.ingest.internal.apache.http.message.BasicHttpResponse;
import net.snowflake.ingest.internal.apache.http.message.BasicStatusLine;
import net.snowflake.ingest.internal.apache.http.protocol.HttpContext;
import net.snowflake.ingest.internal.apache.http.util.Args;

@Immutable
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

