/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.com.nimbusds.jose.util;

import java.math.BigInteger;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.Base64;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.Base64Codec;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.BigIntegerUtils;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.StandardCharset;
import net.snowflake.ingest.internal.net.jcip.annotations.Immutable;

@Immutable
public class Base64URL
extends Base64 {
    public Base64URL(String base64URL) {
        super(base64URL);
    }

    @Override
    public boolean equals(Object object) {
        return object != null && object instanceof Base64URL && this.toString().equals(object.toString());
    }

    public static Base64URL encode(byte[] bytes) {
        return new Base64URL(Base64Codec.encodeToString(bytes, true));
    }

    public static Base64URL encode(BigInteger bigInt) {
        return Base64URL.encode(BigIntegerUtils.toBytesUnsigned(bigInt));
    }

    public static Base64URL encode(String text) {
        return Base64URL.encode(text.getBytes(StandardCharset.UTF_8));
    }
}

