/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.utils;

import java.security.Security;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.snowflake.ingest.internal.apache.http.HttpHost;
import net.snowflake.ingest.internal.apache.http.HttpResponse;
import net.snowflake.ingest.internal.apache.http.client.HttpClient;
import net.snowflake.ingest.internal.apache.http.client.ServiceUnavailableRetryStrategy;
import net.snowflake.ingest.internal.apache.http.conn.ssl.DefaultHostnameVerifier;
import net.snowflake.ingest.internal.apache.http.conn.ssl.SSLConnectionSocketFactory;
import net.snowflake.ingest.internal.apache.http.impl.client.HttpClientBuilder;
import net.snowflake.ingest.internal.apache.http.impl.client.HttpClients;
import net.snowflake.ingest.internal.apache.http.impl.conn.DefaultProxyRoutePlanner;
import net.snowflake.ingest.internal.apache.http.protocol.HttpContext;
import net.snowflake.ingest.internal.apache.http.ssl.SSLContexts;
import net.snowflake.ingest.internal.slf4j.Logger;
import net.snowflake.ingest.internal.slf4j.LoggerFactory;

public class HttpUtil {
    private static String USE_PROXY = "http.useProxy";
    private static String PROXY_HOST = "http.proxyHost";
    private static String PROXY_PORT = "http.proxyPort";
    private static String PROXY_SCHEME = "http";
    private static HttpClient httpClient;
    private static final Logger LOGGER;

    public static HttpClient getHttpClient() {
        if (httpClient == null) {
            HttpUtil.initHttpClient();
        }
        return httpClient;
    }

    private static void initHttpClient() {
        Security.setProperty("ocsp.enable", "true");
        SSLContext sslContext = SSLContexts.createDefault();
        SSLConnectionSocketFactory f = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, (HostnameVerifier)new DefaultHostnameVerifier());
        HttpClientBuilder clientBuilder = HttpClients.custom().setSSLSocketFactory(f).setServiceUnavailableRetryStrategy(new ServiceUnavailableRetryStrategy(){
            private int executionCount = 0;
            int MAX_RETRIES = 3;
            int REQUEST_TIMEOUT = 408;

            @Override
            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                boolean needNextRetry;
                this.executionCount = executionCount;
                int statusCode = response.getStatusLine().getStatusCode();
                boolean bl = needNextRetry = (statusCode == this.REQUEST_TIMEOUT || statusCode >= 500) && executionCount < this.MAX_RETRIES + 1;
                if (executionCount == this.MAX_RETRIES + 1) {
                    LOGGER.info("Reach the max retry time.");
                }
                if (needNextRetry && executionCount < this.MAX_RETRIES + 1) {
                    long interval = (1 << executionCount) * 1000;
                    LOGGER.info("Sleep time in millisecond: {}", (Object)interval);
                }
                return needNextRetry;
            }

            @Override
            public long getRetryInterval() {
                long interval = (1 << this.executionCount) * 1000;
                return interval;
            }
        });
        if ("true".equalsIgnoreCase(System.getProperty(USE_PROXY))) {
            if (System.getProperty(PROXY_PORT) == null) {
                throw new IllegalArgumentException("proxy port number is not provided, please assign proxy port to http.proxyPort option");
            }
            if (System.getProperty(PROXY_HOST) == null) {
                throw new IllegalArgumentException("proxy host IP is not provided, please assign proxy host IP to http.proxyHost option");
            }
            String proxyHost = System.getProperty(PROXY_HOST);
            int proxyPort = Integer.parseInt(System.getProperty(PROXY_PORT));
            HttpHost proxy = new HttpHost(proxyHost, proxyPort, PROXY_SCHEME);
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            clientBuilder = clientBuilder.setRoutePlanner(routePlanner);
        }
        httpClient = clientBuilder.build();
    }

    static {
        LOGGER = LoggerFactory.getLogger(HttpUtil.class);
    }
}

