/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.connection;

import java.nio.charset.StandardCharsets;

public class InsertFilesClientInfo {
    public static final int MAX_ALLOWED_OFFSET_TOKEN_BYTE_SIZE = 100000;
    private final long clientSequencer;
    private final String offsetToken;

    public InsertFilesClientInfo(long clientSequencer, String offsetToken) {
        if (clientSequencer < 0L) {
            throw new IllegalArgumentException("ClientSequencer should be non negative.");
        }
        if (offsetToken == null || offsetToken.isEmpty()) {
            throw new IllegalArgumentException("OffsetToken can not be null or empty.");
        }
        if (offsetToken.getBytes(StandardCharsets.UTF_8).length > 99000) {
            throw new IllegalArgumentException("OffsetToken size too large.");
        }
        this.clientSequencer = clientSequencer;
        this.offsetToken = offsetToken;
    }

    public long getClientSequencer() {
        return this.clientSequencer;
    }

    public String getOffsetToken() {
        return this.offsetToken;
    }

    public String toString() {
        return "InsertFilesClientInfo{clientSequencer=" + this.clientSequencer + '}';
    }
}

