/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.connection;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyPair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import net.snowflake.client.jdbc.internal.apache.http.HttpEntity;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpGet;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpUriRequest;
import net.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.client.jdbc.internal.apache.http.entity.ContentType;
import net.snowflake.client.jdbc.internal.apache.http.entity.StringEntity;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.ingest.SimpleIngestManager;
import net.snowflake.ingest.connection.InsertFilesClientInfo;
import net.snowflake.ingest.connection.SecurityManager;
import net.snowflake.ingest.connection.TelemetryService;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.SFException;
import net.snowflake.ingest.utils.SnowflakeURL;
import net.snowflake.ingest.utils.StagedFileWrapper;
import net.snowflake.ingest.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)RequestBuilder.class.getName());
    private final SecurityManager securityManager;
    private String scheme;
    private final int port;
    private final String host;
    private final String userAgentSuffix;
    private final TelemetryService telemetryService;
    public static final String DEFAULT_HOST_SUFFIX = "snowflakecomputing.com";
    private static final String DEFAULT_SCHEME = "https";
    private static final int DEFAULT_PORT = 443;
    private static final String INGEST_ENDPOINT_FORMAT = "/v1/data/pipes/%s/insertFiles";
    private static final String HISTORY_ENDPOINT_FORMAT = "/v1/data/pipes/%s/insertReport";
    private static final String HISTORY_RANGE_ENDPOINT_FORMAT = "/v1/data/pipes/%s/loadHistoryScan";
    private static final String CONFIGURE_CLIENT_ENDPOINT_FORMAT = "/v1/data/pipes/%s/client/configure";
    private static final String CLIENT_STATUS_ENDPOINT_FORMAT = "/v1/data/pipes/%s/client/status";
    private static final String RECENT_HISTORY_IN_SECONDS = "recentSeconds";
    private static final String HISTORY_BEGIN_MARK = "beginMark";
    private static final String HISTORY_RANGE_START_INCLUSIVE = "startTimeInclusive";
    private static final String HISTORY_RANGE_END_EXCLUSIVE = "endTimeExclusive";
    private static final String REQUEST_ID = "requestId";
    private static final String SHOW_SKIPPED_FILES = "showSkippedFiles";
    private static final String BEARER_PARAMETER = "Bearer ";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String RESOURCES_FILE = "project.properties";
    private static final Properties PROPERTIES = RequestBuilder.loadProperties();
    private static final String USER_AGENT = RequestBuilder.getDefaultUserAgent();
    public static final String CLIENT_NAME = "SnowpipeJavaSDK";
    public static final String DEFAULT_VERSION = "1.1.0";
    public static final String JAVA_USER_AGENT = "JAVA";
    public static final String OS_INFO_USER_AGENT_FORMAT = "(%s %s %s)";
    public static final String SF_HEADER_AUTHORIZATION_TOKEN_TYPE = "X-Snowflake-Authorization-Token-Type";
    public static final String JWT_TOKEN_TYPE = "KEYPAIR_JWT";
    public static final String HTTP_HEADER_CONTENT_TYPE_JSON = "application/json";

    public RequestBuilder(String accountName, String userName, KeyPair keyPair) {
        this(accountName, userName, keyPair, DEFAULT_SCHEME, DEFAULT_HOST_SUFFIX, 443, null);
    }

    public RequestBuilder(String accountName, String userName, String hostName, KeyPair keyPair, String userAgentSuffix) {
        this(accountName, userName, keyPair, DEFAULT_SCHEME, hostName, 443, userAgentSuffix);
    }

    public RequestBuilder(String accountName, String userName, KeyPair keyPair, String schemeName, String hostName, int portNum) {
        this(accountName, userName, keyPair, schemeName, hostName, portNum, null);
    }

    public RequestBuilder(String accountName, String userName, KeyPair keyPair, String schemeName, String hostName, int portNum, String userAgentSuffix) {
        this(accountName, userName, keyPair, schemeName, hostName, portNum, userAgentSuffix, null, null);
    }

    public RequestBuilder(SnowflakeURL url, String userName, KeyPair keyPair, CloseableHttpClient httpClient, String clientName) {
        this(url.getAccount(), userName, keyPair, url.getScheme(), url.getUrlWithoutPort(), url.getPort(), null, httpClient, clientName);
    }

    public RequestBuilder(String accountName, String userName, KeyPair keyPair, String schemeName, String hostName, int portNum, String userAgentSuffix, CloseableHttpClient httpClient, String clientName) {
        if (accountName == null || userName == null || keyPair == null) {
            throw new IllegalArgumentException();
        }
        this.telemetryService = new TelemetryService(httpClient, clientName, schemeName + "://" + hostName + ":" + portNum);
        this.securityManager = new SecurityManager(accountName, userName, keyPair, this.telemetryService);
        String account = accountName.toUpperCase();
        String user = userName.toUpperCase();
        this.port = portNum;
        this.scheme = schemeName;
        this.host = hostName;
        this.userAgentSuffix = userAgentSuffix;
        LOGGER.info("Creating a RequestBuilder with arguments : Account : {}, User : {}, Scheme : {}, Host : {}, Port : {}, userAgentSuffix: {}", new Object[]{account, user, this.scheme, this.host, this.port, this.userAgentSuffix});
    }

    private static Properties loadProperties() {
        Properties properties = new Properties();
        properties.put("version", DEFAULT_VERSION);
        try (InputStream is = SimpleIngestManager.class.getClassLoader().getResourceAsStream(RESOURCES_FILE);){
            if (is == null) {
                throw new FileNotFoundException(RESOURCES_FILE);
            }
            properties.load(is);
        }
        catch (Exception e) {
            LOGGER.warn("Could not read version info, use default version 1.1.0", (Throwable)e);
            return properties;
        }
        LOGGER.info("Loaded project version " + properties.getProperty("version"));
        return properties;
    }

    private static String getDefaultUserAgent() {
        String clientVersion = PROPERTIES.getProperty("version");
        StringBuilder defaultUserAgent = new StringBuilder("SnowpipeJavaSDK/" + clientVersion);
        String osInformation = String.format(OS_INFO_USER_AGENT_FORMAT, System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        defaultUserAgent.append(" ");
        defaultUserAgent.append(osInformation);
        defaultUserAgent.append(" ");
        String javaVersion = System.getProperty("java.version");
        defaultUserAgent.append("JAVA/").append(javaVersion);
        String userAgent = defaultUserAgent.toString();
        LOGGER.info("Default user agent " + userAgent);
        return userAgent;
    }

    private static String buildCustomUserAgent(String additionalUserAgentInfo) {
        return USER_AGENT.trim() + " " + additionalUserAgentInfo;
    }

    private URIBuilder makeBaseURI(UUID requestId) {
        if (requestId == null) {
            LOGGER.error("RequestId is null!");
            throw new IllegalArgumentException();
        }
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.scheme);
        builder.setHost(this.host);
        builder.setPort(this.port);
        builder.setParameter(REQUEST_ID, requestId.toString());
        return builder;
    }

    private URI makeInsertURI(UUID requestId, String pipe, boolean showSkippedFiles) throws URISyntaxException {
        if (pipe == null) {
            LOGGER.error("Table argument is null");
            throw new IllegalArgumentException();
        }
        URIBuilder builder = this.makeBaseURI(requestId);
        builder.setParameter(SHOW_SKIPPED_FILES, String.valueOf(showSkippedFiles));
        builder.setPath(String.format(INGEST_ENDPOINT_FORMAT, pipe));
        return builder.build();
    }

    private URI makeHistoryURI(UUID requestId, String pipe, Integer recentSeconds, String beginMark) throws URISyntaxException {
        if (pipe == null) {
            throw new IllegalArgumentException();
        }
        URIBuilder builder = this.makeBaseURI(requestId);
        builder.setPath(String.format(HISTORY_ENDPOINT_FORMAT, pipe));
        if (recentSeconds != null) {
            builder.setParameter(RECENT_HISTORY_IN_SECONDS, String.valueOf(recentSeconds));
        }
        if (beginMark != null) {
            builder.setParameter(HISTORY_BEGIN_MARK, beginMark);
        }
        LOGGER.info("Final History URIBuilder - {}", (Object)builder.toString());
        return builder.build();
    }

    private URI makeHistoryRangeURI(UUID requestId, String pipe, String startTimeInclusive, String endTimeExclusive) throws URISyntaxException {
        if (pipe == null) {
            throw new IllegalArgumentException();
        }
        URIBuilder builder = this.makeBaseURI(requestId);
        builder.setPath(String.format(HISTORY_RANGE_ENDPOINT_FORMAT, pipe));
        if (startTimeInclusive != null) {
            builder.setParameter(HISTORY_RANGE_START_INCLUSIVE, startTimeInclusive);
        }
        if (endTimeExclusive != null) {
            builder.setParameter(HISTORY_RANGE_END_EXCLUSIVE, endTimeExclusive);
        }
        LOGGER.info("Final History URIBuilder - {}", (Object)builder.toString());
        return builder.build();
    }

    private URI makeConfigureClientURI(UUID requestId, String pipe) throws URISyntaxException {
        if (pipe == null) {
            throw new IllegalArgumentException();
        }
        URIBuilder builder = this.makeBaseURI(requestId);
        builder.setPath(String.format(CONFIGURE_CLIENT_ENDPOINT_FORMAT, pipe));
        LOGGER.info("Final Configure Client URIBuilder - {}", (Object)builder);
        return builder.build();
    }

    private URI makeGetClientURI(UUID requestId, String pipe) throws URISyntaxException {
        if (pipe == null) {
            throw new IllegalArgumentException();
        }
        URIBuilder builder = this.makeBaseURI(requestId);
        builder.setPath(String.format(CLIENT_STATUS_ENDPOINT_FORMAT, pipe));
        LOGGER.info("Final Get Client URIBuilder - {}", (Object)builder);
        return builder.build();
    }

    private String serializeInsertFilesRequest(List<StagedFileWrapper> files, Optional<InsertFilesClientInfo> clientInfo) {
        if (files == null) {
            LOGGER.info("Null files argument in RequestBuilder");
            throw new IllegalArgumentException();
        }
        IngestRequest ingestRequest = clientInfo.map(insertFilesClientInfo -> new IngestRequest(files, (InsertFilesClientInfo)insertFilesClientInfo)).orElseGet(() -> new IngestRequest(files));
        try {
            return objectMapper.writeValueAsString((Object)ingestRequest);
        }
        catch (Exception e) {
            LOGGER.error("Unable to Generate JSON Body for Insert request");
            throw new RuntimeException();
        }
    }

    private static void addUserAgent(HttpUriRequest request, String userAgentSuffix) {
        if (!Utils.isNullOrEmpty(userAgentSuffix)) {
            String userAgent = RequestBuilder.buildCustomUserAgent(userAgentSuffix);
            request.setHeader("User-Agent", userAgent);
            return;
        }
        request.setHeader("User-Agent", USER_AGENT);
    }

    private static void addToken(HttpUriRequest request, String token) {
        request.setHeader("Authorization", BEARER_PARAMETER + token);
        request.setHeader(SF_HEADER_AUTHORIZATION_TOKEN_TYPE, JWT_TOKEN_TYPE);
    }

    private static void addHeaders(HttpUriRequest request, String token, String userAgentSuffix) {
        RequestBuilder.addUserAgent(request, userAgentSuffix);
        RequestBuilder.addToken(request, token);
        request.setHeader("Accept", HTTP_HEADER_CONTENT_TYPE_JSON);
    }

    public HttpPost generateInsertRequest(UUID requestId, String pipe, List<StagedFileWrapper> files, boolean showSkippedFiles) throws URISyntaxException {
        return this.generateInsertRequest(requestId, pipe, files, showSkippedFiles, Optional.empty());
    }

    public HttpPost generateInsertRequest(UUID requestId, String pipe, List<StagedFileWrapper> files, boolean showSkippedFiles, Optional<InsertFilesClientInfo> clientInfo) throws URISyntaxException {
        URI insertURI = this.makeInsertURI(requestId, pipe, showSkippedFiles);
        LOGGER.info("Created Insert Request : {} ", (Object)insertURI);
        HttpPost post = new HttpPost(insertURI);
        RequestBuilder.addHeaders((HttpUriRequest)post, this.securityManager.getToken(), this.userAgentSuffix);
        StringEntity entity = new StringEntity(this.serializeInsertFilesRequest(files, clientInfo), ContentType.APPLICATION_JSON);
        post.setEntity((HttpEntity)entity);
        return post;
    }

    public HttpGet generateHistoryRequest(UUID requestId, String pipe, Integer recentSeconds, String beginMark) throws URISyntaxException {
        URI historyURI = this.makeHistoryURI(requestId, pipe, recentSeconds, beginMark);
        HttpGet get = new HttpGet(historyURI);
        RequestBuilder.addHeaders((HttpUriRequest)get, this.securityManager.getToken(), this.userAgentSuffix);
        return get;
    }

    public HttpGet generateHistoryRangeRequest(UUID requestId, String pipe, String startTimeInclusive, String endTimeExclusive) throws URISyntaxException {
        URI historyRangeURI = this.makeHistoryRangeURI(requestId, pipe, startTimeInclusive, endTimeExclusive);
        HttpGet get = new HttpGet(historyRangeURI);
        RequestBuilder.addHeaders((HttpUriRequest)get, this.securityManager.getToken(), this.userAgentSuffix);
        return get;
    }

    public HttpPost generateStreamingIngestPostRequest(String payload, String endPoint, String message) {
        LOGGER.debug("Generate Snowpipe streaming request: endpoint={}, payload={}", (Object)endPoint, (Object)payload);
        URI uri = null;
        try {
            uri = new URIBuilder().setScheme(this.scheme).setHost(this.host).setPort(this.port).setPath(endPoint).build();
        }
        catch (URISyntaxException e) {
            throw new SFException(e, ErrorCode.BUILD_REQUEST_FAILURE, message);
        }
        HttpPost post = new HttpPost(uri);
        RequestBuilder.addHeaders((HttpUriRequest)post, this.securityManager.getToken(), this.userAgentSuffix);
        StringEntity entity = new StringEntity(payload, ContentType.APPLICATION_JSON);
        post.setEntity((HttpEntity)entity);
        return post;
    }

    public HttpPost generateConfigureClientRequest(UUID requestID, String pipe) throws URISyntaxException {
        URI configureClientURI = this.makeConfigureClientURI(requestID, pipe);
        HttpPost post = new HttpPost(configureClientURI);
        RequestBuilder.addHeaders((HttpUriRequest)post, this.securityManager.getToken(), this.userAgentSuffix);
        return post;
    }

    public HttpPost generateStreamingIngestPostRequest(Map<Object, Object> payload, String endPoint, String message) {
        String payloadInString = null;
        try {
            payloadInString = objectMapper.writeValueAsString(payload);
        }
        catch (JsonProcessingException e) {
            throw new SFException(e, ErrorCode.BUILD_REQUEST_FAILURE, message);
        }
        return this.generateStreamingIngestPostRequest(payloadInString, endPoint, message);
    }

    public HttpGet generateGetClientStatusRequest(UUID requestID, String pipe) throws URISyntaxException {
        URI getClientStatusURI = this.makeGetClientURI(requestID, pipe);
        HttpGet get = new HttpGet(getClientStatusURI);
        RequestBuilder.addHeaders((HttpUriRequest)get, this.securityManager.getToken(), this.userAgentSuffix);
        return get;
    }

    public void closeResources() {
        this.securityManager.close();
        this.telemetryService.close();
    }

    public TelemetryService getTelemetryService() {
        return this.telemetryService;
    }

    private static class IngestRequest {
        private final List<StagedFileWrapper> files;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private final InsertFilesClientInfo clientInfo;

        public IngestRequest(List<StagedFileWrapper> files, InsertFilesClientInfo clientInfo) {
            this.files = files;
            this.clientInfo = clientInfo;
        }

        public IngestRequest(List<StagedFileWrapper> files) {
            this(files, null);
        }

        public List<StagedFileWrapper> getFiles() {
            return this.files;
        }

        public InsertFilesClientInfo getClientInfo() {
            return this.clientInfo;
        }
    }
}

