/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.connection;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.UUID;
import net.snowflake.client.jdbc.internal.apache.http.HttpEntity;
import net.snowflake.client.jdbc.internal.apache.http.HttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.StatusLine;
import net.snowflake.client.jdbc.internal.apache.http.util.EntityUtils;
import net.snowflake.ingest.connection.ClientStatusResponse;
import net.snowflake.ingest.connection.ConfigureClientResponse;
import net.snowflake.ingest.connection.HistoryRangeResponse;
import net.snowflake.ingest.connection.HistoryResponse;
import net.snowflake.ingest.connection.IngestResponse;
import net.snowflake.ingest.connection.IngestResponseException;
import net.snowflake.ingest.utils.BackOffException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceResponseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceResponseHandler.class);
    static ObjectMapper mapper = new ObjectMapper();

    private static boolean isStatusOK(StatusLine statusLine) {
        return statusLine.getStatusCode() >= 200 && statusLine.getStatusCode() < 300;
    }

    public static IngestResponse unmarshallIngestResponse(HttpResponse response, UUID requestId) throws IOException, IngestResponseException, BackOffException {
        if (response == null) {
            LOGGER.warn("Null argument passed to unmarshallIngestResponse");
            throw new IllegalArgumentException();
        }
        ServiceResponseHandler.handleExceptionalStatus(response, requestId, ApiName.INSERT_FILES);
        String blob = ServiceResponseHandler.consumeAndReturnResponseEntityAsString(response.getEntity());
        return (IngestResponse)mapper.readValue(blob, IngestResponse.class);
    }

    public static HistoryResponse unmarshallHistoryResponse(HttpResponse response, UUID requestId) throws IOException, IngestResponseException, BackOffException {
        if (response == null) {
            LOGGER.warn("Null response passed to unmarshallHistoryResponse");
            throw new IllegalArgumentException();
        }
        ServiceResponseHandler.handleExceptionalStatus(response, requestId, ApiName.INSERT_REPORT);
        String blob = ServiceResponseHandler.consumeAndReturnResponseEntityAsString(response.getEntity());
        return (HistoryResponse)mapper.readValue(blob, HistoryResponse.class);
    }

    public static HistoryRangeResponse unmarshallHistoryRangeResponse(HttpResponse response, UUID requestId) throws IOException, IngestResponseException, BackOffException {
        if (response == null) {
            LOGGER.warn("Null response passed to unmarshallHistoryRangeResponse");
            throw new IllegalArgumentException();
        }
        ServiceResponseHandler.handleExceptionalStatus(response, requestId, ApiName.LOAD_HISTORY_SCAN);
        String blob = ServiceResponseHandler.consumeAndReturnResponseEntityAsString(response.getEntity());
        return (HistoryRangeResponse)mapper.readValue(blob, HistoryRangeResponse.class);
    }

    public static ConfigureClientResponse unmarshallConfigureClientResponse(HttpResponse response, UUID requestId) throws IOException, IngestResponseException, BackOffException {
        if (response == null) {
            LOGGER.warn("Null response passed to unmarshallConfigureClientResponse");
            throw new IllegalArgumentException();
        }
        ServiceResponseHandler.handleExceptionalStatus(response, requestId, ApiName.CLIENT_CONFIGURE);
        String blob = ServiceResponseHandler.consumeAndReturnResponseEntityAsString(response.getEntity());
        return (ConfigureClientResponse)mapper.readValue(blob, ConfigureClientResponse.class);
    }

    public static ClientStatusResponse unmarshallGetClientStatus(HttpResponse response, UUID requestId) throws IOException, IngestResponseException, BackOffException {
        if (response == null) {
            LOGGER.warn("Null response passed to unmarshallClientStatusResponse");
            throw new IllegalArgumentException();
        }
        ServiceResponseHandler.handleExceptionalStatus(response, requestId, ApiName.CLIENT_STATUS);
        String blob = ServiceResponseHandler.consumeAndReturnResponseEntityAsString(response.getEntity());
        return (ClientStatusResponse)mapper.readValue(blob, ClientStatusResponse.class);
    }

    public static <T> T unmarshallStreamingIngestResponse(HttpResponse response, Class<T> valueType, ApiName apiName) throws IOException, IngestResponseException {
        if (response == null) {
            LOGGER.warn("Null response passed to {}", (Object)valueType.getName());
            throw new IllegalArgumentException();
        }
        ServiceResponseHandler.handleExceptionalStatus(response, null, apiName);
        String blob = ServiceResponseHandler.consumeAndReturnResponseEntityAsString(response.getEntity());
        return (T)mapper.readValue(blob, valueType);
    }

    private static void handleExceptionalStatus(HttpResponse response, UUID requestId, ApiName apiName) throws IOException, IngestResponseException, BackOffException {
        StatusLine statusLine = response.getStatusLine();
        if (!ServiceResponseHandler.isStatusOK(statusLine)) {
            switch (statusLine.getStatusCode()) {
                case 503: {
                    LOGGER.warn("503 Status hit from {}, backoff, requestId:{}", (Object)apiName, (Object)(requestId == null ? "" : requestId.toString()));
                    throw new BackOffException();
                }
            }
            LOGGER.error("Exceptional Status Code from {}: {}, requestId:{}", new Object[]{apiName, statusLine.getStatusCode(), requestId == null ? "" : requestId.toString()});
            String blob = ServiceResponseHandler.consumeAndReturnResponseEntityAsString(response.getEntity());
            throw new IngestResponseException(statusLine.getStatusCode(), IngestResponseException.IngestExceptionBody.parseBody(blob));
        }
    }

    private static String consumeAndReturnResponseEntityAsString(HttpEntity httpResponseEntity) throws IOException {
        String responseEntityAsString = EntityUtils.toString((HttpEntity)httpResponseEntity);
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return responseEntityAsString;
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static enum ApiName {
        INSERT_FILES("POST"),
        INSERT_REPORT("GET"),
        LOAD_HISTORY_SCAN("GET"),
        CLIENT_CONFIGURE("POST"),
        CLIENT_STATUS("GET"),
        STREAMING_OPEN_CHANNEL("POST"),
        STREAMING_CHANNEL_STATUS("POST"),
        STREAMING_REGISTER_BLOB("POST"),
        STREAMING_CLIENT_CONFIGURE("POST");

        private final String httpMethod;

        private ApiName(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public String getHttpMethod() {
            return this.httpMethod;
        }
    }
}

