/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.snowflake.client.jdbc.internal.google.common.collect.Sets;
import net.snowflake.ingest.streaming.OpenChannelRequest;
import net.snowflake.ingest.streaming.internal.AbstractRowBuffer;
import net.snowflake.ingest.streaming.internal.ArrowFlusher;
import net.snowflake.ingest.streaming.internal.ChannelRuntimeState;
import net.snowflake.ingest.streaming.internal.ColumnMetadata;
import net.snowflake.ingest.streaming.internal.DataValidationUtil;
import net.snowflake.ingest.streaming.internal.Flusher;
import net.snowflake.ingest.streaming.internal.LiteralQuoteUtils;
import net.snowflake.ingest.streaming.internal.RowBufferStats;
import net.snowflake.ingest.streaming.internal.TimestampWrapper;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.Logging;
import net.snowflake.ingest.utils.SFException;
import net.snowflake.ingest.utils.Utils;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.VisibleForTesting;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.Text;
import org.apache.arrow.vector.util.TransferPair;

class ArrowRowBuffer
extends AbstractRowBuffer<VectorSchemaRoot> {
    private static final Logging logger = new Logging(ArrowRowBuffer.class);
    private static final String FIELD_EPOCH_IN_SECONDS = "epoch";
    private static final String FIELD_TIME_ZONE = "timezone";
    private static final String FIELD_FRACTION_IN_NANOSECONDS = "fraction";
    private static final String COLUMN_PHYSICAL_TYPE = "physicalType";
    private static final String COLUMN_LOGICAL_TYPE = "logicalType";
    private static final String COLUMN_NULLABLE = "nullable";
    static final String COLUMN_SCALE = "scale";
    private static final String COLUMN_PRECISION = "precision";
    private static final String COLUMN_CHAR_LENGTH = "charLength";
    private static final String COLUMN_BYTE_LENGTH = "byteLength";
    @VisibleForTesting
    static final int DECIMAL_BIT_WIDTH = 128;
    @VisibleForTesting
    VectorSchemaRoot vectorsRoot;
    @VisibleForTesting
    VectorSchemaRoot tempVectorsRoot;
    private final Map<String, Field> fields = new HashMap<String, Field>();

    ArrowRowBuffer(OpenChannelRequest.OnErrorOption onErrorOption, ZoneId defaultTimezone, BufferAllocator allocator, String fullyQualifiedChannelName, Consumer<Float> rowSizeMetric, ChannelRuntimeState channelState) {
        super(onErrorOption, defaultTimezone, allocator, fullyQualifiedChannelName, rowSizeMetric, channelState);
    }

    @Override
    public void setupSchema(List<ColumnMetadata> columns) {
        ArrayList<FieldVector> vectors = new ArrayList<FieldVector>();
        ArrayList<FieldVector> tempVectors = new ArrayList<FieldVector>();
        for (ColumnMetadata column : columns) {
            this.validateColumnCollation(column);
            Field field = this.buildField(column);
            FieldVector vector = field.createVector(this.allocator);
            if (!field.isNullable()) {
                this.addNonNullableFieldName(field.getName());
            }
            this.fields.put(column.getInternalName(), field);
            vectors.add(vector);
            this.statsMap.put(column.getInternalName(), new RowBufferStats(column.getName(), column.getCollation()));
            if (this.onErrorOption != OpenChannelRequest.OnErrorOption.ABORT) continue;
            FieldVector tempVector = field.createVector(this.allocator);
            tempVectors.add(tempVector);
            this.tempStatsMap.put(column.getInternalName(), new RowBufferStats(column.getName(), column.getCollation()));
        }
        this.vectorsRoot = new VectorSchemaRoot(vectors);
        this.tempVectorsRoot = new VectorSchemaRoot(tempVectors);
    }

    @Override
    public void closeInternal() {
        if (this.vectorsRoot != null) {
            this.vectorsRoot.close();
            this.tempVectorsRoot.close();
        }
        this.fields.clear();
    }

    @Override
    void reset() {
        super.reset();
        this.vectorsRoot.clear();
    }

    Field buildField(ColumnMetadata column) {
        ArrowType arrowType;
        AbstractRowBuffer.ColumnLogicalType logicalType;
        AbstractRowBuffer.ColumnPhysicalType physicalType;
        ArrayList<Field> children = null;
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(COLUMN_LOGICAL_TYPE, column.getLogicalType());
        metadata.put(COLUMN_PHYSICAL_TYPE, column.getPhysicalType());
        metadata.put(COLUMN_NULLABLE, String.valueOf(column.getNullable()));
        try {
            physicalType = AbstractRowBuffer.ColumnPhysicalType.valueOf(column.getPhysicalType());
            logicalType = AbstractRowBuffer.ColumnLogicalType.valueOf(column.getLogicalType());
        }
        catch (IllegalArgumentException e) {
            throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, column.getLogicalType(), column.getPhysicalType());
        }
        if (column.getPrecision() != null) {
            metadata.put(COLUMN_PRECISION, column.getPrecision().toString());
        }
        if (column.getScale() != null) {
            metadata.put(COLUMN_SCALE, column.getScale().toString());
        }
        if (column.getByteLength() != null) {
            metadata.put(COLUMN_BYTE_LENGTH, column.getByteLength().toString());
        }
        if (column.getLength() != null) {
            metadata.put(COLUMN_CHAR_LENGTH, column.getLength().toString());
        }
        block1 : switch (logicalType) {
            case FIXED: {
                if (column.getScale() != null && column.getScale() != 0 || physicalType == AbstractRowBuffer.ColumnPhysicalType.SB16) {
                    arrowType = new ArrowType.Decimal(column.getPrecision().intValue(), column.getScale().intValue(), 128);
                    break;
                }
                switch (physicalType) {
                    case SB1: {
                        arrowType = Types.MinorType.TINYINT.getType();
                        break block1;
                    }
                    case SB2: {
                        arrowType = Types.MinorType.SMALLINT.getType();
                        break block1;
                    }
                    case SB4: {
                        arrowType = Types.MinorType.INT.getType();
                        break block1;
                    }
                    case SB8: {
                        arrowType = Types.MinorType.BIGINT.getType();
                        break block1;
                    }
                }
                throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, column.getLogicalType(), column.getPhysicalType());
            }
            case ANY: 
            case ARRAY: 
            case CHAR: 
            case TEXT: 
            case OBJECT: 
            case VARIANT: {
                arrowType = Types.MinorType.VARCHAR.getType();
                break;
            }
            case TIMESTAMP_LTZ: 
            case TIMESTAMP_NTZ: {
                switch (physicalType) {
                    case SB8: {
                        arrowType = Types.MinorType.BIGINT.getType();
                        break block1;
                    }
                    case SB16: {
                        arrowType = Types.MinorType.STRUCT.getType();
                        FieldType fieldTypeEpoch = new FieldType(true, Types.MinorType.BIGINT.getType(), null, metadata);
                        FieldType fieldTypeFraction = new FieldType(true, Types.MinorType.INT.getType(), null, metadata);
                        Field fieldEpoch = new Field(FIELD_EPOCH_IN_SECONDS, fieldTypeEpoch, null);
                        Field fieldFraction = new Field(FIELD_FRACTION_IN_NANOSECONDS, fieldTypeFraction, null);
                        children = new ArrayList<Field>();
                        children.add(fieldEpoch);
                        children.add(fieldFraction);
                        break block1;
                    }
                }
                throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, column.getLogicalType(), column.getPhysicalType());
            }
            case TIMESTAMP_TZ: {
                switch (physicalType) {
                    case SB8: {
                        arrowType = Types.MinorType.STRUCT.getType();
                        FieldType fieldTypeEpoch = new FieldType(true, Types.MinorType.BIGINT.getType(), null, metadata);
                        FieldType fieldTypeTimezone = new FieldType(true, Types.MinorType.INT.getType(), null, metadata);
                        Field fieldEpoch = new Field(FIELD_EPOCH_IN_SECONDS, fieldTypeEpoch, null);
                        Field fieldTimezone = new Field(FIELD_TIME_ZONE, fieldTypeTimezone, null);
                        children = new ArrayList();
                        children.add(fieldEpoch);
                        children.add(fieldTimezone);
                        break block1;
                    }
                    case SB16: {
                        arrowType = Types.MinorType.STRUCT.getType();
                        FieldType fieldTypeEpoch = new FieldType(true, Types.MinorType.BIGINT.getType(), null, metadata);
                        FieldType fieldTypeFraction = new FieldType(true, Types.MinorType.INT.getType(), null, metadata);
                        FieldType fieldTypeTimezone = new FieldType(true, Types.MinorType.INT.getType(), null, metadata);
                        Field fieldEpoch = new Field(FIELD_EPOCH_IN_SECONDS, fieldTypeEpoch, null);
                        Field fieldFraction = new Field(FIELD_FRACTION_IN_NANOSECONDS, fieldTypeFraction, null);
                        Field fieldTimezone = new Field(FIELD_TIME_ZONE, fieldTypeTimezone, null);
                        children = new ArrayList();
                        children.add(fieldEpoch);
                        children.add(fieldFraction);
                        children.add(fieldTimezone);
                        break block1;
                    }
                }
                throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, "Unknown physical type for TIMESTAMP_TZ: " + (Object)((Object)physicalType));
            }
            case DATE: {
                arrowType = Types.MinorType.DATEDAY.getType();
                break;
            }
            case TIME: {
                switch (physicalType) {
                    case SB4: {
                        arrowType = Types.MinorType.INT.getType();
                        break block1;
                    }
                    case SB8: {
                        arrowType = Types.MinorType.BIGINT.getType();
                        break block1;
                    }
                }
                throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, column.getLogicalType(), column.getPhysicalType());
            }
            case BOOLEAN: {
                arrowType = Types.MinorType.BIT.getType();
                break;
            }
            case BINARY: {
                arrowType = Types.MinorType.VARBINARY.getType();
                break;
            }
            case REAL: {
                arrowType = Types.MinorType.FLOAT8.getType();
                break;
            }
            default: {
                throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, column.getLogicalType(), column.getPhysicalType());
            }
        }
        FieldType fieldType = new FieldType(column.getNullable(), arrowType, null, metadata);
        return new Field(column.getInternalName(), fieldType, children);
    }

    @Override
    void moveTempRowsToActualBuffer(int tempRowCount) {
        for (Field field : this.fields.values()) {
            FieldVector from = this.tempVectorsRoot.getVector(field);
            FieldVector to = this.vectorsRoot.getVector(field);
            for (int rowIdx = 0; rowIdx < tempRowCount; ++rowIdx) {
                to.copyFromSafe(rowIdx, this.rowCount + rowIdx, (ValueVector)from);
            }
        }
    }

    @Override
    void clearTempRows() {
        this.tempVectorsRoot.clear();
    }

    @Override
    boolean hasColumns() {
        return !this.fields.isEmpty();
    }

    @Override
    Optional<VectorSchemaRoot> getSnapshot(String filePath) {
        ArrayList<FieldVector> oldVectors = new ArrayList<FieldVector>();
        for (FieldVector vector : this.vectorsRoot.getFieldVectors()) {
            vector.setValueCount(this.rowCount);
            if (vector instanceof DecimalVector) {
                ArrowType.Decimal arrowType = new ArrowType.Decimal(((DecimalVector)vector).getPrecision(), ((DecimalVector)vector).getScale(), 128);
                FieldType fieldType = new FieldType(vector.getField().isNullable(), (ArrowType)arrowType, null, vector.getField().getMetadata());
                Field f = new Field(vector.getName(), fieldType, null);
                DecimalVector newVector = new DecimalVector(f, this.allocator);
                TransferPair t = vector.makeTransferPair((ValueVector)newVector);
                t.transfer();
                oldVectors.add((FieldVector)t.getTo());
                continue;
            }
            TransferPair t = vector.getTransferPair(this.allocator);
            t.transfer();
            oldVectors.add((FieldVector)t.getTo());
        }
        VectorSchemaRoot root = new VectorSchemaRoot(oldVectors);
        root.setRowCount(this.rowCount);
        return oldVectors.isEmpty() ? Optional.empty() : Optional.of(root);
    }

    @Override
    boolean hasColumn(String name) {
        return this.fields.get(name) != null;
    }

    @Override
    float addRow(Map<String, Object> row, int curRowIndex, Map<String, RowBufferStats> statsMap, Set<String> formattedInputColumnNames) {
        return this.convertRowToArrow(row, this.vectorsRoot, curRowIndex, statsMap, formattedInputColumnNames);
    }

    @Override
    float addTempRow(Map<String, Object> row, int curRowIndex, Map<String, RowBufferStats> statsMap, Set<String> formattedInputColumnNames) {
        return this.convertRowToArrow(row, this.tempVectorsRoot, curRowIndex, statsMap, formattedInputColumnNames);
    }

    private float convertRowToArrow(Map<String, Object> row, VectorSchemaRoot sourceVectors, int curRowIndex, Map<String, RowBufferStats> statsMap, Set<String> inputColumnNames) {
        float rowBufferSize = 0.0f;
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            rowBufferSize = (float)((double)rowBufferSize + 0.125);
            String columnName = LiteralQuoteUtils.unquoteColumnName(entry.getKey());
            Object value = entry.getValue();
            Field field = this.fields.get(columnName);
            Utils.assertNotNull("Arrow column field", field);
            FieldVector vector = sourceVectors.getVector(field);
            Utils.assertNotNull("Arrow column vector", vector);
            RowBufferStats stats = statsMap.get(columnName);
            Utils.assertNotNull("Arrow column stats", stats);
            AbstractRowBuffer.ColumnLogicalType logicalType = AbstractRowBuffer.ColumnLogicalType.valueOf((String)field.getMetadata().get(COLUMN_LOGICAL_TYPE));
            AbstractRowBuffer.ColumnPhysicalType physicalType = AbstractRowBuffer.ColumnPhysicalType.valueOf((String)field.getMetadata().get(COLUMN_PHYSICAL_TYPE));
            boolean isParsedValueNull = false;
            if (value != null) {
                block0 : switch (logicalType) {
                    case FIXED: {
                        int columnPrecision = Integer.parseInt((String)field.getMetadata().get(COLUMN_PRECISION));
                        int columnScale = this.getColumnScale(field.getMetadata());
                        BigDecimal inputAsBigDecimal = DataValidationUtil.validateAndParseBigDecimal(stats.getColumnDisplayName(), value);
                        inputAsBigDecimal = inputAsBigDecimal.setScale(columnScale, RoundingMode.HALF_UP);
                        DataValidationUtil.checkValueInRange(inputAsBigDecimal, columnScale, columnPrecision);
                        if (columnScale != 0 || physicalType == AbstractRowBuffer.ColumnPhysicalType.SB16) {
                            ((DecimalVector)vector).setSafe(curRowIndex, inputAsBigDecimal);
                            stats.addIntValue(inputAsBigDecimal.unscaledValue());
                            rowBufferSize += 16.0f;
                            break;
                        }
                        switch (physicalType) {
                            case SB1: {
                                ((TinyIntVector)vector).setSafe(curRowIndex, inputAsBigDecimal.byteValueExact());
                                stats.addIntValue(inputAsBigDecimal.toBigInteger());
                                rowBufferSize += 1.0f;
                                break block0;
                            }
                            case SB2: {
                                ((SmallIntVector)vector).setSafe(curRowIndex, inputAsBigDecimal.shortValueExact());
                                stats.addIntValue(inputAsBigDecimal.toBigInteger());
                                rowBufferSize += 2.0f;
                                break block0;
                            }
                            case SB4: {
                                ((IntVector)vector).setSafe(curRowIndex, inputAsBigDecimal.intValueExact());
                                stats.addIntValue(inputAsBigDecimal.toBigInteger());
                                rowBufferSize += 4.0f;
                                break block0;
                            }
                            case SB8: {
                                ((BigIntVector)vector).setSafe(curRowIndex, inputAsBigDecimal.longValueExact());
                                stats.addIntValue(inputAsBigDecimal.toBigInteger());
                                rowBufferSize += 8.0f;
                                break block0;
                            }
                        }
                        throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, new Object[]{logicalType, physicalType});
                    }
                    case ANY: 
                    case CHAR: 
                    case TEXT: {
                        String maxLengthString = (String)field.getMetadata().get(COLUMN_CHAR_LENGTH);
                        String str = DataValidationUtil.validateAndParseString(stats.getColumnDisplayName(), value, Optional.ofNullable(maxLengthString).map(Integer::parseInt));
                        Text text = new Text(str);
                        ((VarCharVector)vector).setSafe(curRowIndex, text);
                        stats.addStrValue(str);
                        rowBufferSize += (float)text.getBytes().length;
                        break;
                    }
                    case OBJECT: {
                        String str = DataValidationUtil.validateAndParseObject(stats.getColumnDisplayName(), value);
                        Text text = new Text(str);
                        ((VarCharVector)vector).setSafe(curRowIndex, text);
                        rowBufferSize += (float)text.getBytes().length;
                        break;
                    }
                    case ARRAY: {
                        String str = DataValidationUtil.validateAndParseArray(stats.getColumnDisplayName(), value);
                        Text text = new Text(str);
                        ((VarCharVector)vector).setSafe(curRowIndex, text);
                        rowBufferSize += (float)text.getBytes().length;
                        break;
                    }
                    case VARIANT: {
                        String str = DataValidationUtil.validateAndParseVariant(stats.getColumnDisplayName(), value);
                        if (str != null) {
                            Text text = new Text(str);
                            ((VarCharVector)vector).setSafe(curRowIndex, text);
                            rowBufferSize += (float)text.getBytes().length;
                            break;
                        }
                        isParsedValueNull = true;
                        break;
                    }
                    case TIMESTAMP_LTZ: 
                    case TIMESTAMP_NTZ: {
                        TimestampWrapper timestampWrapper;
                        boolean trimTimezone = logicalType == AbstractRowBuffer.ColumnLogicalType.TIMESTAMP_NTZ;
                        switch (physicalType) {
                            case SB8: {
                                BigIntVector bigIntVector = (BigIntVector)vector;
                                TimestampWrapper timestampWrapper2 = DataValidationUtil.validateAndParseTimestamp(stats.getColumnDisplayName(), value, this.getColumnScale(field.getMetadata()), this.defaultTimezone, trimTimezone);
                                BigInteger timestampBinary = timestampWrapper2.toBinary(false);
                                bigIntVector.setSafe(curRowIndex, timestampBinary.longValue());
                                stats.addIntValue(timestampBinary);
                                rowBufferSize += 8.0f;
                                break block0;
                            }
                            case SB16: {
                                StructVector structVector = (StructVector)vector;
                                BigIntVector epochVector = (BigIntVector)structVector.getChild(FIELD_EPOCH_IN_SECONDS);
                                IntVector fractionVector = (IntVector)structVector.getChild(FIELD_FRACTION_IN_NANOSECONDS);
                                rowBufferSize = (float)((double)rowBufferSize + 0.25);
                                structVector.setIndexDefined(curRowIndex);
                                timestampWrapper = DataValidationUtil.validateAndParseTimestamp(stats.getColumnDisplayName(), value, this.getColumnScale(field.getMetadata()), this.defaultTimezone, trimTimezone);
                                epochVector.setSafe(curRowIndex, timestampWrapper.getEpoch());
                                fractionVector.setSafe(curRowIndex, timestampWrapper.getFraction());
                                rowBufferSize += 12.0f;
                                stats.addIntValue(timestampWrapper.toBinary(false));
                                break block0;
                            }
                        }
                        throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, new Object[]{logicalType, physicalType});
                    }
                    case TIMESTAMP_TZ: {
                        TimestampWrapper timestampWrapper;
                        switch (physicalType) {
                            case SB8: {
                                StructVector structVector = (StructVector)vector;
                                BigIntVector epochVector = (BigIntVector)structVector.getChild(FIELD_EPOCH_IN_SECONDS);
                                IntVector timezoneVector = (IntVector)structVector.getChild(FIELD_TIME_ZONE);
                                rowBufferSize = (float)((double)rowBufferSize + 0.25);
                                structVector.setIndexDefined(curRowIndex);
                                timestampWrapper = DataValidationUtil.validateAndParseTimestamp(stats.getColumnDisplayName(), value, this.getColumnScale(field.getMetadata()), this.defaultTimezone, false);
                                epochVector.setSafe(curRowIndex, timestampWrapper.toBinary(false).longValueExact());
                                timezoneVector.setSafe(curRowIndex, timestampWrapper.getTimeZoneIndex());
                                rowBufferSize += 12.0f;
                                stats.addIntValue(timestampWrapper.toBinary(true));
                                break block0;
                            }
                            case SB16: {
                                StructVector structVector = (StructVector)vector;
                                BigIntVector epochVector = (BigIntVector)structVector.getChild(FIELD_EPOCH_IN_SECONDS);
                                IntVector fractionVector = (IntVector)structVector.getChild(FIELD_FRACTION_IN_NANOSECONDS);
                                IntVector timezoneVector = (IntVector)structVector.getChild(FIELD_TIME_ZONE);
                                rowBufferSize = (float)((double)rowBufferSize + 0.375);
                                structVector.setIndexDefined(curRowIndex);
                                TimestampWrapper timestampWrapper3 = DataValidationUtil.validateAndParseTimestamp(stats.getColumnDisplayName(), value, this.getColumnScale(field.getMetadata()), this.defaultTimezone, false);
                                epochVector.setSafe(curRowIndex, timestampWrapper3.getEpoch());
                                fractionVector.setSafe(curRowIndex, timestampWrapper3.getFraction());
                                timezoneVector.setSafe(curRowIndex, timestampWrapper3.getTimeZoneIndex());
                                rowBufferSize += 16.0f;
                                BigInteger timeInBinary = timestampWrapper3.toBinary(true);
                                stats.addIntValue(timeInBinary);
                                break block0;
                            }
                        }
                        throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, new Object[]{logicalType, physicalType});
                    }
                    case DATE: {
                        DateDayVector dateDayVector = (DateDayVector)vector;
                        int intValue = DataValidationUtil.validateAndParseDate(stats.getColumnDisplayName(), value);
                        dateDayVector.setSafe(curRowIndex, intValue);
                        stats.addIntValue(BigInteger.valueOf(intValue));
                        rowBufferSize += 4.0f;
                        break;
                    }
                    case TIME: {
                        switch (physicalType) {
                            case SB4: {
                                BigInteger timeInScale = DataValidationUtil.validateAndParseTime(stats.getColumnDisplayName(), value, this.getColumnScale(field.getMetadata()));
                                ((IntVector)vector).setSafe(curRowIndex, timeInScale.intValue());
                                stats.addIntValue(timeInScale);
                                rowBufferSize += 4.0f;
                                break block0;
                            }
                            case SB8: {
                                BigInteger timeInScale = DataValidationUtil.validateAndParseTime(stats.getColumnDisplayName(), value, this.getColumnScale(field.getMetadata()));
                                ((BigIntVector)vector).setSafe(curRowIndex, timeInScale.longValue());
                                stats.addIntValue(timeInScale);
                                rowBufferSize += 8.0f;
                                break block0;
                            }
                        }
                        throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, new Object[]{logicalType, physicalType});
                    }
                    case BOOLEAN: {
                        int intValue = DataValidationUtil.validateAndParseBoolean(stats.getColumnDisplayName(), value);
                        ((BitVector)vector).setSafe(curRowIndex, intValue);
                        rowBufferSize = (float)((double)rowBufferSize + 0.125);
                        stats.addIntValue(BigInteger.valueOf(intValue));
                        break;
                    }
                    case BINARY: {
                        String maxLengthString = (String)field.getMetadata().get(COLUMN_BYTE_LENGTH);
                        byte[] bytes = DataValidationUtil.validateAndParseBinary(stats.getColumnDisplayName(), value, Optional.ofNullable(maxLengthString).map(Integer::parseInt));
                        ((VarBinaryVector)vector).setSafe(curRowIndex, bytes);
                        stats.addBinaryValue(bytes);
                        rowBufferSize += (float)bytes.length;
                        break;
                    }
                    case REAL: {
                        double doubleValue = DataValidationUtil.validateAndParseReal(stats.getColumnDisplayName(), value);
                        ((Float8Vector)vector).setSafe(curRowIndex, doubleValue);
                        stats.addRealValue(doubleValue);
                        rowBufferSize += 8.0f;
                        break;
                    }
                    default: {
                        throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, new Object[]{logicalType, physicalType});
                    }
                }
            }
            if (value != null && !isParsedValueNull) continue;
            if (!field.getFieldType().isNullable()) {
                throw new SFException(ErrorCode.INVALID_ROW, columnName, "Passed null to non nullable field");
            }
            this.insertNull(vector, stats, curRowIndex);
        }
        for (String columnName : Sets.difference(this.fields.keySet(), inputColumnNames)) {
            rowBufferSize = (float)((double)rowBufferSize + 0.125);
            this.insertNull(sourceVectors.getVector(this.fields.get(columnName)), statsMap.get(columnName), curRowIndex);
        }
        return rowBufferSize;
    }

    private void insertNull(FieldVector vector, RowBufferStats stats, int curRowIndex) {
        if (BaseFixedWidthVector.class.isAssignableFrom(vector.getClass())) {
            ((BaseFixedWidthVector)vector).setNull(curRowIndex);
        } else if (BaseVariableWidthVector.class.isAssignableFrom(vector.getClass())) {
            ((BaseVariableWidthVector)vector).setNull(curRowIndex);
        } else if (vector instanceof StructVector) {
            ((StructVector)vector).setNull(curRowIndex);
            ((StructVector)vector).getChildrenFromFields().forEach(child -> ((BaseFixedWidthVector)child).setNull(curRowIndex));
        } else {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "Unexpected FieldType");
        }
        stats.incCurrentNullCount();
    }

    private int getColumnScale(Map<String, String> metadata) {
        return Integer.parseInt(metadata.get(COLUMN_SCALE));
    }

    @Override
    public Flusher<VectorSchemaRoot> createFlusher() {
        return new ArrowFlusher();
    }

    @Override
    @VisibleForTesting
    Object getVectorValueAt(String column, int index) {
        Object value = this.vectorsRoot.getVector(column).getObject(index);
        return value instanceof Text ? new String(((Text)value).getBytes()) : value;
    }

    @Override
    @VisibleForTesting
    int getTempRowCount() {
        return this.tempVectorsRoot.getRowCount();
    }
}

