/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.GZIPOutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import net.snowflake.ingest.streaming.internal.AbstractRowBuffer;
import net.snowflake.ingest.streaming.internal.ChannelData;
import net.snowflake.ingest.streaming.internal.ChannelFlushContext;
import net.snowflake.ingest.streaming.internal.ChunkMetadata;
import net.snowflake.ingest.streaming.internal.Flusher;
import net.snowflake.ingest.utils.Constants;
import net.snowflake.ingest.utils.Cryptor;
import net.snowflake.ingest.utils.Logging;
import net.snowflake.ingest.utils.Pair;
import org.apache.commons.codec.binary.Hex;

class BlobBuilder {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logging logger = new Logging(BlobBuilder.class);

    BlobBuilder() {
    }

    static <T> Blob constructBlobAndMetadata(String filePath, List<List<ChannelData<T>>> blobData, Constants.BdecVersion bdecVersion) throws IOException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        ArrayList<ChunkMetadata> chunksMetadataList = new ArrayList<ChunkMetadata>();
        ArrayList<byte[]> chunksDataList = new ArrayList<byte[]>();
        long curDataSize = 0L;
        CRC32 crc = new CRC32();
        for (List<ChannelData<T>> channelsDataPerTable : blobData) {
            ChannelFlushContext firstChannelFlushContext = channelsDataPerTable.get(0).getChannelContext();
            Flusher<T> flusher = channelsDataPerTable.get(0).createFlusher();
            Flusher.SerializationResult serializedChunk = flusher.serialize(channelsDataPerTable, filePath);
            if (serializedChunk.channelsMetadataList.isEmpty()) continue;
            ByteArrayOutputStream chunkData = serializedChunk.chunkData;
            Pair<byte[], Integer> compressionResult = BlobBuilder.compressIfNeededAndPadChunk(filePath, chunkData, 16, bdecVersion == Constants.BdecVersion.ONE);
            byte[] compressedAndPaddedChunkData = compressionResult.getFirst();
            int compressedChunkLength = compressionResult.getSecond();
            long iv = curDataSize / 16L;
            byte[] encryptedCompressedChunkData = Cryptor.encrypt(compressedAndPaddedChunkData, firstChannelFlushContext.getEncryptionKey(), filePath, iv);
            String md5 = BlobBuilder.computeMD5(encryptedCompressedChunkData, compressedChunkLength);
            int encryptedCompressedChunkDataSize = encryptedCompressedChunkData.length;
            long startOffset = curDataSize;
            ChunkMetadata chunkMetadata = ChunkMetadata.builder().setOwningTableFromChannelContext(firstChannelFlushContext).setChunkStartOffset(startOffset).setChunkLength(compressedChunkLength).setChannelList(serializedChunk.channelsMetadataList).setChunkMD5(md5).setEncryptionKeyId(firstChannelFlushContext.getEncryptionKeyId()).setEpInfo(AbstractRowBuffer.buildEpInfoFromStats(serializedChunk.rowCount, serializedChunk.columnEpStatsMapCombined)).setFirstInsertTimeInMs(serializedChunk.chunkMinMaxInsertTimeInMs.getFirst()).setLastInsertTimeInMs(serializedChunk.chunkMinMaxInsertTimeInMs.getSecond()).build();
            chunksMetadataList.add(chunkMetadata);
            chunksDataList.add(encryptedCompressedChunkData);
            curDataSize += (long)encryptedCompressedChunkDataSize;
            crc.update(encryptedCompressedChunkData, 0, encryptedCompressedChunkDataSize);
            logger.logInfo("Finish building chunk in blob={}, table={}, rowCount={}, startOffset={}, uncompressedSize={}, compressedChunkLength={}, encryptedCompressedSize={}, bdecVersion={}", new Object[]{filePath, firstChannelFlushContext.getFullyQualifiedTableName(), serializedChunk.rowCount, startOffset, chunkData.size(), compressedChunkLength, encryptedCompressedChunkDataSize, bdecVersion});
        }
        byte[] blobBytes = BlobBuilder.buildBlob(chunksMetadataList, chunksDataList, crc.getValue(), curDataSize, bdecVersion);
        return new Blob(blobBytes, chunksMetadataList);
    }

    static Pair<byte[], Integer> compress(String filePath, ByteArrayOutputStream chunkData, int blockSizeToAlignTo) throws IOException {
        int uncompressedSize = chunkData.size();
        ByteArrayOutputStream compressedOutputStream = new ByteArrayOutputStream(uncompressedSize);
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream((OutputStream)compressedOutputStream, true);){
            gzipOutputStream.write(chunkData.toByteArray());
        }
        int firstCompressedSize = compressedOutputStream.size();
        int doubleCompressedSize = 0;
        logger.logDebug("Finish compressing chunk in blob={}, uncompressedSize={}, firstCompressedSize={}, doubleCompressedSize={}", filePath, uncompressedSize, firstCompressedSize, doubleCompressedSize);
        int compressedSize = compressedOutputStream.size();
        int paddingSize = blockSizeToAlignTo - compressedSize % blockSizeToAlignTo;
        compressedOutputStream.write(new byte[paddingSize]);
        return new Pair<byte[], Integer>(compressedOutputStream.toByteArray(), compressedSize);
    }

    static Pair<byte[], Integer> compressIfNeededAndPadChunk(String filePath, ByteArrayOutputStream chunkData, int blockSizeToAlignTo, boolean compress) throws IOException {
        if (compress) {
            return BlobBuilder.compress(filePath, chunkData, blockSizeToAlignTo);
        }
        int actualSize = chunkData.size();
        int paddingSize = blockSizeToAlignTo - actualSize % blockSizeToAlignTo;
        chunkData.write(new byte[paddingSize]);
        return new Pair<byte[], Integer>(chunkData.toByteArray(), actualSize);
    }

    static byte[] buildBlob(List<ChunkMetadata> chunksMetadataList, List<byte[]> chunksDataList, long chunksChecksum, long chunksDataSize, Constants.BdecVersion bdecVersion) throws IOException {
        byte[] chunkMetadataListInBytes = MAPPER.writeValueAsBytes(chunksMetadataList);
        int metadataSize = 0;
        ByteArrayOutputStream blob = new ByteArrayOutputStream();
        for (byte[] arrowData : chunksDataList) {
            blob.write(arrowData);
        }
        for (ChunkMetadata chunkMetadata : chunksMetadataList) {
            chunkMetadata.advanceStartOffset(metadataSize);
        }
        return blob.toByteArray();
    }

    static String computeMD5(byte[] data) throws NoSuchAlgorithmException {
        return BlobBuilder.computeMD5(data, data.length);
    }

    static String computeMD5(byte[] data, int length) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(data, 0, length);
        byte[] digest = md.digest();
        return Hex.encodeHexString((byte[])digest);
    }

    static class Blob {
        final byte[] blobBytes;
        final List<ChunkMetadata> chunksMetadataList;

        Blob(byte[] blobBytes, List<ChunkMetadata> chunksMetadataList) {
            this.blobBytes = blobBytes;
            this.chunksMetadataList = chunksMetadataList;
        }
    }
}

