/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import net.snowflake.ingest.streaming.internal.ChunkMetadata;
import net.snowflake.ingest.utils.Constants;
import net.snowflake.ingest.utils.ParameterProvider;

class BlobMetadata {
    private final String path;
    private final String md5;
    private final Constants.BdecVersion bdecVersion;
    private final List<ChunkMetadata> chunks;

    BlobMetadata(String path, String md5, List<ChunkMetadata> chunks) {
        this(path, md5, ParameterProvider.BLOB_FORMAT_VERSION_DEFAULT, chunks);
    }

    BlobMetadata(String path, String md5, Constants.BdecVersion bdecVersion, List<ChunkMetadata> chunks) {
        this.path = path;
        this.md5 = md5;
        this.bdecVersion = bdecVersion;
        this.chunks = chunks;
    }

    @JsonIgnore
    Constants.BdecVersion getVersion() {
        return this.bdecVersion;
    }

    @JsonProperty(value="path")
    String getPath() {
        return this.path;
    }

    @JsonProperty(value="md5")
    String getMD5() {
        return this.md5;
    }

    @JsonProperty(value="chunks")
    List<ChunkMetadata> getChunks() {
        return this.chunks;
    }

    @JsonProperty(value="bdec_version")
    byte getVersionByte() {
        return this.bdecVersion.toByte();
    }

    static BlobMetadata createBlobMetadata(String path, String md5, Constants.BdecVersion bdecVersion, List<ChunkMetadata> chunks) {
        return new BlobMetadata(path, md5, bdecVersion, chunks);
    }
}

