/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.snowflake.ingest.streaming.internal.SnowflakeStreamingIngestChannelInternal;

class ChannelCache<T> {
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, SnowflakeStreamingIngestChannelInternal<T>>> cache = new ConcurrentHashMap();

    ChannelCache() {
    }

    void addChannel(SnowflakeStreamingIngestChannelInternal<T> channel) {
        ConcurrentHashMap channels = this.cache.computeIfAbsent(channel.getFullyQualifiedTableName(), v -> new ConcurrentHashMap());
        SnowflakeStreamingIngestChannelInternal<T> oldChannel = channels.put(channel.getName(), channel);
        if (oldChannel != null) {
            oldChannel.invalidate("removed from cache");
        }
    }

    Iterator<Map.Entry<String, ConcurrentHashMap<String, SnowflakeStreamingIngestChannelInternal<T>>>> iterator() {
        return this.cache.entrySet().iterator();
    }

    void closeAllChannels() {
        this.cache.values().forEach(channels -> channels.values().forEach(channel -> channel.markClosed()));
    }

    void removeChannelIfSequencersMatch(SnowflakeStreamingIngestChannelInternal<T> channel) {
        this.cache.computeIfPresent(channel.getFullyQualifiedTableName(), (k, v) -> {
            SnowflakeStreamingIngestChannelInternal channelInCache = (SnowflakeStreamingIngestChannelInternal)v.get(channel.getName());
            return channelInCache != null && channelInCache.getChannelSequencer() == channel.getChannelSequencer() && v.remove(channel.getName()) != null && v.isEmpty() ? null : v;
        });
    }

    void invalidateChannelIfSequencersMatch(String dbName, String schemaName, String tableName, String channelName, Long channelSequencer) {
        SnowflakeStreamingIngestChannelInternal<T> channel;
        String fullyQualifiedTableName = String.format("%s.%s.%s", dbName, schemaName, tableName);
        ConcurrentHashMap<String, SnowflakeStreamingIngestChannelInternal<T>> channelsMapPerTable = this.cache.get(fullyQualifiedTableName);
        if (channelsMapPerTable != null && (channel = channelsMapPerTable.get(channelName)) != null && channel.getChannelSequencer().equals(channelSequencer)) {
            channel.invalidate("invalidate with matched sequencer");
        }
    }

    int getSize() {
        return this.cache.size();
    }
}

