/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import net.snowflake.client.jdbc.internal.apache.http.HttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpUriRequest;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.ingest.connection.IngestResponseException;
import net.snowflake.ingest.connection.RequestBuilder;
import net.snowflake.ingest.connection.ServiceResponseHandler;
import net.snowflake.ingest.streaming.internal.StreamingIngestResponse;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.Logging;
import net.snowflake.ingest.utils.SFException;

public class StreamingIngestUtils {
    private static final DefaultStatusGetter defaultStatusGetter = new DefaultStatusGetter();
    private static final Logging LOGGER = new Logging(StreamingIngestUtils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    static void sleepForRetry(int executionCount) {
        try {
            Thread.sleep((1 << executionCount + 1) * 1000);
        }
        catch (InterruptedException e) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, e.getMessage());
        }
    }

    static <T extends StreamingIngestResponse> T executeWithRetries(Class<T> targetClass, String endpoint, Map<Object, Object> payload, String message, ServiceResponseHandler.ApiName apiName, CloseableHttpClient httpClient, RequestBuilder requestBuilder) throws IOException, IngestResponseException {
        String payloadInString;
        try {
            payloadInString = objectMapper.writeValueAsString(payload);
        }
        catch (JsonProcessingException e) {
            throw new SFException(e, ErrorCode.BUILD_REQUEST_FAILURE, message);
        }
        return StreamingIngestUtils.executeWithRetries(targetClass, endpoint, payloadInString, message, apiName, httpClient, requestBuilder);
    }

    static <T extends StreamingIngestResponse> T executeWithRetries(Class<T> targetClass, String endpoint, String payload, String message, ServiceResponseHandler.ApiName apiName, CloseableHttpClient httpClient, RequestBuilder requestBuilder) throws IOException, IngestResponseException {
        return (T)((StreamingIngestResponse)StreamingIngestUtils.executeWithRetries(targetClass, endpoint, payload, message, apiName, httpClient, requestBuilder, defaultStatusGetter));
    }

    static <T> T executeWithRetries(Class<T> targetClass, String endpoint, String payload, String message, ServiceResponseHandler.ApiName apiName, CloseableHttpClient httpClient, RequestBuilder requestBuilder, Function<T, Long> statusGetter) throws IOException, IngestResponseException {
        T response;
        int retries = 0;
        do {
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)requestBuilder.generateStreamingIngestPostRequest(payload, endpoint, message));){
                response = ServiceResponseHandler.unmarshallStreamingIngestResponse((HttpResponse)httpResponse, targetClass, apiName);
            }
            if (statusGetter.apply(response) != 10L) {
                return response;
            }
            LOGGER.logDebug("Retrying request for streaming ingest, endpoint={}, retryCount={}, responseCode={}", endpoint, retries, statusGetter.apply(response));
            StreamingIngestUtils.sleepForRetry(++retries);
        } while (retries <= 3);
        return response;
    }

    public static String getShortname(String fullname) {
        String[] parts = fullname.split("/");
        return parts[parts.length - 1];
    }

    private static class DefaultStatusGetter<T extends StreamingIngestResponse>
    implements Function<T, Long> {
        @Override
        public Long apply(T input) {
            return ((StreamingIngestResponse)input).getStatusCode();
        }
    }
}

