/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.utils;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.arrow.util.VisibleForTesting;

public class Cryptor {
    public static byte[] sha256Hash(byte[] input, int offset, int len) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(input, offset, len);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sha256Hash(byte[] input) {
        return Cryptor.sha256Hash(input, 0, input.length);
    }

    public static String sha256HashBase64(byte[] input) {
        return Base64.getEncoder().encodeToString(Cryptor.sha256Hash(input));
    }

    private static SecretKey deriveKey(String secretKey, String diversifier) {
        byte[] decodedString = Base64.getDecoder().decode(secretKey);
        byte[] concat = Cryptor.concat(decodedString, diversifier.getBytes(StandardCharsets.UTF_8));
        byte[] derivedBytes = Cryptor.sha256Hash(concat);
        return new SecretKeySpec(derivedBytes, "AES");
    }

    private static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static byte[] encrypt(byte[] compressedChunkData, String encryptionKey, String diversifier, long iv) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        SecretKey derivedKey = Cryptor.deriveKey(encryptionKey, diversifier);
        Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
        byte[] ivBytes = ByteBuffer.allocate(16).putLong(0L).putLong(iv).array();
        cipher.init(1, (Key)derivedKey, new IvParameterSpec(ivBytes));
        return cipher.doFinal(compressedChunkData);
    }

    @VisibleForTesting
    public static byte[] decrypt(byte[] input, String encryptionKey, String diversifier, long iv) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        SecretKey derivedKey = Cryptor.deriveKey(encryptionKey, diversifier);
        Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
        byte[] ivBytes = ByteBuffer.allocate(16).putLong(0L).putLong(iv).array();
        cipher.init(2, (Key)derivedKey, new IvParameterSpec(ivBytes));
        return cipher.doFinal(input);
    }
}

