/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.utils;

import java.security.Security;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.jdbc.internal.apache.http.HttpHost;
import net.snowflake.client.jdbc.internal.apache.http.HttpRequest;
import net.snowflake.client.jdbc.internal.apache.http.HttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.NoHttpResponseException;
import net.snowflake.client.jdbc.internal.apache.http.auth.AuthScope;
import net.snowflake.client.jdbc.internal.apache.http.auth.Credentials;
import net.snowflake.client.jdbc.internal.apache.http.auth.UsernamePasswordCredentials;
import net.snowflake.client.jdbc.internal.apache.http.client.CredentialsProvider;
import net.snowflake.client.jdbc.internal.apache.http.client.HttpRequestRetryHandler;
import net.snowflake.client.jdbc.internal.apache.http.client.ServiceUnavailableRetryStrategy;
import net.snowflake.client.jdbc.internal.apache.http.client.config.RequestConfig;
import net.snowflake.client.jdbc.internal.apache.http.client.protocol.HttpClientContext;
import net.snowflake.client.jdbc.internal.apache.http.conn.HttpClientConnectionManager;
import net.snowflake.client.jdbc.internal.apache.http.conn.routing.HttpRoute;
import net.snowflake.client.jdbc.internal.apache.http.conn.routing.HttpRoutePlanner;
import net.snowflake.client.jdbc.internal.apache.http.conn.socket.LayeredConnectionSocketFactory;
import net.snowflake.client.jdbc.internal.apache.http.conn.ssl.DefaultHostnameVerifier;
import net.snowflake.client.jdbc.internal.apache.http.conn.ssl.SSLConnectionSocketFactory;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.BasicCredentialsProvider;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.HttpClientBuilder;
import net.snowflake.client.jdbc.internal.apache.http.impl.conn.DefaultProxyRoutePlanner;
import net.snowflake.client.jdbc.internal.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import net.snowflake.client.jdbc.internal.apache.http.pool.PoolStats;
import net.snowflake.client.jdbc.internal.apache.http.protocol.HttpContext;
import net.snowflake.client.jdbc.internal.apache.http.ssl.SSLContexts;
import net.snowflake.ingest.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    public static final String USE_PROXY = "http.useProxy";
    public static final String PROXY_HOST = "http.proxyHost";
    public static final String PROXY_PORT = "http.proxyPort";
    public static final String HTTP_PROXY_USER = "http.proxyUser";
    public static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private static final String PROXY_SCHEME = "http";
    private static final String FIRST_FAULT_TIMESTAMP = "FIRST_FAULT_TIMESTAMP";
    private static final Duration TOTAL_RETRY_DURATION = Duration.of(120L, ChronoUnit.SECONDS);
    private static final Duration RETRY_INTERVAL = Duration.of(3L, ChronoUnit.SECONDS);
    private static final int MAX_RETRIES = 3;
    private static volatile CloseableHttpClient httpClient;
    private static PoolingHttpClientConnectionManager connectionManager;
    private static IdleConnectionMonitorThread idleConnectionMonitorThread;
    private static final ReentrantLock idleConnectionMonitorThreadLock;
    private static final int DEFAULT_CONNECTION_TIMEOUT_MINUTES = 1;
    private static final int DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT_MINUTES = 5;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 100;
    private static final int DEFAULT_MAX_CONNECTIONS = 100;
    private static final long IDLE_HTTP_CONNECTION_MONITOR_THREAD_INTERVAL_MS;
    private static final int DEFAULT_IDLE_CONNECTION_TIMEOUT_SECONDS = 30;
    private static final Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static CloseableHttpClient getHttpClient() {
        if (httpClient == null) {
            Class<HttpUtil> clazz = HttpUtil.class;
            // MONITORENTER : net.snowflake.ingest.utils.HttpUtil.class
            if (httpClient == null) {
                HttpUtil.initHttpClient();
            }
            // MONITOREXIT : clazz
        }
        HttpUtil.initIdleConnectionMonitoringThread();
        return httpClient;
    }

    private static void initHttpClient() {
        Security.setProperty("ocsp.enable", "true");
        SSLContext sslContext = SSLContexts.createDefault();
        SSLConnectionSocketFactory f = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, (HostnameVerifier)new DefaultHostnameVerifier());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES)).setConnectionRequestTimeout((int)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES)).setSocketTimeout((int)TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES)).build();
        connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(100);
        connectionManager.setMaxTotal(100);
        HttpClientBuilder clientBuilder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).setSSLSocketFactory((LayeredConnectionSocketFactory)f).setServiceUnavailableRetryStrategy(HttpUtil.getServiceUnavailableRetryStrategy()).setRetryHandler(HttpUtil.getHttpRequestRetryHandler()).setDefaultRequestConfig(requestConfig);
        if ("true".equalsIgnoreCase(System.getProperty(USE_PROXY))) {
            if (System.getProperty(PROXY_PORT) == null) {
                throw new IllegalArgumentException("proxy port number is not provided, please assign proxy port to http.proxyPort option");
            }
            if (System.getProperty(PROXY_HOST) == null) {
                throw new IllegalArgumentException("proxy host IP is not provided, please assign proxy host IP to http.proxyHost option");
            }
            String proxyHost = System.getProperty(PROXY_HOST);
            int proxyPort = Integer.parseInt(System.getProperty(PROXY_PORT));
            HttpHost proxy = new HttpHost(proxyHost, proxyPort, PROXY_SCHEME);
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            clientBuilder = clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            String proxyUser = System.getProperty(HTTP_PROXY_USER);
            String proxyPassword = System.getProperty(HTTP_PROXY_PASSWORD);
            if (!Utils.isNullOrEmpty(proxyUser) && !Utils.isNullOrEmpty(proxyPassword)) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
                AuthScope authScope = new AuthScope(proxyHost, proxyPort);
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(authScope, (Credentials)credentials);
                clientBuilder = clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
        httpClient = clientBuilder.build();
    }

    private static void initIdleConnectionMonitoringThread() {
        idleConnectionMonitorThreadLock.lock();
        try {
            if (connectionManager != null && (idleConnectionMonitorThread == null || HttpUtil.idleConnectionMonitorThread.isShutdown())) {
                idleConnectionMonitorThread = new IdleConnectionMonitorThread(connectionManager);
                idleConnectionMonitorThread.setDaemon(true);
                idleConnectionMonitorThread.start();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to start Daemon thread for Http Idle Connection Monitoring", (Throwable)e);
        }
        finally {
            idleConnectionMonitorThreadLock.unlock();
        }
    }

    private static ServiceUnavailableRetryStrategy getServiceUnavailableRetryStrategy() {
        return new ServiceUnavailableRetryStrategy(){
            final int REQUEST_TIMEOUT = 408;
            final int TOO_MANY_REQUESTS = 429;
            final int SERVER_ERRORS = 500;

            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                boolean needNextRetry;
                Object firstFault = context.getAttribute(HttpUtil.FIRST_FAULT_TIMESTAMP);
                long totalRetryDurationSoFarInSeconds = 0L;
                if (firstFault == null) {
                    context.setAttribute(HttpUtil.FIRST_FAULT_TIMESTAMP, (Object)Instant.now());
                } else {
                    Instant firstFaultInstant = (Instant)firstFault;
                    Instant now = Instant.now();
                    totalRetryDurationSoFarInSeconds = Duration.between(firstFaultInstant, now).getSeconds();
                    if (totalRetryDurationSoFarInSeconds > TOTAL_RETRY_DURATION.getSeconds()) {
                        LOGGER.info(String.format("Reached the max retry time of %d seconds, not retrying anymore", TOTAL_RETRY_DURATION.getSeconds()));
                        return false;
                    }
                }
                int statusCode = response.getStatusLine().getStatusCode();
                boolean bl = needNextRetry = statusCode == 408 || statusCode == 429 || statusCode >= 500;
                if (needNextRetry) {
                    long interval = this.getRetryInterval();
                    LOGGER.info("In retryRequest for service unavailability with statusCode:{} and uri:{}", (Object)statusCode, (Object)HttpUtil.getRequestUriFromContext(context));
                    LOGGER.info("Sleep time in millisecond: {}, retryCount: {}, total retry duration: {}s / {}s", new Object[]{interval, executionCount, totalRetryDurationSoFarInSeconds, TOTAL_RETRY_DURATION.getSeconds()});
                }
                return needNextRetry;
            }

            public long getRetryInterval() {
                return RETRY_INTERVAL.toMillis();
            }
        };
    }

    private static HttpRequestRetryHandler getHttpRequestRetryHandler() {
        return (exception, executionCount, httpContext) -> {
            String requestURI = HttpUtil.getRequestUriFromContext(httpContext);
            if (executionCount > 3) {
                LOGGER.info("Max retry exceeded for requestURI:{}", (Object)requestURI);
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                LOGGER.info("Retrying request which caused No HttpResponse Exception with URI:{}, retryCount:{} and maxRetryCount:{}", new Object[]{requestURI, executionCount, 3});
                return true;
            }
            LOGGER.info("No retry for URI:{} with exception", (Object)requestURI, (Object)exception);
            return false;
        };
    }

    private static String getRequestUriFromContext(HttpContext httpContext) {
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)httpContext);
        HttpRequest httpRequest = clientContext.getRequest();
        return httpRequest.getRequestLine().getUri();
    }

    public static Properties generateProxyPropertiesForJDBC() {
        Properties proxyProperties = new Properties();
        if (Boolean.parseBoolean(System.getProperty(USE_PROXY))) {
            if (Utils.isNullOrEmpty(System.getProperty(PROXY_PORT))) {
                throw new IllegalArgumentException("proxy port number is not provided, please assign proxy port to http.proxyPort option");
            }
            if (Utils.isNullOrEmpty(System.getProperty(PROXY_HOST))) {
                throw new IllegalArgumentException("proxy host IP is not provided, please assign proxy host IP to http.proxyHost option");
            }
            proxyProperties.put(SFSessionProperty.USE_PROXY.getPropertyKey(), "true");
            proxyProperties.put(SFSessionProperty.PROXY_HOST.getPropertyKey(), System.getProperty(PROXY_HOST));
            proxyProperties.put(SFSessionProperty.PROXY_PORT.getPropertyKey(), System.getProperty(PROXY_PORT));
            String proxyUser = System.getProperty(HTTP_PROXY_USER);
            String proxyPassword = System.getProperty(HTTP_PROXY_PASSWORD);
            if (!Utils.isNullOrEmpty(proxyUser) && !Utils.isNullOrEmpty(proxyPassword)) {
                proxyProperties.put(SFSessionProperty.PROXY_USER.getPropertyKey(), proxyUser);
                proxyProperties.put(SFSessionProperty.PROXY_PASSWORD.getPropertyKey(), proxyPassword);
            }
        }
        return proxyProperties;
    }

    public static void shutdownHttpConnectionManagerDaemonThread() {
        HttpUtil.idleConnectionMonitorThread.shutdown();
    }

    private static String createPoolStatsForRoute(PoolingHttpClientConnectionManager connectionManager, HttpRoute route) {
        PoolStats routeStats = connectionManager.getStats(route);
        return HttpUtil.createPoolStatsInfo(String.format("Pool Stats for route %s = ", route.getTargetHost().toURI()), routeStats);
    }

    private static String createPoolStatsInfo(String title, PoolStats poolStats) {
        if (poolStats != null) {
            return title + poolStats + "\n";
        }
        return title;
    }

    static {
        idleConnectionMonitorThreadLock = new ReentrantLock(true);
        IDLE_HTTP_CONNECTION_MONITOR_THREAD_INTERVAL_MS = TimeUnit.SECONDS.toMillis(5L);
        LOGGER = LoggerFactory.getLogger(HttpUtil.class);
    }

    private static class IdleConnectionMonitorThread
    extends Thread {
        private final PoolingHttpClientConnectionManager connectionManager;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(PoolingHttpClientConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LOGGER.debug("Starting Idle Connection Monitor Thread ");
                IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                synchronized (idleConnectionMonitorThread) {
                    while (!this.shutdown) {
                        this.wait(IDLE_HTTP_CONNECTION_MONITOR_THREAD_INTERVAL_MS);
                        StringBuilder sb = new StringBuilder();
                        sb.append(HttpUtil.createPoolStatsInfo("Total Pool Stats = ", this.connectionManager.getTotalStats()));
                        Set routes = this.connectionManager.getRoutes();
                        if (routes != null) {
                            for (HttpRoute route : routes) {
                                sb.append(HttpUtil.createPoolStatsForRoute(this.connectionManager, route));
                            }
                        }
                        LOGGER.debug("[IdleConnectionMonitorThread] Pool Stats:\n" + sb);
                        this.connectionManager.closeExpiredConnections();
                        this.connectionManager.closeIdleConnections(30L, TimeUnit.SECONDS);
                    }
                }
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Terminating Idle Connection Monitor Thread ");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() {
            if (!this.shutdown) {
                LOGGER.debug("Shutdown Idle Connection Monitor Thread ");
                this.shutdown = true;
                IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                synchronized (idleConnectionMonitorThread) {
                    this.notifyAll();
                }
            }
        }

        private boolean isShutdown() {
            return this.shutdown;
        }
    }
}

