/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.utils;

import com.codahale.metrics.Timer;
import io.netty.util.internal.PlatformDependent;
import java.io.Reader;
import java.io.StringReader;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jce.provider.BouncyCastleProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.openssl.PEMParser;
import net.snowflake.client.jdbc.internal.org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.InputDecryptorProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.Logging;
import net.snowflake.ingest.utils.SFException;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.commons.codec.binary.Base64;

public class Utils {
    private static final Logging logger = new Logging(Utils.class);

    public static void assertStringNotNullOrEmpty(String name, String value) throws SFException {
        if (Utils.isNullOrEmpty(value)) {
            throw new SFException(ErrorCode.NULL_OR_EMPTY_STRING, name);
        }
    }

    public static void assertNotNull(String name, Object value) throws SFException {
        if (value == null) {
            throw new SFException(ErrorCode.NULL_VALUE, name);
        }
    }

    public static Properties createProperties(Properties inputProp) {
        Properties properties = new Properties();
        String privateKey = "";
        String privateKeyPassphrase = "";
        block8: for (Map.Entry<Object, Object> entry : inputProp.entrySet()) {
            String key = entry.getKey().toString();
            String val = entry.getValue().toString();
            switch (key.toLowerCase()) {
                case "private_key": {
                    privateKey = val;
                    continue block8;
                }
                case "private_key_passphrase": {
                    privateKeyPassphrase = val;
                    continue block8;
                }
            }
            properties.put(key.toLowerCase(), val);
        }
        if (!privateKeyPassphrase.isEmpty()) {
            properties.put("privateKey", Utils.parseEncryptedPrivateKey(privateKey, privateKeyPassphrase));
        } else if (!privateKey.isEmpty()) {
            properties.put("privateKey", Utils.parsePrivateKey(privateKey));
        }
        if (!properties.containsKey("privateKey")) {
            throw new SFException(ErrorCode.MISSING_CONFIG, "private_key");
        }
        if (!properties.containsKey("user")) {
            throw new SFException(ErrorCode.MISSING_CONFIG, "user");
        }
        if (!properties.containsKey("url")) {
            if (!properties.containsKey("host")) {
                throw new SFException(ErrorCode.MISSING_CONFIG, "host");
            }
            if (!properties.containsKey("scheme")) {
                throw new SFException(ErrorCode.MISSING_CONFIG, "scheme");
            }
            if (!properties.containsKey("port")) {
                throw new SFException(ErrorCode.MISSING_CONFIG, "port");
            }
            properties.put("url", Utils.constructAccountUrl(properties.get("scheme").toString(), properties.get("host").toString(), Integer.parseInt(properties.get("port").toString())));
        }
        if (!properties.containsKey("role")) {
            throw new SFException(ErrorCode.MISSING_CONFIG, "role");
        }
        return properties;
    }

    public static String constructAccountUrl(String scheme, String host, int port) {
        return String.format("%s://%s:%d", scheme, host, port);
    }

    public static PrivateKey parsePrivateKey(String key) {
        key = key.replaceAll("-+[A-Za-z ]+-+", "");
        key = key.replaceAll("\\s", "");
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] encoded = Base64.decodeBase64((String)key);
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
            return kf.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new SFException(e, ErrorCode.INVALID_PRIVATE_KEY, new Object[0]);
        }
    }

    public static PrivateKey parseEncryptedPrivateKey(String key, String passphrase) {
        key = key.replaceAll("-+[A-Za-z ]+-+", "");
        key = key.replaceAll("\\s", "");
        StringBuilder builder = new StringBuilder();
        builder.append("-----BEGIN ENCRYPTED PRIVATE KEY-----");
        for (int i = 0; i < key.length(); ++i) {
            if (i % 64 == 0) {
                builder.append("\n");
            }
            builder.append(key.charAt(i));
        }
        builder.append("\n-----END ENCRYPTED PRIVATE KEY-----");
        key = builder.toString();
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            PEMParser pemParser = new PEMParser((Reader)new StringReader(key));
            PKCS8EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)pemParser.readObject();
            pemParser.close();
            InputDecryptorProvider pkcs8Prov = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(passphrase.toCharArray());
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            PrivateKeyInfo decryptedPrivateKeyInfo = encryptedPrivateKeyInfo.decryptPrivateKeyInfo(pkcs8Prov);
            return converter.getPrivateKey(decryptedPrivateKeyInfo);
        }
        catch (Exception e) {
            throw new SFException(e, ErrorCode.INVALID_ENCRYPTED_KEY, new Object[0]);
        }
    }

    public static KeyPair createKeyPairFromPrivateKey(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (!(privateKey instanceof RSAPrivateCrtKey)) {
            throw new IllegalArgumentException("Input private key is not a RSA private key");
        }
        KeyFactory kf = KeyFactory.getInstance("RSA");
        RSAPrivateCrtKey privk = (RSAPrivateCrtKey)privateKey;
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(privk.getModulus(), privk.getPublicExponent());
        PublicKey publicK = kf.generatePublic(publicKeySpec);
        return new KeyPair(publicK, privateKey);
    }

    public static Timer.Context createTimerContext(Timer timer) {
        return timer == null ? null : timer.time();
    }

    public static byte[] toByteArray(long value) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result;
    }

    public static byte[] toByteArray(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static void closeAllocator(BufferAllocator alloc) {
        for (BufferAllocator childAlloc : alloc.getChildAllocators()) {
            childAlloc.close();
        }
        alloc.close();
    }

    public static void showMemory() {
        List<BufferPoolMXBean> pools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        for (BufferPoolMXBean pool : pools) {
            logger.logInfo("Pool name={}, pool count={}, memory used={}, total capacity={}", pool.getName(), pool.getCount(), pool.getMemoryUsed(), pool.getTotalCapacity());
        }
        Runtime runtime = Runtime.getRuntime();
        logger.logInfo("Max direct memory={}, max runtime memory={}, total runtime memory={}, free runtime memory={}", PlatformDependent.maxDirectMemory(), runtime.maxMemory(), runtime.totalMemory(), runtime.freeMemory());
        MemoryUsage nonHeapMem = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        logger.logInfo("Non-heap memory usage max={}, used={}, committed={}", nonHeapMem.getMax(), nonHeapMem.getUsed(), nonHeapMem.getCommitted());
        MemoryUsage heapMem = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        logger.logInfo("Heap memory usage max={}, used={}, committed={}", heapMem.getMax(), heapMem.getUsed(), heapMem.getCommitted());
    }

    public static String getStackTrace(Throwable e) {
        if (e == null) {
            return null;
        }
        StringBuilder stackTrace = new StringBuilder();
        for (StackTraceElement element : e.getStackTrace()) {
            stackTrace.append(System.lineSeparator()).append(element.toString());
        }
        return stackTrace.toString();
    }
}

