/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.SFException;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.values.factory.DefaultV1ValuesWriterFactory;
import org.apache.parquet.column.values.factory.ValuesWriterFactory;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.InternalParquetRecordWriter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.DelegatingPositionOutputStream;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.ParquetEncodingException;
import org.apache.parquet.io.PositionOutputStream;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;

public class BdecParquetWriter
implements AutoCloseable {
    private final InternalParquetRecordWriter<List<Object>> writer;
    private final CodecFactory codecFactory;

    public BdecParquetWriter(ByteArrayOutputStream stream, MessageType schema, Map<String, String> extraMetaData, String channelName) throws IOException {
        ByteArrayOutputFile file = new ByteArrayOutputFile(stream);
        ParquetProperties encodingProps = BdecParquetWriter.createParquetProperties();
        Configuration conf = new Configuration();
        BdecWriteSupport writeSupport = new BdecWriteSupport(schema, extraMetaData, channelName);
        WriteSupport.WriteContext writeContext = writeSupport.init(conf);
        ParquetFileWriter fileWriter = new ParquetFileWriter((OutputFile)file, schema, ParquetFileWriter.Mode.CREATE, 512000000L, 0x800000, encodingProps.getColumnIndexTruncateLength(), encodingProps.getStatisticsTruncateLength(), encodingProps.getPageWriteChecksumEnabled(), (FileEncryptionProperties)null);
        fileWriter.start();
        this.codecFactory = new CodecFactory(conf, 0x100000);
        CodecFactory.BytesCompressor compressor = this.codecFactory.getCompressor(CompressionCodecName.GZIP);
        this.writer = new InternalParquetRecordWriter(fileWriter, (WriteSupport)writeSupport, schema, writeContext.getExtraMetaData(), 512000000L, compressor, true, encodingProps);
    }

    public void writeRow(List<Object> row) {
        try {
            this.writer.write(row);
        }
        catch (IOException | InterruptedException e) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "parquet row write failed", e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.writer.close();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            this.codecFactory.release();
        }
    }

    private static ParquetProperties createParquetProperties() {
        return ParquetProperties.builder().withWriterVersion(ParquetProperties.WriterVersion.PARQUET_1_0).withValuesWriterFactory((ValuesWriterFactory)new DefaultV1ValuesWriterFactory()).withDictionaryEncoding(false).withPageRowCountLimit(Integer.MAX_VALUE).withMinRowCountForPageSizeCheck(Integer.MAX_VALUE).build();
    }

    private static class BdecWriteSupport
    extends WriteSupport<List<Object>> {
        MessageType schema;
        RecordConsumer recordConsumer;
        Map<String, String> extraMetadata;
        private final String channelName;

        BdecWriteSupport(MessageType schema, Map<String, String> extraMetadata, String channelName) {
            this.schema = schema;
            this.extraMetadata = extraMetadata;
            this.channelName = channelName;
        }

        public WriteSupport.WriteContext init(Configuration config) {
            return new WriteSupport.WriteContext(this.schema, this.extraMetadata);
        }

        public void prepareForWrite(RecordConsumer recordConsumer) {
            this.recordConsumer = recordConsumer;
        }

        public void write(List<Object> values) {
            List cols = this.schema.getColumns();
            if (values.size() != cols.size()) {
                throw new ParquetEncodingException("Invalid input data in channel '" + this.channelName + "'. Expecting " + cols.size() + " columns. Input had " + values.size() + " columns (" + cols + ") : " + values);
            }
            this.recordConsumer.startMessage();
            for (int i = 0; i < cols.size(); ++i) {
                Object val = values.get(i);
                if (val == null) continue;
                String fieldName = ((ColumnDescriptor)cols.get(i)).getPath()[0];
                this.recordConsumer.startField(fieldName, i);
                PrimitiveType.PrimitiveTypeName typeName = ((ColumnDescriptor)cols.get(i)).getPrimitiveType().getPrimitiveTypeName();
                switch (typeName) {
                    case BOOLEAN: {
                        this.recordConsumer.addBoolean(((Boolean)val).booleanValue());
                        break;
                    }
                    case FLOAT: {
                        this.recordConsumer.addFloat(((Float)val).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        this.recordConsumer.addDouble(((Double)val).doubleValue());
                        break;
                    }
                    case INT32: {
                        this.recordConsumer.addInteger(((Integer)val).intValue());
                        break;
                    }
                    case INT64: {
                        this.recordConsumer.addLong(((Long)val).longValue());
                        break;
                    }
                    case BINARY: {
                        Binary binVal = val instanceof String ? Binary.fromString((String)((String)val)) : Binary.fromConstantByteArray((byte[])((byte[])val));
                        this.recordConsumer.addBinary(binVal);
                        break;
                    }
                    case FIXED_LEN_BYTE_ARRAY: {
                        Binary binary = Binary.fromConstantByteArray((byte[])((byte[])val));
                        this.recordConsumer.addBinary(binary);
                        break;
                    }
                    default: {
                        throw new ParquetEncodingException("Unsupported column type: " + ((ColumnDescriptor)cols.get(i)).getPrimitiveType());
                    }
                }
                this.recordConsumer.endField(fieldName, i);
            }
            this.recordConsumer.endMessage();
        }
    }

    private static class ByteArrayDelegatingPositionOutputStream
    extends DelegatingPositionOutputStream {
        private final ByteArrayOutputStream stream;

        public ByteArrayDelegatingPositionOutputStream(ByteArrayOutputStream stream) {
            super((OutputStream)stream);
            this.stream = stream;
        }

        public long getPos() {
            return this.stream.size();
        }
    }

    private static class ByteArrayOutputFile
    implements OutputFile {
        private final ByteArrayOutputStream stream;

        private ByteArrayOutputFile(ByteArrayOutputStream stream) {
            this.stream = stream;
        }

        public PositionOutputStream create(long blockSizeHint) throws IOException {
            this.stream.reset();
            return new ByteArrayDelegatingPositionOutputStream(this.stream);
        }

        public PositionOutputStream createOrOverwrite(long blockSizeHint) throws IOException {
            return this.create(blockSizeHint);
        }

        public boolean supportsBlockSize() {
            return false;
        }

        public long defaultBlockSize() {
            return 16000000L;
        }
    }
}

