/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.commons.configuration2.builder;

import net.snowflake.ingest.internal.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import net.snowflake.ingest.internal.apache.commons.configuration2.builder.ConfigurationBuilderResultCreatedEvent;
import net.snowflake.ingest.internal.apache.commons.configuration2.event.Event;
import net.snowflake.ingest.internal.apache.commons.configuration2.event.EventListener;
import net.snowflake.ingest.internal.apache.commons.configuration2.reloading.ReloadingController;
import net.snowflake.ingest.internal.apache.commons.configuration2.reloading.ReloadingEvent;

final class ReloadingBuilderSupportListener
implements EventListener<Event> {
    private final BasicConfigurationBuilder<?> builder;
    private final ReloadingController reloadingController;

    private ReloadingBuilderSupportListener(BasicConfigurationBuilder<?> configBuilder, ReloadingController controller) {
        this.builder = configBuilder;
        this.reloadingController = controller;
    }

    public static ReloadingBuilderSupportListener connect(BasicConfigurationBuilder<?> configBuilder, ReloadingController controller) {
        ReloadingBuilderSupportListener listener = new ReloadingBuilderSupportListener(configBuilder, controller);
        controller.addEventListener(ReloadingEvent.ANY, listener);
        configBuilder.installEventListener(ConfigurationBuilderResultCreatedEvent.RESULT_CREATED, listener);
        return listener;
    }

    @Override
    public void onEvent(Event event) {
        if (ConfigurationBuilderResultCreatedEvent.RESULT_CREATED.equals(event.getEventType())) {
            this.reloadingController.resetReloadingState();
        } else {
            this.builder.resetResult();
        }
    }
}

