/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.snowflake.ingest.internal.apache.commons.compress.utils.IOUtils;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.fs.BBPartHandle;
import net.snowflake.ingest.internal.apache.hadoop.fs.BBUploadHandle;
import net.snowflake.ingest.internal.apache.hadoop.fs.FSDataOutputStreamBuilder;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileStatus;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileSystem;
import net.snowflake.ingest.internal.apache.hadoop.fs.InternalOperations;
import net.snowflake.ingest.internal.apache.hadoop.fs.Options;
import net.snowflake.ingest.internal.apache.hadoop.fs.PartHandle;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.hadoop.fs.PathHandle;
import net.snowflake.ingest.internal.apache.hadoop.fs.UploadHandle;
import net.snowflake.ingest.internal.apache.hadoop.fs.impl.AbstractMultipartUploader;
import net.snowflake.ingest.internal.apache.hadoop.fs.impl.FileSystemMultipartUploaderBuilder;
import net.snowflake.ingest.internal.apache.hadoop.fs.permission.FsPermission;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.com.google.common.base.Charsets;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import net.snowflake.ingest.internal.apache.hadoop.util.functional.FutureIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FileSystemMultipartUploader
extends AbstractMultipartUploader {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemMultipartUploader.class);
    private final FileSystem fs;
    private final FileSystemMultipartUploaderBuilder builder;
    private final FsPermission permission;
    private final long blockSize;
    private final Options.ChecksumOpt checksumOpt;

    public FileSystemMultipartUploader(FileSystemMultipartUploaderBuilder builder, FileSystem fs) {
        super(builder.getPath());
        this.builder = builder;
        this.fs = fs;
        this.blockSize = builder.getBlockSize();
        this.checksumOpt = builder.getChecksumOpt();
        this.permission = builder.getPermission();
    }

    @Override
    public CompletableFuture<UploadHandle> startUpload(Path filePath) throws IOException {
        this.checkPath(filePath);
        return FutureIO.eval(() -> {
            Path collectorPath = this.createCollectorPath(filePath);
            this.fs.mkdirs(collectorPath, FsPermission.getDirDefault());
            ByteBuffer byteBuffer = ByteBuffer.wrap(collectorPath.toString().getBytes(Charsets.UTF_8));
            return BBUploadHandle.from(byteBuffer);
        });
    }

    @Override
    public CompletableFuture<PartHandle> putPart(UploadHandle uploadId, int partNumber, Path filePath, InputStream inputStream, long lengthInBytes) throws IOException {
        this.checkPutArguments(filePath, inputStream, partNumber, uploadId, lengthInBytes);
        return FutureIO.eval(() -> this.innerPutPart(filePath, inputStream, partNumber, uploadId, lengthInBytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PartHandle innerPutPart(Path filePath, InputStream inputStream, int partNumber, UploadHandle uploadId, long lengthInBytes) throws IOException {
        byte[] uploadIdByteArray = uploadId.toByteArray();
        this.checkUploadId(uploadIdByteArray);
        Path collectorPath = new Path(new String(uploadIdByteArray, 0, uploadIdByteArray.length, Charsets.UTF_8));
        Path partPath = Path.mergePaths(collectorPath, Path.mergePaths(new Path("/"), new Path(partNumber + ".part")));
        FSDataOutputStreamBuilder fileBuilder = this.fs.createFile(partPath);
        if (this.checksumOpt != null) {
            fileBuilder.checksumOpt(this.checksumOpt);
        }
        if (this.permission != null) {
            fileBuilder.permission(this.permission);
        }
        try (Object fsDataOutputStream = ((FSDataOutputStreamBuilder)fileBuilder.blockSize(this.blockSize)).build();){
            IOUtils.copy(inputStream, (OutputStream)fsDataOutputStream, this.builder.getBufferSize());
        }
        catch (Throwable throwable) {
            net.snowflake.ingest.internal.apache.hadoop.io.IOUtils.cleanupWithLogger(LOG, inputStream);
            throw throwable;
        }
        net.snowflake.ingest.internal.apache.hadoop.io.IOUtils.cleanupWithLogger(LOG, inputStream);
        return BBPartHandle.from(ByteBuffer.wrap(partPath.toString().getBytes(Charsets.UTF_8)));
    }

    private Path createCollectorPath(Path filePath) {
        String uuid = UUID.randomUUID().toString();
        return Path.mergePaths(filePath.getParent(), Path.mergePaths(new Path(filePath.getName().split("\\.")[0]), Path.mergePaths(new Path("_multipart_" + uuid), new Path("/"))));
    }

    private PathHandle getPathHandle(Path filePath) throws IOException {
        FileStatus status = this.fs.getFileStatus(filePath);
        return this.fs.getPathHandle(status, new Options.HandleOpt[0]);
    }

    private long totalPartsLen(List<Path> partHandles) throws IOException {
        long totalLen = 0L;
        for (Path p : partHandles) {
            totalLen += this.fs.getFileStatus(p).getLen();
        }
        return totalLen;
    }

    @Override
    public CompletableFuture<PathHandle> complete(UploadHandle uploadId, Path filePath, Map<Integer, PartHandle> handleMap) throws IOException {
        this.checkPath(filePath);
        return FutureIO.eval(() -> this.innerComplete(uploadId, filePath, handleMap));
    }

    private PathHandle innerComplete(UploadHandle multipartUploadId, Path filePath, Map<Integer, PartHandle> handleMap) throws IOException {
        boolean emptyFile;
        this.checkPath(filePath);
        this.checkUploadId(multipartUploadId.toByteArray());
        this.checkPartHandles(handleMap);
        ArrayList<Map.Entry<Integer, PartHandle>> handles = new ArrayList<Map.Entry<Integer, PartHandle>>(handleMap.entrySet());
        handles.sort(Comparator.comparingInt(Map.Entry::getKey));
        List<Path> partHandles = handles.stream().map(pair -> {
            byte[] byteArray = ((PartHandle)pair.getValue()).toByteArray();
            return new Path(new String(byteArray, 0, byteArray.length, Charsets.UTF_8));
        }).collect(Collectors.toList());
        int count = partHandles.size();
        HashSet<Path> values = new HashSet<Path>(count);
        values.addAll(partHandles);
        Preconditions.checkArgument(values.size() == count, "Duplicate PartHandles");
        byte[] uploadIdByteArray = multipartUploadId.toByteArray();
        Path collectorPath = new Path(new String(uploadIdByteArray, 0, uploadIdByteArray.length, Charsets.UTF_8));
        boolean bl = emptyFile = this.totalPartsLen(partHandles) == 0L;
        if (emptyFile) {
            this.fs.create(filePath).close();
        } else {
            Path filePathInsideCollector = Path.mergePaths(collectorPath, new Path("/" + filePath.getName()));
            this.fs.create(filePathInsideCollector).close();
            this.fs.concat(filePathInsideCollector, partHandles.toArray(new Path[handles.size()]));
            new InternalOperations().rename(this.fs, filePathInsideCollector, filePath, Options.Rename.OVERWRITE);
        }
        this.fs.delete(collectorPath, true);
        return this.getPathHandle(filePath);
    }

    @Override
    public CompletableFuture<Void> abort(UploadHandle uploadId, Path filePath) throws IOException {
        this.checkPath(filePath);
        byte[] uploadIdByteArray = uploadId.toByteArray();
        this.checkUploadId(uploadIdByteArray);
        Path collectorPath = new Path(new String(uploadIdByteArray, 0, uploadIdByteArray.length, Charsets.UTF_8));
        return FutureIO.eval(() -> {
            this.fs.getFileStatus(collectorPath);
            this.fs.delete(collectorPath, true);
            return null;
        });
    }
}

