/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.LinkedList;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.fs.FsShellPermissions;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.AclCommands;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.Command;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.CommandFactory;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.Concat;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.CopyCommands;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.Count;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.Delete;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.Display;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.FsUsage;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.Head;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.Ls;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.Mkdir;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.MoveCommands;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.PathData;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.SetReplication;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.SnapshotCommands;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.Stat;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.Tail;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.Test;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.TouchCommands;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.Truncate;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.XAttrCommands;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.find.Find;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class FsCommand
extends Command {
    public static void registerCommands(CommandFactory factory) {
        factory.registerCommands(AclCommands.class);
        factory.registerCommands(CopyCommands.class);
        factory.registerCommands(Count.class);
        factory.registerCommands(Delete.class);
        factory.registerCommands(Display.class);
        factory.registerCommands(Find.class);
        factory.registerCommands(FsShellPermissions.class);
        factory.registerCommands(FsUsage.class);
        factory.registerCommands(Ls.class);
        factory.registerCommands(Mkdir.class);
        factory.registerCommands(MoveCommands.class);
        factory.registerCommands(SetReplication.class);
        factory.registerCommands(Stat.class);
        factory.registerCommands(Tail.class);
        factory.registerCommands(Head.class);
        factory.registerCommands(Test.class);
        factory.registerCommands(TouchCommands.class);
        factory.registerCommands(Truncate.class);
        factory.registerCommands(SnapshotCommands.class);
        factory.registerCommands(XAttrCommands.class);
        factory.registerCommands(Concat.class);
    }

    protected FsCommand() {
    }

    protected FsCommand(Configuration conf) {
        super(conf);
    }

    @Override
    public String getCommandName() {
        return this.getName();
    }

    @Override
    protected void run(Path path) throws IOException {
        throw new RuntimeException("not supposed to get here");
    }

    @Override
    @Deprecated
    public int runAll() {
        return this.run(this.args);
    }

    @Override
    protected void processRawArguments(LinkedList<String> args) throws IOException {
        LinkedList<PathData> expendedArgs = this.expandArguments(args);
        boolean displayWarnings = this.getConf().getBoolean("hadoop.shell.missing.defaultFs.warning", false);
        if (displayWarnings) {
            boolean missingDefaultFs;
            String defaultFs = this.getConf().get("fs.defaultFS");
            boolean bl = missingDefaultFs = defaultFs == null || defaultFs.equals("file:///");
            if (missingDefaultFs) {
                this.err.printf("Warning: fs.defaultFS is not set when running \"%s\" command.%n", this.getCommandName());
            }
        }
        this.processArguments(expendedArgs);
    }
}

