/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configurable;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.BlockCompressorStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.BlockDecompressorStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionCodec;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionInputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionOutputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Compressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Decompressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.lz4.Lz4Compressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.lz4.Lz4Decompressor;

public class Lz4Codec
implements Configurable,
CompressionCodec {
    Configuration conf;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return CompressionCodec.Util.createOutputStreamWithCodecPool(this, this.conf, out);
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        int bufferSize = this.conf.getInt("io.compression.codec.lz4.buffersize", 262144);
        int compressionOverhead = bufferSize / 255 + 16;
        return new BlockCompressorStream(out, compressor, bufferSize, compressionOverhead);
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        return Lz4Compressor.class;
    }

    @Override
    public Compressor createCompressor() {
        int bufferSize = this.conf.getInt("io.compression.codec.lz4.buffersize", 262144);
        boolean useLz4HC = this.conf.getBoolean("io.compression.codec.lz4.use.lz4hc", false);
        return new Lz4Compressor(bufferSize, useLz4HC);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return CompressionCodec.Util.createInputStreamWithCodecPool(this, this.conf, in);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        return new BlockDecompressorStream(in, decompressor, this.conf.getInt("io.compression.codec.lz4.buffersize", 262144));
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return Lz4Decompressor.class;
    }

    @Override
    public Decompressor createDecompressor() {
        int bufferSize = this.conf.getInt("io.compression.codec.lz4.buffersize", 262144);
        return new Lz4Decompressor(bufferSize);
    }

    @Override
    public String getDefaultExtension() {
        return ".lz4";
    }
}

