/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io.retry;

import net.snowflake.ingest.internal.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

class CallReturn {
    static final CallReturn ASYNC_CALL_IN_PROGRESS = new CallReturn(State.ASYNC_CALL_IN_PROGRESS);
    static final CallReturn ASYNC_INVOKED = new CallReturn(State.ASYNC_INVOKED);
    static final CallReturn RETRY = new CallReturn(State.RETRY);
    static final CallReturn WAIT_RETRY = new CallReturn(State.WAIT_RETRY);
    private final Object returnValue;
    private final Throwable thrown;
    private final State state;

    CallReturn(Object r) {
        this(r, null, State.RETURNED);
    }

    CallReturn(Throwable t2) {
        this(null, t2, State.EXCEPTION);
        Preconditions.checkNotNull(t2);
    }

    private CallReturn(State s2) {
        this(null, null, s2);
    }

    private CallReturn(Object r, Throwable t2, State s2) {
        Preconditions.checkArgument(r == null || t2 == null);
        this.returnValue = r;
        this.thrown = t2;
        this.state = s2;
    }

    State getState() {
        return this.state;
    }

    Object getReturnValue() throws Throwable {
        if (this.state == State.EXCEPTION) {
            throw this.thrown;
        }
        Preconditions.checkState(this.state == State.RETURNED, "state == %s", (Object)this.state);
        return this.returnValue;
    }

    static enum State {
        RETURNED,
        EXCEPTION,
        RETRY,
        WAIT_RETRY,
        ASYNC_CALL_IN_PROGRESS,
        ASYNC_INVOKED;

    }
}

