/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.ipc;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.ipc.ProtobufHelper;
import net.snowflake.ingest.internal.apache.hadoop.ipc.ProtobufRpcEngine2;
import net.snowflake.ingest.internal.apache.hadoop.ipc.ProtocolMetaInfoPB;
import net.snowflake.ingest.internal.apache.hadoop.ipc.ProtocolSignature;
import net.snowflake.ingest.internal.apache.hadoop.ipc.RPC;
import net.snowflake.ingest.internal.apache.hadoop.ipc.RpcInvocationHandler;
import net.snowflake.ingest.internal.apache.hadoop.ipc.protobuf.ProtocolInfoProtos;
import net.snowflake.ingest.internal.apache.hadoop.net.NetUtils;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.protobuf.RpcController;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.protobuf.ServiceException;

public class RpcClientUtil {
    private static RpcController NULL_CONTROLLER = null;
    private static final int PRIME = 16777619;
    private static ConcurrentHashMap<ProtoSigCacheKey, Map<Long, ProtocolSignature>> signatureMap = new ConcurrentHashMap();

    private static void putVersionSignatureMap(InetSocketAddress addr, String protocol, String rpcKind, Map<Long, ProtocolSignature> map) {
        signatureMap.put(new ProtoSigCacheKey(addr, protocol, rpcKind), map);
    }

    private static Map<Long, ProtocolSignature> getVersionSignatureMap(InetSocketAddress addr, String protocol, String rpcKind) {
        return signatureMap.get(new ProtoSigCacheKey(addr, protocol, rpcKind));
    }

    public static boolean isMethodSupported(Object rpcProxy, Class<?> protocol, RPC.RpcKind rpcKind, long version, String methodName) throws IOException {
        InetSocketAddress serverAddress = RPC.getServerAddress(rpcProxy);
        Map<Long, ProtocolSignature> versionMap = RpcClientUtil.getVersionSignatureMap(serverAddress, protocol.getName(), rpcKind.toString());
        if (versionMap == null) {
            ProtocolInfoProtos.GetProtocolSignatureResponseProto resp;
            Configuration conf = new Configuration();
            RPC.setProtocolEngine(conf, ProtocolMetaInfoPB.class, ProtobufRpcEngine2.class);
            ProtocolMetaInfoPB protocolInfoProxy = RpcClientUtil.getProtocolMetaInfoProxy(rpcProxy, conf);
            ProtocolInfoProtos.GetProtocolSignatureRequestProto.Builder builder = ProtocolInfoProtos.GetProtocolSignatureRequestProto.newBuilder();
            builder.setProtocol(protocol.getName());
            builder.setRpcKind(rpcKind.toString());
            try {
                resp = protocolInfoProxy.getProtocolSignature(NULL_CONTROLLER, builder.build());
            }
            catch (ServiceException se) {
                throw ProtobufHelper.getRemoteException(se);
            }
            versionMap = RpcClientUtil.convertProtocolSignatureProtos(resp.getProtocolSignatureList());
            RpcClientUtil.putVersionSignatureMap(serverAddress, protocol.getName(), rpcKind.toString(), versionMap);
        }
        Method[] allMethods = protocol.getMethods();
        Method desiredMethod = null;
        for (Method m4 : allMethods) {
            if (!m4.getName().equals(methodName)) continue;
            desiredMethod = m4;
            break;
        }
        if (desiredMethod == null) {
            return false;
        }
        int methodHash = ProtocolSignature.getFingerprint(desiredMethod);
        return RpcClientUtil.methodExists(methodHash, version, versionMap);
    }

    private static Map<Long, ProtocolSignature> convertProtocolSignatureProtos(List<ProtocolInfoProtos.ProtocolSignatureProto> protoList) {
        TreeMap<Long, ProtocolSignature> map = new TreeMap<Long, ProtocolSignature>();
        for (ProtocolInfoProtos.ProtocolSignatureProto p : protoList) {
            int[] methods = new int[p.getMethodsList().size()];
            int index = 0;
            for (int m4 : p.getMethodsList()) {
                methods[index++] = m4;
            }
            map.put(p.getVersion(), new ProtocolSignature(p.getVersion(), methods));
        }
        return map;
    }

    private static boolean methodExists(int methodHash, long version, Map<Long, ProtocolSignature> versionMap) {
        ProtocolSignature sig = versionMap.get(version);
        if (sig != null) {
            for (int m4 : sig.getMethods()) {
                if (m4 != methodHash) continue;
                return true;
            }
        }
        return false;
    }

    private static ProtocolMetaInfoPB getProtocolMetaInfoProxy(Object proxy, Configuration conf) throws IOException {
        RpcInvocationHandler inv = (RpcInvocationHandler)Proxy.getInvocationHandler(proxy);
        return RPC.getProtocolEngine(ProtocolMetaInfoPB.class, conf).getProtocolMetaInfoProxy(inv.getConnectionId(), conf, NetUtils.getDefaultSocketFactory(conf)).getProxy();
    }

    public static String methodToTraceString(Method method) {
        Class<?> next;
        Class<?> clazz = method.getDeclaringClass();
        while ((next = clazz.getEnclosingClass()) != null && next.getEnclosingClass() != null) {
            clazz = next;
        }
        return clazz.getSimpleName() + "#" + method.getName();
    }

    public static String toTraceName(String fullName) {
        int lastPeriod = fullName.lastIndexOf(46);
        if (lastPeriod < 0) {
            return fullName;
        }
        int secondLastPeriod = fullName.lastIndexOf(46, lastPeriod - 1);
        if (secondLastPeriod < 0) {
            return fullName;
        }
        return fullName.substring(secondLastPeriod + 1, lastPeriod) + "#" + fullName.substring(lastPeriod + 1);
    }

    private static class ProtoSigCacheKey {
        private InetSocketAddress serverAddress;
        private String protocol;
        private String rpcKind;

        ProtoSigCacheKey(InetSocketAddress addr, String p, String rk) {
            this.serverAddress = addr;
            this.protocol = p;
            this.rpcKind = rk;
        }

        public int hashCode() {
            int result = 1;
            result = 16777619 * result + (this.serverAddress == null ? 0 : this.serverAddress.hashCode());
            result = 16777619 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
            result = 16777619 * result + (this.rpcKind == null ? 0 : this.rpcKind.hashCode());
            return result;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof ProtoSigCacheKey) {
                ProtoSigCacheKey otherKey = (ProtoSigCacheKey)other;
                return this.serverAddress.equals(otherKey.serverAddress) && this.protocol.equals(otherKey.protocol) && this.rpcKind.equals(otherKey.rpcKind);
            }
            return false;
        }
    }
}

