/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.metrics2.sink;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.snowflake.ingest.internal.apache.commons.configuration2.SubsetConfiguration;
import net.snowflake.ingest.internal.apache.commons.lang3.StringUtils;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.AbstractMetric;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.MetricType;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.MetricsRecord;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.MetricsSink;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.MetricsTag;

public class PrometheusMetricsSink
implements MetricsSink {
    private Map<String, Map<Collection<MetricsTag>, AbstractMetric>> promMetrics = new ConcurrentHashMap<String, Map<Collection<MetricsTag>, AbstractMetric>>();
    private Map<String, Map<Collection<MetricsTag>, AbstractMetric>> nextPromMetrics = new ConcurrentHashMap<String, Map<Collection<MetricsTag>, AbstractMetric>>();
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!(^|[A-Z_]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
    private static final Pattern DELIMITERS = Pattern.compile("[^a-zA-Z0-9]+");
    private static final Pattern NN_TOPMETRICS_PATTERN = Pattern.compile("^(nn_top_user_op_counts_window_ms_\\d+)_op_.*?(total_count|count)$");
    private static final Pattern NN_TOPMETRICS_TAGS_PATTERN = Pattern.compile("^op=(?<op>\\w+)(.user=(?<user>.*)|)\\.(TotalCount|count)$");

    @Override
    public void putMetrics(MetricsRecord metricsRecord) {
        for (AbstractMetric metric : metricsRecord.metrics()) {
            if (metric.type() != MetricType.COUNTER && metric.type() != MetricType.GAUGE) continue;
            String key = this.prometheusName(metricsRecord.name(), metric.name());
            this.nextPromMetrics.computeIfAbsent(key, any -> new ConcurrentHashMap()).put(metricsRecord.tags(), metric);
        }
    }

    public String prometheusName(String recordName, String metricName) {
        String baseName = StringUtils.capitalize((String)recordName) + StringUtils.capitalize((String)metricName);
        CharSequence[] parts = SPLIT_PATTERN.split(baseName);
        String joined = String.join((CharSequence)"_", parts).toLowerCase();
        return DELIMITERS.matcher(joined).replaceAll("_");
    }

    @Override
    public void flush() {
        this.promMetrics = this.nextPromMetrics;
        this.nextPromMetrics = new ConcurrentHashMap<String, Map<Collection<MetricsTag>, AbstractMetric>>();
    }

    @Override
    public void init(SubsetConfiguration conf) {
    }

    public void writeMetrics(Writer writer) throws IOException {
        ArrayList<String> extendMetricsTags = new ArrayList<String>();
        for (Map.Entry<String, Map<Collection<MetricsTag>, AbstractMetric>> promMetric : this.promMetrics.entrySet()) {
            AbstractMetric firstMetric = promMetric.getValue().values().iterator().next();
            String metricKey = this.getMetricKey(promMetric.getKey(), firstMetric, extendMetricsTags);
            StringBuilder builder = new StringBuilder();
            builder.append("# HELP ").append(metricKey).append(" ").append(firstMetric.description()).append("\n").append("# TYPE ").append(metricKey).append(" ").append(firstMetric.type().toString().toLowerCase()).append("\n");
            for (Map.Entry<Collection<MetricsTag>, AbstractMetric> metric : promMetric.getValue().entrySet()) {
                builder.append(metricKey).append("{");
                String sep = "";
                for (MetricsTag tag : metric.getKey()) {
                    String tagName = tag.name().toLowerCase();
                    if (tagName.equals("numopenconnectionsperuser")) continue;
                    builder.append(sep).append(tagName).append("=\"").append(tag.value()).append("\"");
                    sep = ",";
                }
                if (!extendMetricsTags.isEmpty()) {
                    for (String tagStr : extendMetricsTags) {
                        builder.append(sep).append(tagStr);
                    }
                    extendMetricsTags.clear();
                }
                builder.append("} ");
                builder.append(metric.getValue().value());
                builder.append("\n");
            }
            writer.write(builder.toString());
        }
    }

    private String getMetricKey(String promMetricKey, AbstractMetric metric, List<String> extendTags) {
        Matcher matcher = NN_TOPMETRICS_PATTERN.matcher(promMetricKey);
        if (matcher.find() && matcher.groupCount() == 2) {
            extendTags.addAll(this.parseTopMetricsTags(metric.name()));
            return String.format("%s_%s", matcher.group(1), matcher.group(2));
        }
        return promMetricKey;
    }

    private List<String> parseTopMetricsTags(String metricName) {
        ArrayList<String> topMetricsTags = new ArrayList<String>();
        Matcher matcher = NN_TOPMETRICS_TAGS_PATTERN.matcher(metricName);
        if (matcher.find()) {
            String op = matcher.group("op");
            String user = matcher.group("user");
            topMetricsTags.add(String.format("op=\"%s\"", op));
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{user})) {
                topMetricsTags.add(String.format("user=\"%s\"", user));
            }
        }
        return topMetricsTags;
    }
}

