/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.security;

import java.io.IOException;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class KerberosAuthException
extends IOException {
    static final long serialVersionUID = 31L;
    private String user;
    private String principal;
    private String keytabFile;
    private String ticketCacheFile;
    private String initialMessage;

    public KerberosAuthException(String msg) {
        super(msg);
    }

    public KerberosAuthException(Throwable cause) {
        super(cause);
    }

    public KerberosAuthException(String initialMsg, Throwable cause) {
        this(cause);
        this.initialMessage = initialMsg;
    }

    public void setUser(String u) {
        this.user = u;
    }

    public void setPrincipal(String p) {
        this.principal = p;
    }

    public void setKeytabFile(String k) {
        this.keytabFile = k;
    }

    public void setTicketCacheFile(String t2) {
        this.ticketCacheFile = t2;
    }

    public String getInitialMessage() {
        return this.initialMessage;
    }

    public String getKeytabFile() {
        return this.keytabFile;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getTicketCacheFile() {
        return this.ticketCacheFile;
    }

    public String getUser() {
        return this.user;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.initialMessage != null) {
            sb.append(this.initialMessage);
        }
        if (this.user != null) {
            sb.append(" for user: " + this.user);
        }
        if (this.principal != null) {
            sb.append(" for principal: " + this.principal);
        }
        if (this.keytabFile != null) {
            sb.append(" from keytab " + this.keytabFile);
        }
        if (this.ticketCacheFile != null) {
            sb.append(" using ticket cache file: " + this.ticketCacheFile);
        }
        sb.append(" " + super.getMessage());
        return sb.toString();
    }
}

