/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.security;

import java.security.Provider;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SaslPlainServer
implements SaslServer {
    private CallbackHandler cbh;
    private boolean completed;
    private String authz;

    SaslPlainServer(CallbackHandler callback) {
        this.cbh = callback;
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("PLAIN authentication has completed");
        }
        if (response == null) {
            throw new IllegalArgumentException("Received null response");
        }
        try {
            String payload;
            try {
                payload = new String(response, "UTF-8");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Received corrupt response", e);
            }
            String[] parts = payload.split("\u0000", 3);
            if (parts.length != 3) {
                throw new IllegalArgumentException("Received corrupt response");
            }
            if (parts[0].isEmpty()) {
                parts[0] = parts[1];
            }
            NameCallback nc = new NameCallback("SASL PLAIN");
            nc.setName(parts[1]);
            PasswordCallback pc = new PasswordCallback("SASL PLAIN", false);
            pc.setPassword(parts[2].toCharArray());
            AuthorizeCallback ac = new AuthorizeCallback(parts[1], parts[0]);
            this.cbh.handle(new Callback[]{nc, pc, ac});
            if (ac.isAuthorized()) {
                this.authz = ac.getAuthorizedID();
            }
        }
        catch (Exception e) {
            throw new SaslException("PLAIN auth failed: " + e.toString(), e);
        }
        finally {
            this.completed = true;
        }
        return null;
    }

    private void throwIfNotComplete() {
        if (!this.completed) {
            throw new IllegalStateException("PLAIN authentication not completed");
        }
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public String getAuthorizationID() {
        this.throwIfNotComplete();
        return this.authz;
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        this.throwIfNotComplete();
        return "javax.security.sasl.qop".equals(propName) ? "auth" : null;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        this.throwIfNotComplete();
        throw new IllegalStateException("PLAIN supports neither integrity nor privacy");
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        this.throwIfNotComplete();
        throw new IllegalStateException("PLAIN supports neither integrity nor privacy");
    }

    @Override
    public void dispose() throws SaslException {
        this.cbh = null;
        this.authz = null;
    }

    public static class SaslPlainServerFactory
    implements SaslServerFactory {
        @Override
        public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            return "PLAIN".equals(mechanism) ? new SaslPlainServer(cbh) : null;
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            String[] stringArray;
            if (props == null || "false".equals(props.get("javax.security.sasl.policy.noplaintext"))) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "PLAIN";
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
    }

    public static class SecurityProvider
    extends Provider {
        public SecurityProvider() {
            super("SaslPlainServer", 1.0, "SASL PLAIN Authentication Server");
            this.put("SaslServerFactory.PLAIN", SaslPlainServerFactory.class.getName());
        }
    }
}

