/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.security.token.delegation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.security.token.Token;
import net.snowflake.ingest.internal.apache.hadoop.security.token.TokenIdentifier;
import net.snowflake.ingest.internal.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import net.snowflake.ingest.internal.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import net.snowflake.ingest.internal.apache.hadoop.security.token.delegation.DelegationKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SQLDelegationTokenSecretManager<TokenIdent extends AbstractDelegationTokenIdentifier>
extends AbstractDelegationTokenSecretManager<TokenIdent> {
    private static final Logger LOG = LoggerFactory.getLogger(SQLDelegationTokenSecretManager.class);
    public static final String SQL_DTSM_CONF_PREFIX = "sql-dt-secret-manager.";
    private static final String SQL_DTSM_TOKEN_SEQNUM_BATCH_SIZE = "sql-dt-secret-manager.token.seqnum.batch.size";
    public static final int DEFAULT_SEQ_NUM_BATCH_SIZE = 10;
    private final int seqNumBatchSize;
    private int currentSeqNum;
    private int currentMaxSeqNum;

    public SQLDelegationTokenSecretManager(Configuration conf) {
        super(conf.getLong("delegation-token.update-interval.sec", 86400L) * 1000L, conf.getLong("delegation-token.max-lifetime.sec", 604800L) * 1000L, conf.getLong("delegation-token.renew-interval.sec", 86400L) * 1000L, conf.getLong("delegation-token.removal-scan-interval.sec", 3600L) * 1000L);
        this.seqNumBatchSize = conf.getInt(SQL_DTSM_TOKEN_SEQNUM_BATCH_SIZE, 10);
    }

    @Override
    protected void storeToken(TokenIdent ident, AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(bos);){
            tokenInfo.write(dos);
            this.insertToken(((AbstractDelegationTokenIdentifier)ident).getSequenceNumber(), ((TokenIdentifier)ident).getBytes(), bos.toByteArray());
            super.storeToken(ident, tokenInfo);
        }
        catch (SQLException e) {
            throw new IOException("Failed to store token in SQL secret manager", e);
        }
    }

    @Override
    protected void updateToken(TokenIdent ident, AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(bos);){
            tokenInfo.write(dos);
            this.updateToken(((AbstractDelegationTokenIdentifier)ident).getSequenceNumber(), ((TokenIdentifier)ident).getBytes(), bos.toByteArray());
            super.updateToken(ident, tokenInfo);
        }
        catch (SQLException e) {
            throw new IOException("Failed to update token in SQL secret manager", e);
        }
    }

    @Override
    public synchronized TokenIdent cancelToken(Token<TokenIdent> token, String canceller) throws IOException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(token.getIdentifier());
             DataInputStream din = new DataInputStream(bis);){
            AbstractDelegationTokenIdentifier id = (AbstractDelegationTokenIdentifier)this.createIdentifier();
            id.readFields(din);
            this.getTokenInfo(id);
        }
        return super.cancelToken(token, canceller);
    }

    @Override
    protected void removeStoredToken(TokenIdent ident) throws IOException {
        try {
            this.deleteToken(((AbstractDelegationTokenIdentifier)ident).getSequenceNumber(), ((TokenIdentifier)ident).getBytes());
        }
        catch (SQLException e) {
            LOG.warn("Failed to remove token in SQL secret manager", (Throwable)e);
        }
    }

    @Override
    protected AbstractDelegationTokenSecretManager.DelegationTokenInformation getTokenInfo(TokenIdent ident) {
        AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo;
        block27: {
            tokenInfo = super.getTokenInfo(ident);
            if (tokenInfo == null) {
                try {
                    byte[] tokenInfoBytes = this.selectTokenInfo(((AbstractDelegationTokenIdentifier)ident).getSequenceNumber(), ((TokenIdentifier)ident).getBytes());
                    if (tokenInfoBytes == null) break block27;
                    tokenInfo = new AbstractDelegationTokenSecretManager.DelegationTokenInformation();
                    try (ByteArrayInputStream bis = new ByteArrayInputStream(tokenInfoBytes);
                         DataInputStream dis = new DataInputStream(bis);){
                        tokenInfo.readFields(dis);
                    }
                    this.currentTokens.put(ident, tokenInfo);
                }
                catch (IOException | SQLException e) {
                    LOG.error("Failed to get token in SQL secret manager", (Throwable)e);
                }
            }
        }
        return tokenInfo;
    }

    @Override
    public int getDelegationTokenSeqNum() {
        try {
            return this.selectSequenceNum();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get token sequence number in SQL secret manager", e);
        }
    }

    @Override
    public void setDelegationTokenSeqNum(int seqNum) {
        try {
            this.updateSequenceNum(seqNum);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to update token sequence number in SQL secret manager", e);
        }
    }

    @Override
    public synchronized int incrementDelegationTokenSeqNum() {
        if (this.currentSeqNum >= this.currentMaxSeqNum) {
            try {
                this.currentSeqNum = this.incrementSequenceNum(this.seqNumBatchSize);
                this.currentMaxSeqNum = this.currentSeqNum + this.seqNumBatchSize;
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to increment token sequence number in SQL secret manager", e);
            }
        }
        return ++this.currentSeqNum;
    }

    @Override
    protected void storeDelegationKey(DelegationKey key) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(bos);){
            key.write(dos);
            this.insertDelegationKey(key.getKeyId(), bos.toByteArray());
            super.storeDelegationKey(key);
        }
        catch (SQLException e) {
            throw new IOException("Failed to store delegation key in SQL secret manager", e);
        }
    }

    @Override
    protected void updateDelegationKey(DelegationKey key) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(bos);){
            key.write(dos);
            this.updateDelegationKey(key.getKeyId(), bos.toByteArray());
            super.updateDelegationKey(key);
        }
        catch (SQLException e) {
            throw new IOException("Failed to update delegation key in SQL secret manager", e);
        }
    }

    @Override
    protected void removeStoredMasterKey(DelegationKey key) {
        try {
            this.deleteDelegationKey(key.getKeyId());
        }
        catch (SQLException e) {
            LOG.warn("Failed to remove delegation key in SQL secret manager", (Throwable)e);
        }
    }

    @Override
    protected DelegationKey getDelegationKey(int keyId) {
        DelegationKey delegationKey;
        block27: {
            delegationKey = super.getDelegationKey(keyId);
            if (delegationKey == null) {
                try {
                    byte[] delegationKeyBytes = this.selectDelegationKey(keyId);
                    if (delegationKeyBytes == null) break block27;
                    delegationKey = new DelegationKey();
                    try (ByteArrayInputStream bis = new ByteArrayInputStream(delegationKeyBytes);
                         DataInputStream dis = new DataInputStream(bis);){
                        delegationKey.readFields(dis);
                    }
                    this.allKeys.put(keyId, delegationKey);
                }
                catch (IOException | SQLException e) {
                    LOG.error("Failed to get delegation key in SQL secret manager", (Throwable)e);
                }
            }
        }
        return delegationKey;
    }

    @Override
    public int getCurrentKeyId() {
        try {
            return this.selectKeyId();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get delegation key id in SQL secret manager", e);
        }
    }

    @Override
    public void setCurrentKeyId(int keyId) {
        try {
            this.updateKeyId(keyId);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to set delegation key id in SQL secret manager", e);
        }
    }

    @Override
    public int incrementCurrentKeyId() {
        try {
            return this.incrementKeyId(1) + 1;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to increment delegation key id in SQL secret manager", e);
        }
    }

    protected abstract byte[] selectTokenInfo(int var1, byte[] var2) throws SQLException;

    protected abstract void insertToken(int var1, byte[] var2, byte[] var3) throws SQLException;

    protected abstract void updateToken(int var1, byte[] var2, byte[] var3) throws SQLException;

    protected abstract void deleteToken(int var1, byte[] var2) throws SQLException;

    protected abstract byte[] selectDelegationKey(int var1) throws SQLException;

    protected abstract void insertDelegationKey(int var1, byte[] var2) throws SQLException;

    protected abstract void updateDelegationKey(int var1, byte[] var2) throws SQLException;

    protected abstract void deleteDelegationKey(int var1) throws SQLException;

    protected abstract int selectSequenceNum() throws SQLException;

    protected abstract void updateSequenceNum(int var1) throws SQLException;

    protected abstract int incrementSequenceNum(int var1) throws SQLException;

    protected abstract int selectKeyId() throws SQLException;

    protected abstract void updateKeyId(int var1) throws SQLException;

    protected abstract int incrementKeyId(int var1) throws SQLException;
}

