/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileUtil;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ApplicationClassLoader
extends URLClassLoader {
    public static final String SYSTEM_CLASSES_DEFAULT;
    private static final String PROPERTIES_FILE = "net.snowflake.ingest.internal.apache.hadoop.application-classloader.properties";
    private static final String SYSTEM_CLASSES_DEFAULT_KEY = "system.classes.default";
    private static final Logger LOG;
    private final ClassLoader parent;
    private final List<String> systemClasses;

    public ApplicationClassLoader(URL[] urls, ClassLoader parent, List<String> systemClasses) {
        super(urls, parent);
        this.parent = parent;
        if (parent == null) {
            throw new IllegalArgumentException("No parent classloader!");
        }
        this.systemClasses = systemClasses == null || systemClasses.isEmpty() ? Arrays.asList(StringUtils.getTrimmedStrings(SYSTEM_CLASSES_DEFAULT)) : systemClasses;
        LOG.info("classpath: " + Arrays.toString(urls));
        LOG.info("system classes: " + this.systemClasses);
    }

    public ApplicationClassLoader(String classpath, ClassLoader parent, List<String> systemClasses) throws MalformedURLException {
        this(ApplicationClassLoader.constructUrlsFromClasspath(classpath), parent, systemClasses);
    }

    static URL[] constructUrlsFromClasspath(String classpath) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String element : classpath.split(File.pathSeparator)) {
            if (element.endsWith("/*")) {
                List<Path> jars = FileUtil.getJarsInDirectory(element);
                if (jars.isEmpty()) continue;
                for (Path jar : jars) {
                    urls.add(jar.toUri().toURL());
                }
                continue;
            }
            File file = new File(element);
            if (!file.exists()) continue;
            urls.add(new File(element).toURI().toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (!ApplicationClassLoader.isSystemClass(name, this.systemClasses) && (url = this.findResource(name)) == null && name.startsWith("/")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Remove leading / off " + name);
            }
            url = this.findResource(name.substring(1));
        }
        if (url == null) {
            url = this.parent.getResource(name);
        }
        if (url != null && LOG.isDebugEnabled()) {
            LOG.debug("getResource(" + name + ")=" + url);
        }
        return url;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading class: " + name);
        }
        Class<?> c = this.findLoadedClass(name);
        ClassNotFoundException ex = null;
        if (c == null && !ApplicationClassLoader.isSystemClass(name, this.systemClasses)) {
            try {
                c = this.findClass(name);
                if (LOG.isDebugEnabled() && c != null) {
                    LOG.debug("Loaded class: " + name + " ");
                }
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(e.toString());
                }
                ex = e;
            }
        }
        if (c == null) {
            c = this.parent.loadClass(name);
            if (LOG.isDebugEnabled() && c != null) {
                LOG.debug("Loaded class from parent: " + name + " ");
            }
        }
        if (c == null) {
            throw ex != null ? ex : new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public static boolean isSystemClass(String name, List<String> systemClasses) {
        boolean result = false;
        if (systemClasses != null) {
            String canonicalName = name.replace('/', '.');
            while (canonicalName.startsWith(".")) {
                canonicalName = canonicalName.substring(1);
            }
            for (String c : systemClasses) {
                boolean shouldInclude = true;
                if (c.startsWith("-")) {
                    c = c.substring(1);
                    shouldInclude = false;
                }
                if (!canonicalName.startsWith(c) || !c.endsWith(".") && canonicalName.length() != c.length() && (canonicalName.length() <= c.length() || canonicalName.charAt(c.length()) != '$')) continue;
                if (shouldInclude) {
                    result = true;
                    continue;
                }
                return false;
            }
        }
        return result;
    }

    static {
        LOG = LoggerFactory.getLogger((String)ApplicationClassLoader.class.getName());
        try (InputStream is = ApplicationClassLoader.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE);){
            if (is == null) {
                throw new ExceptionInInitializerError("properties file org.apache.hadoop.application-classloader.properties is not found");
            }
            Properties props = new Properties();
            props.load(is);
            String systemClassesDefault = props.getProperty(SYSTEM_CLASSES_DEFAULT_KEY);
            if (systemClassesDefault == null) {
                throw new ExceptionInInitializerError("property system.classes.default is not found");
            }
            SYSTEM_CLASSES_DEFAULT = systemClassesDefault;
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

