/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.hadoop;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.snowflake.ingest.internal.apache.parquet.column.values.bloomfilter.BloomFilter;
import net.snowflake.ingest.internal.apache.parquet.hadoop.ParquetFileReader;
import net.snowflake.ingest.internal.apache.parquet.hadoop.metadata.BlockMetaData;
import net.snowflake.ingest.internal.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import net.snowflake.ingest.internal.apache.parquet.hadoop.metadata.ColumnPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BloomFilterReader {
    private final ParquetFileReader reader;
    private final Map<ColumnPath, ColumnChunkMetaData> columns;
    private final Map<ColumnPath, BloomFilter> cache = new HashMap<ColumnPath, BloomFilter>();
    private Logger logger = LoggerFactory.getLogger(BloomFilterReader.class);

    public BloomFilterReader(ParquetFileReader fileReader, BlockMetaData block) {
        this.reader = fileReader;
        this.columns = new HashMap<ColumnPath, ColumnChunkMetaData>();
        for (ColumnChunkMetaData column : block.getColumns()) {
            this.columns.put(column.getPath(), column);
        }
    }

    public BloomFilter readBloomFilter(ColumnChunkMetaData meta) {
        if (this.cache.containsKey(meta.getPath())) {
            return this.cache.get(meta.getPath());
        }
        try {
            if (!this.cache.containsKey(meta.getPath())) {
                BloomFilter bloomFilter = this.reader.readBloomFilter(meta);
                if (bloomFilter == null) {
                    return null;
                }
                this.cache.put(meta.getPath(), bloomFilter);
            }
            return this.cache.get(meta.getPath());
        }
        catch (IOException e) {
            this.logger.error("Failed to read Bloom filter data", (Throwable)e);
            return null;
        }
    }
}

