/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.hadoop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CodecPool;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionCodec;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionInputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionOutputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Compressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Decompressor;
import net.snowflake.ingest.internal.apache.hadoop.util.ReflectionUtils;
import net.snowflake.ingest.internal.apache.parquet.bytes.ByteBufferAllocator;
import net.snowflake.ingest.internal.apache.parquet.bytes.BytesInput;
import net.snowflake.ingest.internal.apache.parquet.compression.CompressionCodecFactory;
import net.snowflake.ingest.internal.apache.parquet.hadoop.BadConfigurationException;
import net.snowflake.ingest.internal.apache.parquet.hadoop.DirectCodecFactory;
import net.snowflake.ingest.internal.apache.parquet.hadoop.codec.ZstandardCodec;
import net.snowflake.ingest.internal.apache.parquet.hadoop.metadata.CompressionCodecName;

public class CodecFactory
implements CompressionCodecFactory {
    protected static final Map<String, CompressionCodec> CODEC_BY_NAME = Collections.synchronizedMap(new HashMap());
    private final Map<CompressionCodecName, BytesCompressor> compressors = new HashMap<CompressionCodecName, BytesCompressor>();
    private final Map<CompressionCodecName, BytesDecompressor> decompressors = new HashMap<CompressionCodecName, BytesDecompressor>();
    protected final Configuration configuration;
    protected final int pageSize;

    public CodecFactory(Configuration configuration, int pageSize) {
        this.configuration = configuration;
        this.pageSize = pageSize;
    }

    public static CodecFactory createDirectCodecFactory(Configuration config, ByteBufferAllocator allocator, int pageSize) {
        return new DirectCodecFactory(config, allocator, pageSize);
    }

    @Override
    public BytesCompressor getCompressor(CompressionCodecName codecName) {
        BytesCompressor comp = this.compressors.get((Object)codecName);
        if (comp == null) {
            comp = this.createCompressor(codecName);
            this.compressors.put(codecName, comp);
        }
        return comp;
    }

    @Override
    public BytesDecompressor getDecompressor(CompressionCodecName codecName) {
        BytesDecompressor decomp = this.decompressors.get((Object)codecName);
        if (decomp == null) {
            decomp = this.createDecompressor(codecName);
            this.decompressors.put(codecName, decomp);
        }
        return decomp;
    }

    protected BytesCompressor createCompressor(CompressionCodecName codecName) {
        return new HeapBytesCompressor(codecName);
    }

    protected BytesDecompressor createDecompressor(CompressionCodecName codecName) {
        return new HeapBytesDecompressor(codecName);
    }

    protected CompressionCodec getCodec(CompressionCodecName codecName) {
        String codecClassName = codecName.getHadoopCompressionCodecClassName();
        if (codecClassName == null) {
            return null;
        }
        CompressionCodec codec = CODEC_BY_NAME.get(codecClassName);
        if (codec != null) {
            return codec;
        }
        try {
            Class<?> codecClass;
            try {
                codecClass = Class.forName(codecClassName);
            }
            catch (ClassNotFoundException e) {
                codecClass = this.configuration.getClassLoader().loadClass(codecClassName);
            }
            codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, this.configuration);
            CODEC_BY_NAME.put(codecClassName, codec);
            return codec;
        }
        catch (ClassNotFoundException e) {
            throw new BadConfigurationException("Class " + codecClassName + " was not found", e);
        }
    }

    @Override
    public void release() {
        for (BytesCompressor compressor : this.compressors.values()) {
            compressor.release();
        }
        this.compressors.clear();
        for (BytesDecompressor decompressor : this.decompressors.values()) {
            decompressor.release();
        }
        this.decompressors.clear();
    }

    @Deprecated
    public static abstract class BytesDecompressor
    implements CompressionCodecFactory.BytesInputDecompressor {
        @Override
        public abstract BytesInput decompress(BytesInput var1, int var2) throws IOException;

        @Override
        public abstract void decompress(ByteBuffer var1, int var2, ByteBuffer var3, int var4) throws IOException;

        @Override
        public abstract void release();
    }

    @Deprecated
    public static abstract class BytesCompressor
    implements CompressionCodecFactory.BytesInputCompressor {
        @Override
        public abstract BytesInput compress(BytesInput var1) throws IOException;

        @Override
        public abstract CompressionCodecName getCodecName();

        @Override
        public abstract void release();
    }

    class HeapBytesCompressor
    extends BytesCompressor {
        private final CompressionCodec codec;
        private final Compressor compressor;
        private final ByteArrayOutputStream compressedOutBuffer;
        private final CompressionCodecName codecName;

        HeapBytesCompressor(CompressionCodecName codecName) {
            this.codecName = codecName;
            this.codec = CodecFactory.this.getCodec(codecName);
            if (this.codec != null) {
                this.compressor = CodecPool.getCompressor(this.codec);
                this.compressedOutBuffer = new ByteArrayOutputStream(CodecFactory.this.pageSize);
            } else {
                this.compressor = null;
                this.compressedOutBuffer = null;
            }
        }

        @Override
        public BytesInput compress(BytesInput bytes) throws IOException {
            BytesInput compressedBytes;
            if (this.codec == null) {
                compressedBytes = bytes;
            } else {
                this.compressedOutBuffer.reset();
                if (this.compressor != null) {
                    this.compressor.reset();
                }
                CompressionOutputStream cos = this.codec.createOutputStream(this.compressedOutBuffer, this.compressor);
                bytes.writeAllTo(cos);
                cos.finish();
                cos.close();
                compressedBytes = BytesInput.from(this.compressedOutBuffer);
            }
            return compressedBytes;
        }

        @Override
        public void release() {
            if (this.compressor != null) {
                CodecPool.returnCompressor(this.compressor);
            }
        }

        @Override
        public CompressionCodecName getCodecName() {
            return this.codecName;
        }
    }

    class HeapBytesDecompressor
    extends BytesDecompressor {
        private final CompressionCodec codec;
        private final Decompressor decompressor;

        HeapBytesDecompressor(CompressionCodecName codecName) {
            this.codec = CodecFactory.this.getCodec(codecName);
            this.decompressor = this.codec != null ? CodecPool.getDecompressor(this.codec) : null;
        }

        @Override
        public BytesInput decompress(BytesInput bytes, int uncompressedSize) throws IOException {
            BytesInput decompressed;
            if (this.codec != null) {
                if (this.decompressor != null) {
                    this.decompressor.reset();
                }
                CompressionInputStream is = this.codec.createInputStream(bytes.toInputStream(), this.decompressor);
                if (this.codec instanceof ZstandardCodec) {
                    decompressed = BytesInput.copy(BytesInput.from(is, uncompressedSize));
                    ((InputStream)is).close();
                } else {
                    decompressed = BytesInput.from(is, uncompressedSize);
                }
            } else {
                decompressed = bytes;
            }
            return decompressed;
        }

        @Override
        public void decompress(ByteBuffer input, int compressedSize, ByteBuffer output, int uncompressedSize) throws IOException {
            ByteBuffer decompressed = this.decompress(BytesInput.from(input), uncompressedSize).toByteBuffer();
            output.put(decompressed);
        }

        @Override
        public void release() {
            if (this.decompressor != null) {
                CodecPool.returnDecompressor(this.decompressor);
            }
        }
    }
}

