/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.hadoop;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.hadoop.mapred.FileSplit;
import net.snowflake.ingest.internal.apache.hadoop.mapred.Reporter;
import net.snowflake.ingest.internal.apache.hadoop.mapreduce.InputSplit;
import net.snowflake.ingest.internal.apache.hadoop.mapreduce.JobContext;
import net.snowflake.ingest.internal.apache.hadoop.mapreduce.RecordReader;
import net.snowflake.ingest.internal.apache.hadoop.mapreduce.TaskAttemptContext;
import net.snowflake.ingest.internal.apache.parquet.CorruptDeltaByteArrays;
import net.snowflake.ingest.internal.apache.parquet.HadoopReadOptions;
import net.snowflake.ingest.internal.apache.parquet.ParquetReadOptions;
import net.snowflake.ingest.internal.apache.parquet.column.Encoding;
import net.snowflake.ingest.internal.apache.parquet.filter.UnboundRecordFilter;
import net.snowflake.ingest.internal.apache.parquet.filter2.compat.FilterCompat;
import net.snowflake.ingest.internal.apache.parquet.hadoop.InternalParquetRecordReader;
import net.snowflake.ingest.internal.apache.parquet.hadoop.ParquetFileReader;
import net.snowflake.ingest.internal.apache.parquet.hadoop.ParquetInputSplit;
import net.snowflake.ingest.internal.apache.parquet.hadoop.api.ReadSupport;
import net.snowflake.ingest.internal.apache.parquet.hadoop.metadata.BlockMetaData;
import net.snowflake.ingest.internal.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import net.snowflake.ingest.internal.apache.parquet.hadoop.metadata.FileMetaData;
import net.snowflake.ingest.internal.apache.parquet.hadoop.util.ContextUtil;
import net.snowflake.ingest.internal.apache.parquet.hadoop.util.HadoopInputFile;
import net.snowflake.ingest.internal.apache.parquet.hadoop.util.counters.BenchmarkCounter;
import net.snowflake.ingest.internal.apache.parquet.io.ParquetDecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetRecordReader<T>
extends RecordReader<Void, T> {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetRecordReader.class);
    private final InternalParquetRecordReader<T> internalReader;

    public ParquetRecordReader(ReadSupport<T> readSupport) {
        this(readSupport, FilterCompat.NOOP);
    }

    public ParquetRecordReader(ReadSupport<T> readSupport, FilterCompat.Filter filter) {
        this.internalReader = new InternalParquetRecordReader<T>(readSupport, filter);
    }

    @Deprecated
    public ParquetRecordReader(ReadSupport<T> readSupport, UnboundRecordFilter filter) {
        this(readSupport, FilterCompat.get(filter));
    }

    public void close() throws IOException {
        this.internalReader.close();
    }

    public Void getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public T getCurrentValue() throws IOException, InterruptedException {
        return this.internalReader.getCurrentValue();
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.internalReader.getProgress();
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        if (ContextUtil.hasCounterMethod(context)) {
            BenchmarkCounter.initCounterFromContext(context);
        } else {
            LOG.error(String.format("Can not initialize counter because the class '%s' does not have a '.getCounterMethod'", context.getClass().getCanonicalName()));
        }
        this.initializeInternalReader(this.toParquetSplit(inputSplit), ContextUtil.getConfiguration((JobContext)context));
    }

    public void initialize(InputSplit inputSplit, Configuration configuration, Reporter reporter) throws IOException, InterruptedException {
        BenchmarkCounter.initCounterFromReporter(reporter, configuration);
        this.initializeInternalReader(this.toParquetSplit(inputSplit), configuration);
    }

    private void initializeInternalReader(ParquetInputSplit split, Configuration configuration) throws IOException {
        List<BlockMetaData> blocks;
        Path path = split.getPath();
        long[] rowGroupOffsets = split.getRowGroupOffsets();
        HadoopReadOptions.Builder optionsBuilder = HadoopReadOptions.builder(configuration, path);
        if (rowGroupOffsets != null) {
            optionsBuilder.withOffsets(rowGroupOffsets);
        } else {
            optionsBuilder.withRange(split.getStart(), split.getEnd());
        }
        ParquetFileReader reader = ParquetFileReader.open(HadoopInputFile.fromPath(path, configuration), ((ParquetReadOptions.Builder)optionsBuilder).build());
        if (rowGroupOffsets != null && (blocks = reader.getFooter().getBlocks()).size() != rowGroupOffsets.length) {
            throw new IllegalStateException("All of the offsets in the split should be found in the file. expected: " + Arrays.toString(rowGroupOffsets) + " found: " + blocks);
        }
        if (!reader.getRowGroups().isEmpty() && reader.getFileMetaData().getEncryptionType() != FileMetaData.EncryptionType.ENCRYPTED_FOOTER && reader.getFileMetaData().getEncryptionType() != FileMetaData.EncryptionType.PLAINTEXT_FOOTER) {
            this.checkDeltaByteArrayProblem(reader.getFooter().getFileMetaData(), configuration, reader.getRowGroups().get(0));
        }
        this.internalReader.initialize(reader, configuration);
    }

    private void checkDeltaByteArrayProblem(FileMetaData meta, Configuration conf, BlockMetaData block) {
        if (conf.getBoolean("parquet.split.files", true)) {
            HashSet<Encoding> encodings = new HashSet<Encoding>();
            for (ColumnChunkMetaData column : block.getColumns()) {
                encodings.addAll(column.getEncodings());
            }
            for (Encoding encoding : encodings) {
                if (!CorruptDeltaByteArrays.requiresSequentialReads(meta.getCreatedBy(), encoding)) continue;
                throw new ParquetDecodingException("Cannot read data due to PARQUET-246: to read safely, set parquet.split.files to false");
            }
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.internalReader.nextKeyValue();
    }

    public long getCurrentRowIndex() throws IOException {
        return this.internalReader.getCurrentRowIndex();
    }

    private ParquetInputSplit toParquetSplit(InputSplit split) throws IOException {
        if (split instanceof ParquetInputSplit) {
            return (ParquetInputSplit)split;
        }
        if (split instanceof net.snowflake.ingest.internal.apache.hadoop.mapreduce.lib.input.FileSplit) {
            return ParquetInputSplit.from((net.snowflake.ingest.internal.apache.hadoop.mapreduce.lib.input.FileSplit)split);
        }
        if (split instanceof FileSplit) {
            return ParquetInputSplit.from((FileSplit)split);
        }
        throw new IllegalArgumentException("Invalid split (not a FileSplit or ParquetInputSplit): " + split);
    }
}

