/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.internal.filter2.columnindex;

import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.Function;
import net.snowflake.ingest.internal.apache.parquet.filter2.compat.FilterCompat;
import net.snowflake.ingest.internal.apache.parquet.filter2.predicate.FilterPredicate;
import net.snowflake.ingest.internal.apache.parquet.filter2.predicate.Operators;
import net.snowflake.ingest.internal.apache.parquet.filter2.predicate.UserDefinedPredicate;
import net.snowflake.ingest.internal.apache.parquet.hadoop.metadata.ColumnPath;
import net.snowflake.ingest.internal.apache.parquet.internal.column.columnindex.ColumnIndex;
import net.snowflake.ingest.internal.apache.parquet.internal.column.columnindex.OffsetIndex;
import net.snowflake.ingest.internal.apache.parquet.internal.filter2.columnindex.ColumnIndexStore;
import net.snowflake.ingest.internal.apache.parquet.internal.filter2.columnindex.RowRanges;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnIndexFilter
implements FilterPredicate.Visitor<RowRanges> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColumnIndexFilter.class);
    private final ColumnIndexStore columnIndexStore;
    private final Set<ColumnPath> columns;
    private final long rowCount;
    private RowRanges allRows;

    public static RowRanges calculateRowRanges(FilterCompat.Filter filter, final ColumnIndexStore columnIndexStore, final Set<ColumnPath> paths, final long rowCount) {
        return filter.accept(new FilterCompat.Visitor<RowRanges>(){

            @Override
            public RowRanges visit(FilterCompat.FilterPredicateCompat filterPredicateCompat) {
                try {
                    return filterPredicateCompat.getFilterPredicate().accept(new ColumnIndexFilter(columnIndexStore, paths, rowCount));
                }
                catch (ColumnIndexStore.MissingOffsetIndexException e) {
                    LOGGER.info(e.getMessage());
                    return RowRanges.createSingle(rowCount);
                }
            }

            @Override
            public RowRanges visit(FilterCompat.UnboundRecordFilterCompat unboundRecordFilterCompat) {
                return RowRanges.createSingle(rowCount);
            }

            @Override
            public RowRanges visit(FilterCompat.NoOpFilter noOpFilter) {
                return RowRanges.createSingle(rowCount);
            }
        });
    }

    private ColumnIndexFilter(ColumnIndexStore columnIndexStore, Set<ColumnPath> paths, long rowCount) {
        this.columnIndexStore = columnIndexStore;
        this.columns = paths;
        this.rowCount = rowCount;
    }

    private RowRanges allRows() {
        if (this.allRows == null) {
            this.allRows = RowRanges.createSingle(this.rowCount);
        }
        return this.allRows;
    }

    @Override
    public <T extends Comparable<T>> RowRanges visit(Operators.Eq<T> eq) {
        return this.applyPredicate(eq.getColumn(), ci -> (PrimitiveIterator.OfInt)ci.visit(eq), eq.getValue() == null ? this.allRows() : RowRanges.EMPTY);
    }

    @Override
    public <T extends Comparable<T>> RowRanges visit(Operators.NotEq<T> notEq) {
        return this.applyPredicate(notEq.getColumn(), ci -> (PrimitiveIterator.OfInt)ci.visit(notEq), notEq.getValue() == null ? RowRanges.EMPTY : this.allRows());
    }

    @Override
    public <T extends Comparable<T>> RowRanges visit(Operators.Lt<T> lt) {
        return this.applyPredicate(lt.getColumn(), ci -> (PrimitiveIterator.OfInt)ci.visit(lt), RowRanges.EMPTY);
    }

    @Override
    public <T extends Comparable<T>> RowRanges visit(Operators.LtEq<T> ltEq) {
        return this.applyPredicate(ltEq.getColumn(), ci -> (PrimitiveIterator.OfInt)ci.visit(ltEq), RowRanges.EMPTY);
    }

    @Override
    public <T extends Comparable<T>> RowRanges visit(Operators.Gt<T> gt) {
        return this.applyPredicate(gt.getColumn(), ci -> (PrimitiveIterator.OfInt)ci.visit(gt), RowRanges.EMPTY);
    }

    @Override
    public <T extends Comparable<T>> RowRanges visit(Operators.GtEq<T> gtEq) {
        return this.applyPredicate(gtEq.getColumn(), ci -> (PrimitiveIterator.OfInt)ci.visit(gtEq), RowRanges.EMPTY);
    }

    @Override
    public <T extends Comparable<T>> RowRanges visit(Operators.In<T> in) {
        boolean isNull = in.getValues().contains(null);
        return this.applyPredicate(in.getColumn(), ci -> (PrimitiveIterator.OfInt)ci.visit(in), isNull ? this.allRows() : RowRanges.EMPTY);
    }

    @Override
    public <T extends Comparable<T>> RowRanges visit(Operators.NotIn<T> notIn) {
        boolean isNull = notIn.getValues().contains(null);
        return this.applyPredicate(notIn.getColumn(), ci -> (PrimitiveIterator.OfInt)ci.visit(notIn), isNull ? RowRanges.EMPTY : this.allRows());
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> RowRanges visit(Operators.UserDefined<T, U> udp) {
        return this.applyPredicate(udp.getColumn(), ci -> (PrimitiveIterator.OfInt)ci.visit(udp), ((UserDefinedPredicate)udp.getUserDefinedPredicate()).acceptsNullValue() ? this.allRows() : RowRanges.EMPTY);
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> RowRanges visit(Operators.LogicalNotUserDefined<T, U> udp) {
        return this.applyPredicate(udp.getUserDefined().getColumn(), ci -> (PrimitiveIterator.OfInt)ci.visit(udp), ((UserDefinedPredicate)udp.getUserDefined().getUserDefinedPredicate()).acceptsNullValue() ? RowRanges.EMPTY : this.allRows());
    }

    private RowRanges applyPredicate(Operators.Column<?> column, Function<ColumnIndex, PrimitiveIterator.OfInt> func, RowRanges rangesForMissingColumns) {
        ColumnPath columnPath = column.getColumnPath();
        if (!this.columns.contains(columnPath)) {
            return rangesForMissingColumns;
        }
        OffsetIndex oi = this.columnIndexStore.getOffsetIndex(columnPath);
        ColumnIndex ci = this.columnIndexStore.getColumnIndex(columnPath);
        if (ci == null) {
            LOGGER.info("No column index for column {} is available; Unable to filter on this column", (Object)columnPath);
            return this.allRows();
        }
        return RowRanges.create(this.rowCount, func.apply(ci), oi);
    }

    @Override
    public RowRanges visit(Operators.And and) {
        RowRanges leftResult = and.getLeft().accept(this);
        if (leftResult.getRanges().size() == 0) {
            return leftResult;
        }
        return RowRanges.intersection(leftResult, and.getRight().accept(this));
    }

    @Override
    public RowRanges visit(Operators.Or or) {
        RowRanges leftResult = or.getLeft().accept(this);
        if (leftResult.getRanges().size() == 1 && leftResult.rowCount() == this.rowCount) {
            return leftResult;
        }
        return RowRanges.union(leftResult, or.getRight().accept(this));
    }

    @Override
    public RowRanges visit(Operators.Not not) {
        throw new IllegalArgumentException("Predicates containing a NOT must be run through LogicalInverseRewriter. " + not);
    }
}

