/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.com.github.luben.zstd;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import net.snowflake.ingest.internal.com.github.luben.zstd.BufferPool;
import net.snowflake.ingest.internal.com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import net.snowflake.ingest.internal.com.github.luben.zstd.ZstdOutputStreamNoFinalizer;

public class RecyclingBufferPool
implements BufferPool {
    public static final BufferPool INSTANCE = new RecyclingBufferPool();
    private static final int buffSize = Math.max(Math.max((int)ZstdOutputStreamNoFinalizer.recommendedCOutSize(), (int)ZstdInputStreamNoFinalizer.recommendedDInSize()), (int)ZstdInputStreamNoFinalizer.recommendedDOutSize());
    private final ArrayDeque<SoftReference<ByteBuffer>> pool = new ArrayDeque();

    private RecyclingBufferPool() {
    }

    @Override
    public synchronized ByteBuffer get(int n) {
        SoftReference<ByteBuffer> softReference;
        ByteBuffer byteBuffer;
        if (n > buffSize) {
            throw new RuntimeException("Unsupported buffer size: " + n + ". Supported buffer sizes: " + buffSize + " or smaller.");
        }
        do {
            if ((softReference = this.pool.pollFirst()) != null) continue;
            return ByteBuffer.allocate(buffSize);
        } while ((byteBuffer = softReference.get()) == null);
        return byteBuffer;
    }

    @Override
    public synchronized void release(ByteBuffer byteBuffer) {
        if (byteBuffer.capacity() >= buffSize) {
            byteBuffer.clear();
            this.pool.addFirst(new SoftReference<ByteBuffer>(byteBuffer));
        }
    }
}

