/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.com.nimbusds.jose.crypto;

import java.util.Collections;
import java.util.Set;
import javax.crypto.SecretKey;
import net.snowflake.ingest.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWECryptoParts;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWEEncrypter;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWEHeader;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.ECDH1PU;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.ECDH1PUCryptoProvider;
import net.snowflake.ingest.internal.com.nimbusds.jose.jwk.Curve;
import net.snowflake.ingest.internal.com.nimbusds.jose.jwk.OctetKeyPair;
import net.snowflake.ingest.internal.com.nimbusds.jose.jwk.gen.OctetKeyPairGenerator;
import net.snowflake.ingest.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ECDH1PUX25519Encrypter
extends ECDH1PUCryptoProvider
implements JWEEncrypter {
    private final OctetKeyPair publicKey;
    private final OctetKeyPair privateKey;
    private final SecretKey contentEncryptionKey;

    public ECDH1PUX25519Encrypter(OctetKeyPair privateKey, OctetKeyPair publicKey) throws JOSEException {
        this(privateKey, publicKey, null);
    }

    public ECDH1PUX25519Encrypter(OctetKeyPair privateKey, OctetKeyPair publicKey, SecretKey contentEncryptionKey) throws JOSEException {
        super(publicKey.getCurve());
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        if (!(contentEncryptionKey == null || contentEncryptionKey.getAlgorithm() != null && contentEncryptionKey.getAlgorithm().equals("AES"))) {
            throw new IllegalArgumentException("The algorithm of the content encryption key (CEK) must be AES");
        }
        this.contentEncryptionKey = contentEncryptionKey;
    }

    @Override
    public Set<Curve> supportedEllipticCurves() {
        return Collections.singleton(Curve.X25519);
    }

    public OctetKeyPair getPublicKey() {
        return this.publicKey;
    }

    public OctetKeyPair getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText) throws JOSEException {
        OctetKeyPair ephemeralPrivateKey = new OctetKeyPairGenerator(this.getCurve()).generate();
        OctetKeyPair ephemeralPublicKey = ephemeralPrivateKey.toPublicJWK();
        JWEHeader updatedHeader = new JWEHeader.Builder(header).ephemeralPublicKey(ephemeralPublicKey).build();
        SecretKey Z = ECDH1PU.deriveSenderZ(this.privateKey, this.publicKey, ephemeralPrivateKey);
        return this.encryptWithZ(updatedHeader, Z, clearText, this.contentEncryptionKey);
    }
}

