/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.util.concurrent.atomic.AtomicLong;

class ChannelRuntimeState {
    private volatile boolean isValid;
    private volatile String offsetToken;
    private final AtomicLong rowSequencer;
    private Long firstInsertInMs;
    private Long lastInsertInMs;

    ChannelRuntimeState(String offsetToken, long rowSequencer, boolean isValid) {
        this.offsetToken = offsetToken;
        this.rowSequencer = new AtomicLong(rowSequencer);
        this.isValid = isValid;
    }

    boolean isValid() {
        return this.isValid;
    }

    void invalidate() {
        this.isValid = false;
    }

    String getOffsetToken() {
        return this.offsetToken;
    }

    long incrementAndGetRowSequencer() {
        return this.rowSequencer.incrementAndGet();
    }

    long getRowSequencer() {
        return this.rowSequencer.get();
    }

    void setOffsetToken(String offsetToken) {
        this.offsetToken = offsetToken;
    }

    void updateInsertStats(long currentTimeInMs, int rowCount) {
        if (rowCount == 0) {
            this.firstInsertInMs = currentTimeInMs;
        }
        this.lastInsertInMs = currentTimeInMs;
    }

    Long getFirstInsertInMs() {
        return this.firstInsertInMs;
    }

    Long getLastInsertInMs() {
        return this.lastInsertInMs;
    }
}

