/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.ZoneId;
import java.util.Optional;
import net.snowflake.ingest.internal.apache.parquet.schema.PrimitiveType;
import net.snowflake.ingest.internal.javax.annotation.Nullable;
import net.snowflake.ingest.streaming.internal.AbstractRowBuffer;
import net.snowflake.ingest.streaming.internal.ColumnMetadata;
import net.snowflake.ingest.streaming.internal.DataValidationUtil;
import net.snowflake.ingest.streaming.internal.RowBufferStats;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.SFException;
import net.snowflake.ingest.utils.Utils;

class ParquetValueParser {
    public static final float BIT_ENCODING_BYTE_LEN = 0.125f;
    public static final float DEFINITION_LEVEL_ENCODING_BYTE_LEN = 0.25f;
    public static final int BYTE_ARRAY_LENGTH_ENCODING_BYTE_LEN = 4;

    ParquetValueParser() {
    }

    static ParquetBufferValue parseColumnValueToParquet(Object value, ColumnMetadata columnMetadata, PrimitiveType.PrimitiveTypeName typeName, RowBufferStats stats, ZoneId defaultTimezone, long insertRowsCurrIndex) {
        Utils.assertNotNull("Parquet column stats", stats);
        float estimatedParquetSize = 0.0f;
        estimatedParquetSize += 0.25f;
        if (value != null) {
            AbstractRowBuffer.ColumnLogicalType logicalType = AbstractRowBuffer.ColumnLogicalType.valueOf(columnMetadata.getLogicalType());
            AbstractRowBuffer.ColumnPhysicalType physicalType = AbstractRowBuffer.ColumnPhysicalType.valueOf(columnMetadata.getPhysicalType());
            switch (typeName) {
                case BOOLEAN: {
                    int intValue = DataValidationUtil.validateAndParseBoolean(columnMetadata.getName(), value, insertRowsCurrIndex);
                    value = intValue > 0;
                    stats.addIntValue(BigInteger.valueOf(intValue));
                    estimatedParquetSize += 0.125f;
                    break;
                }
                case INT32: {
                    int intVal = ParquetValueParser.getInt32Value(columnMetadata.getName(), value, columnMetadata.getScale(), Optional.ofNullable(columnMetadata.getPrecision()).orElse(0), logicalType, physicalType, insertRowsCurrIndex);
                    value = intVal;
                    stats.addIntValue(BigInteger.valueOf(intVal));
                    estimatedParquetSize += 4.0f;
                    break;
                }
                case INT64: {
                    long longValue = ParquetValueParser.getInt64Value(columnMetadata.getName(), value, columnMetadata.getScale(), Optional.ofNullable(columnMetadata.getPrecision()).orElse(0), logicalType, physicalType, defaultTimezone, insertRowsCurrIndex);
                    value = longValue;
                    stats.addIntValue(BigInteger.valueOf(longValue));
                    estimatedParquetSize += 8.0f;
                    break;
                }
                case DOUBLE: {
                    double doubleValue = DataValidationUtil.validateAndParseReal(columnMetadata.getName(), value, insertRowsCurrIndex);
                    value = doubleValue;
                    stats.addRealValue(doubleValue);
                    estimatedParquetSize += 8.0f;
                    break;
                }
                case BINARY: {
                    int length = 0;
                    if (logicalType == AbstractRowBuffer.ColumnLogicalType.BINARY) {
                        value = ParquetValueParser.getBinaryValueForLogicalBinary(value, stats, columnMetadata, insertRowsCurrIndex);
                        length = ((byte[])value).length;
                    } else {
                        String str = ParquetValueParser.getBinaryValue(value, stats, columnMetadata, insertRowsCurrIndex);
                        value = str;
                        if (str != null) {
                            length = str.getBytes().length;
                        }
                    }
                    if (value == null) break;
                    estimatedParquetSize += (float)(4 + length);
                    break;
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    BigInteger intRep = ParquetValueParser.getSb16Value(columnMetadata.getName(), value, columnMetadata.getScale(), Optional.ofNullable(columnMetadata.getPrecision()).orElse(0), logicalType, physicalType, defaultTimezone, insertRowsCurrIndex);
                    stats.addIntValue(intRep);
                    value = ParquetValueParser.getSb16Bytes(intRep);
                    estimatedParquetSize += 16.0f;
                    break;
                }
                default: {
                    throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, new Object[]{logicalType, physicalType});
                }
            }
        }
        if (value == null) {
            if (!columnMetadata.getNullable()) {
                throw new SFException(ErrorCode.INVALID_FORMAT_ROW, columnMetadata.getName(), "Passed null to non nullable field");
            }
            stats.incCurrentNullCount();
        }
        return new ParquetBufferValue(value, estimatedParquetSize);
    }

    private static int getInt32Value(String columnName, Object value, @Nullable Integer scale, Integer precision, AbstractRowBuffer.ColumnLogicalType logicalType, AbstractRowBuffer.ColumnPhysicalType physicalType, long insertRowsCurrIndex) {
        int intVal;
        switch (logicalType) {
            case DATE: {
                intVal = DataValidationUtil.validateAndParseDate(columnName, value, insertRowsCurrIndex);
                break;
            }
            case TIME: {
                Utils.assertNotNull("Unexpected null scale for TIME data type", scale);
                intVal = DataValidationUtil.validateAndParseTime(columnName, value, scale, insertRowsCurrIndex).intValue();
                break;
            }
            case FIXED: {
                BigDecimal bigDecimalValue = DataValidationUtil.validateAndParseBigDecimal(columnName, value, insertRowsCurrIndex);
                bigDecimalValue = bigDecimalValue.setScale((int)scale, RoundingMode.HALF_UP);
                DataValidationUtil.checkValueInRange(bigDecimalValue, scale, precision, insertRowsCurrIndex);
                intVal = bigDecimalValue.intValue();
                break;
            }
            default: {
                throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, new Object[]{logicalType, physicalType});
            }
        }
        return intVal;
    }

    private static long getInt64Value(String columnName, Object value, int scale, int precision, AbstractRowBuffer.ColumnLogicalType logicalType, AbstractRowBuffer.ColumnPhysicalType physicalType, ZoneId defaultTimezone, long insertRowsCurrIndex) {
        long longValue;
        switch (logicalType) {
            case TIME: {
                Utils.assertNotNull("Unexpected null scale for TIME data type", scale);
                longValue = DataValidationUtil.validateAndParseTime(columnName, value, scale, insertRowsCurrIndex).longValue();
                break;
            }
            case TIMESTAMP_LTZ: 
            case TIMESTAMP_NTZ: {
                boolean trimTimezone = logicalType == AbstractRowBuffer.ColumnLogicalType.TIMESTAMP_NTZ;
                longValue = DataValidationUtil.validateAndParseTimestamp(columnName, value, scale, defaultTimezone, trimTimezone, insertRowsCurrIndex).toBinary(false).longValue();
                break;
            }
            case TIMESTAMP_TZ: {
                longValue = DataValidationUtil.validateAndParseTimestamp(columnName, value, scale, defaultTimezone, false, insertRowsCurrIndex).toBinary(true).longValue();
                break;
            }
            case FIXED: {
                BigDecimal bigDecimalValue = DataValidationUtil.validateAndParseBigDecimal(columnName, value, insertRowsCurrIndex);
                bigDecimalValue = bigDecimalValue.setScale(scale, RoundingMode.HALF_UP);
                DataValidationUtil.checkValueInRange(bigDecimalValue, scale, precision, insertRowsCurrIndex);
                longValue = bigDecimalValue.longValue();
                break;
            }
            default: {
                throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, new Object[]{logicalType, physicalType});
            }
        }
        return longValue;
    }

    private static BigInteger getSb16Value(String columnName, Object value, int scale, int precision, AbstractRowBuffer.ColumnLogicalType logicalType, AbstractRowBuffer.ColumnPhysicalType physicalType, ZoneId defaultTimezone, long insertRowsCurrIndex) {
        switch (logicalType) {
            case TIMESTAMP_TZ: {
                return DataValidationUtil.validateAndParseTimestamp(columnName, value, scale, defaultTimezone, false, insertRowsCurrIndex).toBinary(true);
            }
            case TIMESTAMP_LTZ: 
            case TIMESTAMP_NTZ: {
                boolean trimTimezone = logicalType == AbstractRowBuffer.ColumnLogicalType.TIMESTAMP_NTZ;
                return DataValidationUtil.validateAndParseTimestamp(columnName, value, scale, defaultTimezone, trimTimezone, insertRowsCurrIndex).toBinary(false);
            }
            case FIXED: {
                BigDecimal bigDecimalValue = DataValidationUtil.validateAndParseBigDecimal(columnName, value, insertRowsCurrIndex);
                bigDecimalValue = bigDecimalValue.setScale(scale, RoundingMode.HALF_UP);
                DataValidationUtil.checkValueInRange(bigDecimalValue, scale, precision, insertRowsCurrIndex);
                return bigDecimalValue.unscaledValue();
            }
        }
        throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, new Object[]{logicalType, physicalType});
    }

    static byte[] getSb16Bytes(BigInteger intRep) {
        byte[] bytes = intRep.toByteArray();
        byte padByte = (byte)(bytes[0] < 0 ? -1 : 0);
        byte[] bytesBE = new byte[16];
        for (int i = 0; i < 16 - bytes.length; ++i) {
            bytesBE[i] = padByte;
        }
        System.arraycopy(bytes, 0, bytesBE, 16 - bytes.length, bytes.length);
        return bytesBE;
    }

    private static String getBinaryValue(Object value, RowBufferStats stats, ColumnMetadata columnMetadata, long insertRowsCurrIndex) {
        String str;
        block6: {
            block5: {
                AbstractRowBuffer.ColumnLogicalType logicalType = AbstractRowBuffer.ColumnLogicalType.valueOf(columnMetadata.getLogicalType());
                if (!logicalType.isObject()) break block5;
                switch (logicalType) {
                    case OBJECT: {
                        str = DataValidationUtil.validateAndParseObject(columnMetadata.getName(), value, insertRowsCurrIndex);
                        break block6;
                    }
                    case VARIANT: {
                        str = DataValidationUtil.validateAndParseVariant(columnMetadata.getName(), value, insertRowsCurrIndex);
                        break block6;
                    }
                    case ARRAY: {
                        str = DataValidationUtil.validateAndParseArray(columnMetadata.getName(), value, insertRowsCurrIndex);
                        break block6;
                    }
                    default: {
                        throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, new Object[]{logicalType, columnMetadata.getPhysicalType()});
                    }
                }
            }
            String maxLengthString = columnMetadata.getLength().toString();
            str = DataValidationUtil.validateAndParseString(columnMetadata.getName(), value, Optional.of(maxLengthString).map(Integer::parseInt), insertRowsCurrIndex);
            stats.addStrValue(str);
        }
        return str;
    }

    private static byte[] getBinaryValueForLogicalBinary(Object value, RowBufferStats stats, ColumnMetadata columnMetadata, long insertRowsCurrIndex) {
        String maxLengthString = columnMetadata.getByteLength().toString();
        byte[] bytes = DataValidationUtil.validateAndParseBinary(columnMetadata.getName(), value, Optional.of(maxLengthString).map(Integer::parseInt), insertRowsCurrIndex);
        stats.addBinaryValue(bytes);
        return bytes;
    }

    static class ParquetBufferValue {
        private final Object value;
        private final float size;

        ParquetBufferValue(Object value, float size) {
            this.value = value;
            this.size = size;
        }

        Object getValue() {
            return this.value;
        }

        float getSize() {
            return this.size;
        }
    }
}

