/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.OffsetDateTime;
import net.snowflake.client.jdbc.internal.snowflake.common.util.Power10;

public class TimestampWrapper {
    private final long epoch;
    private final int fraction;
    private final int timezoneOffsetSeconds;
    private final int scale;
    private static final int BITS_FOR_TIMEZONE = 14;
    private static final int MASK_OF_TIMEZONE = 16383;

    public TimestampWrapper(OffsetDateTime offsetDateTime, int scale) {
        if (scale < 0 || scale > 9) {
            throw new IllegalArgumentException(String.format("Scale must be between 0 and 9, actual: %d", scale));
        }
        this.epoch = offsetDateTime.toEpochSecond();
        this.fraction = offsetDateTime.getNano() / Power10.intTable[9 - scale] * Power10.intTable[9 - scale];
        this.timezoneOffsetSeconds = offsetDateTime.getOffset().getTotalSeconds();
        this.scale = scale;
    }

    public BigInteger toBinary(boolean includeTimezone) {
        BigDecimal timeInNs = BigDecimal.valueOf(this.epoch).scaleByPowerOfTen(9).add(new BigDecimal(this.fraction));
        BigDecimal scaledTime = timeInNs.scaleByPowerOfTen(this.scale - 9);
        scaledTime = scaledTime.setScale(0, RoundingMode.DOWN);
        BigInteger fcpInt = scaledTime.unscaledValue();
        if (includeTimezone) {
            int offsetMin = this.timezoneOffsetSeconds / 60;
            assert (offsetMin >= -1440 && offsetMin <= 1440);
            fcpInt = fcpInt.shiftLeft(14);
            fcpInt = fcpInt.add(BigInteger.valueOf((offsetMin += 1440) & 0x3FFF));
        }
        return fcpInt;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public int getFraction() {
        return this.fraction;
    }

    public int getTimezoneOffsetSeconds() {
        return this.timezoneOffsetSeconds;
    }

    public int getTimeZoneIndex() {
        return this.timezoneOffsetSeconds / 60 + 1440;
    }
}

