/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.connection;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.client.jdbc.telemetry.TelemetryClient;
import net.snowflake.client.jdbc.telemetry.TelemetryUtil;
import net.snowflake.ingest.utils.Logging;

public class TelemetryService {
    private static final Logging logger = new Logging(TelemetryService.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String TYPE = "type";
    private static final String CLIENT_NAME = "client_name";
    private static final String COUNT = "count";
    private static final String MAX = "max";
    private static final String MIN = "min";
    private static final String MEDIAN = "median";
    private static final String MEAN = "mean";
    private static final String PERCENTILE99TH = "99thPercentile";
    private final TelemetryClient telemetry;
    private final String clientName;

    TelemetryService(CloseableHttpClient httpClient, String clientName, String url) {
        this.clientName = clientName;
        this.telemetry = (TelemetryClient)TelemetryClient.createSessionlessTelemetry((CloseableHttpClient)httpClient, (String)url);
    }

    public void close() {
        this.telemetry.close();
    }

    public void reportLatencyInSec(Timer buildLatency, Timer uploadLatency, Timer registerLatency, Timer flushLatency) {
        if (flushLatency.getCount() > 0L) {
            ObjectNode msg = MAPPER.createObjectNode();
            msg.set("build_latency_ms", (JsonNode)this.buildMsgFromTimer(buildLatency));
            msg.set("upload_latency_ms", (JsonNode)this.buildMsgFromTimer(uploadLatency));
            msg.set("register_latency_ms", (JsonNode)this.buildMsgFromTimer(registerLatency));
            msg.set("flush_latency_ms", (JsonNode)this.buildMsgFromTimer(flushLatency));
            this.send(TelemetryType.STREAMING_INGEST_LATENCY_IN_SEC, msg);
        }
    }

    public void reportClientFailure(String summary, String exception) {
        ObjectNode msg = MAPPER.createObjectNode();
        msg.put("summary", summary);
        msg.put("client_version", "2.0.4");
        msg.put("exception", exception);
        this.send(TelemetryType.STREAMING_INGEST_CLIENT_FAILURE, msg);
    }

    public void reportThroughputBytesPerSecond(Meter inputThroughput, Meter uploadThroughput) {
        if (inputThroughput.getCount() > 0L) {
            ObjectNode msg = MAPPER.createObjectNode();
            msg.put(COUNT, inputThroughput.getCount());
            msg.put("input_mean_rate_bytes_per_sec", inputThroughput.getMeanRate());
            msg.put("upload_mean_rate_bytes_per_sec", uploadThroughput.getMeanRate());
            this.send(TelemetryType.STREAMING_INGEST_THROUGHPUT_BYTES_PER_SEC, msg);
        }
    }

    public void reportCpuMemoryUsage(Histogram cpuUsage) {
        if (cpuUsage.getCount() > 0L) {
            ObjectNode msg = MAPPER.createObjectNode();
            Snapshot cpuSnapshot = cpuUsage.getSnapshot();
            Runtime runTime = Runtime.getRuntime();
            msg.put(COUNT, cpuUsage.getCount());
            msg.put("cpu_max", cpuSnapshot.getMax());
            msg.put("cpu_mean", cpuSnapshot.getMean());
            msg.put("max_memory", runTime.maxMemory());
            msg.put("total_memory", runTime.totalMemory());
            msg.put("free_memory", runTime.freeMemory());
            this.send(TelemetryType.STREAMING_INGEST_CPU_MEMORY_USAGE, msg);
        }
    }

    void send(TelemetryType type, ObjectNode msg) {
        try {
            msg.put(TYPE, type.toString());
            msg.put(CLIENT_NAME, this.clientName);
            this.telemetry.addLogToBatch(TelemetryUtil.buildJobData((ObjectNode)msg));
        }
        catch (Exception e) {
            logger.logWarn("Failed to send telemetry data, error: {}", e.getMessage());
        }
    }

    private ObjectNode buildMsgFromTimer(Timer timer) {
        ObjectNode msg = MAPPER.createObjectNode();
        Snapshot buildSnapshot = timer.getSnapshot();
        msg.put(COUNT, timer.getCount());
        msg.put(MAX, TimeUnit.NANOSECONDS.toMillis(buildSnapshot.getMax()));
        msg.put(MIN, TimeUnit.NANOSECONDS.toMillis(buildSnapshot.getMin()));
        msg.put(MEAN, TimeUnit.NANOSECONDS.toMillis((long)buildSnapshot.getMean()));
        msg.put(MEDIAN, TimeUnit.NANOSECONDS.toMillis((long)buildSnapshot.getMedian()));
        msg.put(PERCENTILE99TH, TimeUnit.NANOSECONDS.toMillis((long)buildSnapshot.get99thPercentile()));
        return msg;
    }

    public void refreshToken(String token) {
        this.telemetry.refreshToken(token);
    }

    static enum TelemetryType {
        STREAMING_INGEST_LATENCY_IN_SEC("streaming_ingest_latency_in_ms"),
        STREAMING_INGEST_CLIENT_FAILURE("streaming_ingest_client_failure"),
        STREAMING_INGEST_THROUGHPUT_BYTES_PER_SEC("streaming_ingest_throughput_bytes_per_sec"),
        STREAMING_INGEST_CPU_MEMORY_USAGE("streaming_ingest_cpu_memory_usage");

        private final String name;

        private TelemetryType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

