/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming;

import java.time.ZoneId;
import net.snowflake.ingest.utils.Utils;

public class OpenChannelRequest {
    private static final ZoneId DEFAULT_DEFAULT_TIMEZONE = ZoneId.of("America/Los_Angeles");
    private final String channelName;
    private final String dbName;
    private final String schemaName;
    private final String tableName;
    private final OnErrorOption onErrorOption;
    private final ZoneId defaultTimezone;

    public static OpenChannelRequestBuilder builder(String channelName) {
        return new OpenChannelRequestBuilder(channelName);
    }

    private OpenChannelRequest(OpenChannelRequestBuilder builder) {
        Utils.assertStringNotNullOrEmpty("channel name", builder.channelName);
        Utils.assertStringNotNullOrEmpty("database name", builder.dbName);
        Utils.assertStringNotNullOrEmpty("schema name", builder.schemaName);
        Utils.assertStringNotNullOrEmpty("table name", builder.tableName);
        Utils.assertNotNull("on_error option", (Object)builder.onErrorOption);
        Utils.assertNotNull("default_timezone", builder.defaultTimezone);
        this.channelName = builder.channelName;
        this.dbName = builder.dbName;
        this.schemaName = builder.schemaName;
        this.tableName = builder.tableName;
        this.onErrorOption = builder.onErrorOption;
        this.defaultTimezone = builder.defaultTimezone;
    }

    public String getDBName() {
        return this.dbName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public ZoneId getDefaultTimezone() {
        return this.defaultTimezone;
    }

    public String getFullyQualifiedTableName() {
        return String.format("%s.%s.%s", this.dbName, this.schemaName, this.tableName);
    }

    public OnErrorOption getOnErrorOption() {
        return this.onErrorOption;
    }

    public static class OpenChannelRequestBuilder {
        private final String channelName;
        private String dbName;
        private String schemaName;
        private String tableName;
        private OnErrorOption onErrorOption;
        private ZoneId defaultTimezone;

        public OpenChannelRequestBuilder(String channelName) {
            this.channelName = channelName;
            this.defaultTimezone = DEFAULT_DEFAULT_TIMEZONE;
        }

        public OpenChannelRequestBuilder setDBName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public OpenChannelRequestBuilder setSchemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public OpenChannelRequestBuilder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public OpenChannelRequestBuilder setOnErrorOption(OnErrorOption onErrorOption) {
            this.onErrorOption = onErrorOption;
            return this;
        }

        public OpenChannelRequestBuilder setDefaultTimezone(ZoneId defaultTimezone) {
            this.defaultTimezone = defaultTimezone;
            return this;
        }

        public OpenChannelRequest build() {
            return new OpenChannelRequest(this);
        }
    }

    public static enum OnErrorOption {
        CONTINUE,
        ABORT,
        SKIP_BATCH;

    }
}

