/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import net.snowflake.ingest.streaming.internal.AbstractRowBuffer;
import net.snowflake.ingest.streaming.internal.BlobStats;
import net.snowflake.ingest.streaming.internal.ChannelData;
import net.snowflake.ingest.streaming.internal.ChannelFlushContext;
import net.snowflake.ingest.streaming.internal.ChunkMetadata;
import net.snowflake.ingest.streaming.internal.Flusher;
import net.snowflake.ingest.utils.Constants;
import net.snowflake.ingest.utils.Cryptor;
import net.snowflake.ingest.utils.Logging;
import net.snowflake.ingest.utils.Pair;
import org.apache.commons.codec.binary.Hex;

class BlobBuilder {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logging logger = new Logging(BlobBuilder.class);

    BlobBuilder() {
    }

    static <T> Blob constructBlobAndMetadata(String filePath, List<List<ChannelData<T>>> blobData, Constants.BdecVersion bdecVersion) throws IOException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        ArrayList<ChunkMetadata> chunksMetadataList = new ArrayList<ChunkMetadata>();
        ArrayList<byte[]> chunksDataList = new ArrayList<byte[]>();
        long curDataSize = 0L;
        CRC32 crc = new CRC32();
        for (List<ChannelData<T>> channelsDataPerTable : blobData) {
            ChannelFlushContext firstChannelFlushContext = channelsDataPerTable.get(0).getChannelContext();
            Flusher<T> flusher = channelsDataPerTable.get(0).createFlusher();
            Flusher.SerializationResult serializedChunk = flusher.serialize(channelsDataPerTable, filePath);
            if (serializedChunk.channelsMetadataList.isEmpty()) continue;
            ByteArrayOutputStream chunkData = serializedChunk.chunkData;
            Pair<byte[], Integer> paddedChunk = BlobBuilder.padChunk(chunkData, 16);
            byte[] paddedChunkData = paddedChunk.getFirst();
            int paddedChunkLength = paddedChunk.getSecond();
            long iv = curDataSize / 16L;
            byte[] encryptedCompressedChunkData = Cryptor.encrypt(paddedChunkData, firstChannelFlushContext.getEncryptionKey(), filePath, iv);
            String md5 = BlobBuilder.computeMD5(encryptedCompressedChunkData, paddedChunkLength);
            int encryptedCompressedChunkDataSize = encryptedCompressedChunkData.length;
            long startOffset = curDataSize;
            ChunkMetadata chunkMetadata = ChunkMetadata.builder().setOwningTableFromChannelContext(firstChannelFlushContext).setChunkStartOffset(startOffset).setChunkLength(paddedChunkLength).setUncompressedChunkLength((int)serializedChunk.chunkEstimatedUncompressedSize).setChannelList(serializedChunk.channelsMetadataList).setChunkMD5(md5).setEncryptionKeyId(firstChannelFlushContext.getEncryptionKeyId()).setEpInfo(AbstractRowBuffer.buildEpInfoFromStats(serializedChunk.rowCount, serializedChunk.columnEpStatsMapCombined)).setFirstInsertTimeInMs(serializedChunk.chunkMinMaxInsertTimeInMs.getFirst()).setLastInsertTimeInMs(serializedChunk.chunkMinMaxInsertTimeInMs.getSecond()).build();
            chunksMetadataList.add(chunkMetadata);
            chunksDataList.add(encryptedCompressedChunkData);
            curDataSize += (long)encryptedCompressedChunkDataSize;
            crc.update(encryptedCompressedChunkData, 0, encryptedCompressedChunkDataSize);
            logger.logInfo("Finish building chunk in blob={}, table={}, rowCount={}, startOffset={}, estimatedUncompressedSize={}, paddedChunkLength={}, encryptedCompressedSize={}, bdecVersion={}", new Object[]{filePath, firstChannelFlushContext.getFullyQualifiedTableName(), serializedChunk.rowCount, startOffset, Float.valueOf(serializedChunk.chunkEstimatedUncompressedSize), paddedChunkLength, encryptedCompressedChunkDataSize, bdecVersion});
        }
        byte[] blobBytes = BlobBuilder.buildBlob(chunksMetadataList, chunksDataList, crc.getValue(), curDataSize, bdecVersion);
        return new Blob(blobBytes, chunksMetadataList, new BlobStats());
    }

    static Pair<byte[], Integer> padChunk(ByteArrayOutputStream chunkData, int blockSizeToAlignTo) throws IOException {
        int actualSize = chunkData.size();
        int paddingSize = blockSizeToAlignTo - actualSize % blockSizeToAlignTo;
        chunkData.write(new byte[paddingSize]);
        return new Pair<byte[], Integer>(chunkData.toByteArray(), actualSize);
    }

    static byte[] buildBlob(List<ChunkMetadata> chunksMetadataList, List<byte[]> chunksDataList, long chunksChecksum, long chunksDataSize, Constants.BdecVersion bdecVersion) throws IOException {
        byte[] chunkMetadataListInBytes = MAPPER.writeValueAsBytes(chunksMetadataList);
        int metadataSize = 0;
        ByteArrayOutputStream blob = new ByteArrayOutputStream();
        for (byte[] chunkData : chunksDataList) {
            blob.write(chunkData);
        }
        for (ChunkMetadata chunkMetadata : chunksMetadataList) {
            chunkMetadata.advanceStartOffset(metadataSize);
        }
        return blob.toByteArray();
    }

    static String computeMD5(byte[] data) throws NoSuchAlgorithmException {
        return BlobBuilder.computeMD5(data, data.length);
    }

    static String computeMD5(byte[] data, int length) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(data, 0, length);
        byte[] digest = md.digest();
        return Hex.encodeHexString((byte[])digest);
    }

    static class Blob {
        final byte[] blobBytes;
        final List<ChunkMetadata> chunksMetadataList;
        final BlobStats blobStats;

        Blob(byte[] blobBytes, List<ChunkMetadata> chunksMetadataList, BlobStats blobStats) {
            this.blobBytes = blobBytes;
            this.chunksMetadataList = chunksMetadataList;
            this.blobStats = blobStats;
        }
    }
}

