/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import net.snowflake.ingest.streaming.internal.SnowflakeStreamingIngestChannelInternal;

class ChannelsStatusRequest {
    private String requestId;
    private List<ChannelStatusRequestDTO> channels;
    private String role;

    ChannelsStatusRequest() {
    }

    @JsonProperty(value="request_id")
    String getRequestId() {
        return this.requestId;
    }

    @JsonProperty(value="role")
    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    public void setRole(String role) {
        this.role = role;
    }

    @JsonProperty(value="request_id")
    void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @JsonProperty(value="channels")
    void setChannels(List<ChannelStatusRequestDTO> channels) {
        this.channels = channels;
    }

    @JsonProperty(value="channels")
    List<ChannelStatusRequestDTO> getChannels() {
        return this.channels;
    }

    static class ChannelStatusRequestDTO {
        private final String databaseName;
        private final String schemaName;
        private final String tableName;
        private final String channelName;
        private final Long clientSequencer;

        ChannelStatusRequestDTO(SnowflakeStreamingIngestChannelInternal channel) {
            this.channelName = channel.getName();
            this.databaseName = channel.getDBName();
            this.schemaName = channel.getSchemaName();
            this.tableName = channel.getTableName();
            this.clientSequencer = channel.getChannelSequencer();
        }

        @JsonProperty(value="table")
        String getTableName() {
            return this.tableName;
        }

        @JsonProperty(value="database")
        String getDatabaseName() {
            return this.databaseName;
        }

        @JsonProperty(value="schema")
        String getSchemaName() {
            return this.schemaName;
        }

        @JsonProperty(value="channel_name")
        String getChannelName() {
            return this.channelName;
        }

        @JsonProperty(value="client_sequencer")
        Long getClientSequencer() {
            return this.clientSequencer;
        }
    }
}

