/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import net.snowflake.ingest.streaming.internal.SnowflakeStreamingIngestClientInternal;

public class ClientBufferParameters {
    private boolean enableParquetInternalBuffering;
    private long maxChunkSizeInBytes;
    private long maxAllowedRowSizeInBytes;

    private ClientBufferParameters(boolean enableParquetInternalBuffering, long maxChunkSizeInBytes, long maxAllowedRowSizeInBytes) {
        this.enableParquetInternalBuffering = enableParquetInternalBuffering;
        this.maxChunkSizeInBytes = maxChunkSizeInBytes;
        this.maxAllowedRowSizeInBytes = maxAllowedRowSizeInBytes;
    }

    public ClientBufferParameters(SnowflakeStreamingIngestClientInternal clientInternal) {
        this.enableParquetInternalBuffering = clientInternal != null ? clientInternal.getParameterProvider().getEnableParquetInternalBuffering() : false;
        this.maxChunkSizeInBytes = clientInternal != null ? clientInternal.getParameterProvider().getMaxChunkSizeInBytes() : 128000000L;
        this.maxAllowedRowSizeInBytes = clientInternal != null ? clientInternal.getParameterProvider().getMaxAllowedRowSizeInBytes() : 0x4000000L;
    }

    public static ClientBufferParameters test_createClientBufferParameters(boolean enableParquetInternalBuffering, long maxChunkSizeInBytes, long maxAllowedRowSizeInBytes) {
        return new ClientBufferParameters(enableParquetInternalBuffering, maxChunkSizeInBytes, maxAllowedRowSizeInBytes);
    }

    public boolean getEnableParquetInternalBuffering() {
        return this.enableParquetInternalBuffering;
    }

    public long getMaxChunkSizeInBytes() {
        return this.maxChunkSizeInBytes;
    }

    public long getMaxAllowedRowSizeInBytes() {
        return this.maxAllowedRowSizeInBytes;
    }
}

