/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.snowflake.client.jdbc.internal.google.common.collect.Sets;
import net.snowflake.ingest.streaming.OpenChannelRequest;
import net.snowflake.ingest.streaming.internal.AbstractRowBuffer;
import net.snowflake.ingest.streaming.internal.ChannelRuntimeState;
import net.snowflake.ingest.streaming.internal.ClientBufferParameters;
import net.snowflake.ingest.streaming.internal.ColumnMetadata;
import net.snowflake.ingest.streaming.internal.Flusher;
import net.snowflake.ingest.streaming.internal.LiteralQuoteUtils;
import net.snowflake.ingest.streaming.internal.ParquetChunkData;
import net.snowflake.ingest.streaming.internal.ParquetFlusher;
import net.snowflake.ingest.streaming.internal.ParquetTypeGenerator;
import net.snowflake.ingest.streaming.internal.ParquetValueParser;
import net.snowflake.ingest.streaming.internal.RowBufferStats;
import net.snowflake.ingest.streaming.internal.StreamingIngestUtils;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.SFException;
import org.apache.parquet.hadoop.BdecParquetWriter;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ParquetRowBuffer
extends AbstractRowBuffer<ParquetChunkData> {
    private static final String PARQUET_MESSAGE_TYPE_NAME = "bdec";
    private final Map<String, ParquetColumn> fieldIndex = new HashMap<String, ParquetColumn>();
    private final Map<String, String> metadata = new HashMap<String, String>();
    private final List<List<Object>> data = new ArrayList<List<Object>>();
    private BdecParquetWriter bdecParquetWriter;
    private ByteArrayOutputStream fileOutput;
    private final List<List<Object>> tempData = new ArrayList<List<Object>>();
    private final String channelName;
    private MessageType schema;

    ParquetRowBuffer(OpenChannelRequest.OnErrorOption onErrorOption, ZoneId defaultTimezone, String fullyQualifiedChannelName, Consumer<Float> rowSizeMetric, ChannelRuntimeState channelRuntimeState, ClientBufferParameters clientBufferParameters) {
        super(onErrorOption, defaultTimezone, fullyQualifiedChannelName, rowSizeMetric, channelRuntimeState, clientBufferParameters);
        this.channelName = fullyQualifiedChannelName;
    }

    @Override
    public void setupSchema(List<ColumnMetadata> columns) {
        this.fieldIndex.clear();
        this.metadata.clear();
        this.metadata.put("sfVer", "1,1");
        ArrayList<Type> parquetTypes = new ArrayList<Type>();
        int id = 1;
        for (ColumnMetadata column : columns) {
            this.validateColumnCollation(column);
            ParquetTypeGenerator.ParquetTypeInfo typeInfo = ParquetTypeGenerator.generateColumnParquetTypeInfo(column, id);
            parquetTypes.add(typeInfo.getParquetType());
            this.metadata.putAll(typeInfo.getMetadata());
            int columnIndex = parquetTypes.size() - 1;
            this.fieldIndex.put(column.getInternalName(), new ParquetColumn(column, columnIndex, typeInfo.getPrimitiveTypeName()));
            if (!column.getNullable()) {
                this.addNonNullableFieldName(column.getInternalName());
            }
            this.statsMap.put(column.getInternalName(), new RowBufferStats(column.getName(), column.getCollation()));
            if (this.onErrorOption == OpenChannelRequest.OnErrorOption.ABORT || this.onErrorOption == OpenChannelRequest.OnErrorOption.SKIP_BATCH) {
                this.tempStatsMap.put(column.getInternalName(), new RowBufferStats(column.getName(), column.getCollation()));
            }
            ++id;
        }
        this.schema = new MessageType(PARQUET_MESSAGE_TYPE_NAME, parquetTypes);
        this.createFileWriter();
        this.tempData.clear();
        this.data.clear();
    }

    private void createFileWriter() {
        this.fileOutput = new ByteArrayOutputStream();
        try {
            this.bdecParquetWriter = this.clientBufferParameters.getEnableParquetInternalBuffering() ? new BdecParquetWriter(this.fileOutput, this.schema, this.metadata, this.channelName, this.clientBufferParameters.getMaxChunkSizeInBytes()) : null;
            this.data.clear();
        }
        catch (IOException e) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "cannot create parquet writer", e);
        }
    }

    @Override
    boolean hasColumn(String name) {
        return this.fieldIndex.containsKey(name);
    }

    @Override
    float addRow(Map<String, Object> row, int bufferedRowIndex, Map<String, RowBufferStats> statsMap, Set<String> formattedInputColumnNames, long insertRowIndex) {
        return this.addRow(row, this::writeRow, statsMap, formattedInputColumnNames, insertRowIndex);
    }

    void writeRow(List<Object> row) {
        if (this.clientBufferParameters.getEnableParquetInternalBuffering()) {
            this.bdecParquetWriter.writeRow(row);
        } else {
            this.data.add(row);
        }
    }

    @Override
    float addTempRow(Map<String, Object> row, int curRowIndex, Map<String, RowBufferStats> statsMap, Set<String> formattedInputColumnNames, long insertRowIndex) {
        return this.addRow(row, this.tempData::add, statsMap, formattedInputColumnNames, insertRowIndex);
    }

    private float addRow(Map<String, Object> row, Consumer<List<Object>> out, Map<String, RowBufferStats> statsMap, Set<String> inputColumnNames, long insertRowsCurrIndex) {
        String columnName;
        Object[] indexedRow = new Object[this.fieldIndex.size()];
        float size = 0.0f;
        HashMap<String, RowBufferStats> forkedStatsMap = new HashMap<String, RowBufferStats>();
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            columnName = LiteralQuoteUtils.unquoteColumnName(key);
            ParquetColumn parquetColumn = this.fieldIndex.get(columnName);
            int colIndex = parquetColumn.index;
            RowBufferStats forkedStats = statsMap.get(columnName).forkEmpty();
            forkedStatsMap.put(columnName, forkedStats);
            ColumnMetadata column = parquetColumn.columnMetadata;
            ParquetValueParser.ParquetBufferValue valueWithSize = ParquetValueParser.parseColumnValueToParquet(value, column, parquetColumn.type, forkedStats, this.defaultTimezone, insertRowsCurrIndex);
            indexedRow[colIndex] = valueWithSize.getValue();
            size += valueWithSize.getSize();
        }
        long rowSizeRoundedUp = Double.valueOf(Math.ceil(size)).longValue();
        if (rowSizeRoundedUp > this.clientBufferParameters.getMaxAllowedRowSizeInBytes()) {
            throw new SFException(ErrorCode.MAX_ROW_SIZE_EXCEEDED, String.format("rowSizeInBytes:%.3f, maxAllowedRowSizeInBytes:%d, rowIndex:%d", Float.valueOf(size), this.clientBufferParameters.getMaxAllowedRowSizeInBytes(), insertRowsCurrIndex));
        }
        out.accept(Arrays.asList(indexedRow));
        for (Map.Entry forkedColStats : forkedStatsMap.entrySet()) {
            columnName = (String)forkedColStats.getKey();
            statsMap.put(columnName, RowBufferStats.getCombinedStats(statsMap.get(columnName), (RowBufferStats)forkedColStats.getValue()));
        }
        for (String columnName2 : Sets.difference(this.fieldIndex.keySet(), inputColumnNames)) {
            statsMap.get(columnName2).incCurrentNullCount();
        }
        return size;
    }

    @Override
    void moveTempRowsToActualBuffer(int tempRowCount) {
        this.tempData.forEach(this::writeRow);
    }

    @Override
    void clearTempRows() {
        this.tempData.clear();
    }

    @Override
    boolean hasColumns() {
        return !this.fieldIndex.isEmpty();
    }

    @Override
    Optional<ParquetChunkData> getSnapshot(String filePath) {
        this.metadata.put("primaryFileId", StreamingIngestUtils.getShortname(filePath));
        ArrayList<List<Object>> oldData = new ArrayList<List<Object>>();
        if (!this.clientBufferParameters.getEnableParquetInternalBuffering()) {
            this.data.forEach(r -> oldData.add(new ArrayList(r)));
        }
        return this.bufferedRowCount <= 0 ? Optional.empty() : Optional.of(new ParquetChunkData(oldData, this.bdecParquetWriter, this.fileOutput, this.metadata));
    }

    @Override
    Object getVectorValueAt(String column, int index) {
        if (this.data == null) {
            return null;
        }
        int colIndex = this.fieldIndex.get((Object)column).index;
        Object value = this.data.get(index).get(colIndex);
        ColumnMetadata columnMetadata = this.fieldIndex.get((Object)column).columnMetadata;
        String physicalTypeStr = columnMetadata.getPhysicalType();
        AbstractRowBuffer.ColumnPhysicalType physicalType = AbstractRowBuffer.ColumnPhysicalType.valueOf(physicalTypeStr);
        String logicalTypeStr = columnMetadata.getLogicalType();
        AbstractRowBuffer.ColumnLogicalType logicalType = AbstractRowBuffer.ColumnLogicalType.valueOf(logicalTypeStr);
        if (logicalType == AbstractRowBuffer.ColumnLogicalType.FIXED) {
            if (physicalType == AbstractRowBuffer.ColumnPhysicalType.SB1) {
                value = ((Integer)value).byteValue();
            }
            if (physicalType == AbstractRowBuffer.ColumnPhysicalType.SB2) {
                value = ((Integer)value).shortValue();
            }
            if (physicalType == AbstractRowBuffer.ColumnPhysicalType.SB16) {
                value = new BigDecimal(new BigInteger((byte[])value), columnMetadata.getScale());
            }
        }
        if (logicalType == AbstractRowBuffer.ColumnLogicalType.BINARY && value != null) {
            value = value instanceof String ? (Object)((String)value).getBytes(StandardCharsets.UTF_8) : value;
        }
        return value;
    }

    @Override
    int getTempRowCount() {
        return this.tempData.size();
    }

    @Override
    void reset() {
        super.reset();
        this.createFileWriter();
        this.data.clear();
    }

    @Override
    void closeInternal() {
        if (this.bdecParquetWriter != null) {
            try {
                this.bdecParquetWriter.close();
            }
            catch (IOException e) {
                throw new SFException(ErrorCode.INTERNAL_ERROR, "Failed to close parquet writer", e);
            }
        }
    }

    @Override
    public Flusher<ParquetChunkData> createFlusher() {
        return new ParquetFlusher(this.schema, this.clientBufferParameters.getEnableParquetInternalBuffering(), this.clientBufferParameters.getMaxChunkSizeInBytes());
    }

    private static class ParquetColumn {
        final ColumnMetadata columnMetadata;
        final int index;
        final PrimitiveType.PrimitiveTypeName type;

        private ParquetColumn(ColumnMetadata columnMetadata, int index, PrimitiveType.PrimitiveTypeName type) {
            this.columnMetadata = columnMetadata;
            this.index = index;
            this.type = type;
        }
    }
}

